/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorResources;
import org.springframework.validation.Errors;

/**
 * {@link jp.terasoluna.fw.validation.springmodules.DefaultValidatorFactoryEx}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * FieldChecksNXɂĎgpG[C^tF[X̎
 * Springt[[NErrorsNX߂̃NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.validation.springmodules.DefaultValidatorFactoryEx
 */
public class DefaultValidatorFactoryExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DefaultValidatorFactoryExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DefaultValidatorFactoryExTest(String name) {
        super(name);
    }

    /**
     * testGetValidator01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() beanName:null<br>
     *         () bean:null<br>
     *         () errors:null<br>
     *         
     * <br>
     * ҒlF(߂l) Validator:ValidatorCX^X<br>
     *                  validator.getParameterValue("jp.terasoluna.fw.validation.ValidationErrors")=<br>
     *                  SpringValidatorErrors.getErrors()Fnull<br>
     *                  validator.getParameterValue("java.lang.Object")=null<br>
     *                  validator.getFormName()=null<br>
     *         
     * <br>
     * null̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetValidator01() throws Exception {
        // O
        // beanName : null
        String beanName = null;
        
        // bean : null
        Object bean = null;
        
        // errors : null
        Errors errors = null;

        DefaultValidatorFactoryEx factory = new DefaultValidatorFactoryEx();
        
        // DefaultValidatorFactoryvalidatorResourcesݒ肷B
        ValidatorResources resources = new ValidatorResources();
        UTUtil.setPrivateField(factory, "validatorResources", resources);
        
        Validator validator = null;
        
        // eXg{
        validator = factory.getValidator(beanName, bean, errors);

        // 
        // errors : null
        SpringValidationErrors resultErorrs = 
            (SpringValidationErrors) validator.getParameterValue(
                    "jp.terasoluna.fw.validation.ValidationErrors");
        assertNull(resultErorrs.getErrors());
        
        // bean : null
        assertNull(validator.getParameterValue("java.lang.Object"));
        
        // beanName : null
        assertNull(validator.getFormName());
    }

    /**
     * testGetValidator02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() beanName:""<br>
     *         () bean:String("bean")<br>
     *         () errors:ErrorsCX^X<br>
     *         
     * <br>
     * ҒlF(߂l) Validator:ValidatorCX^X<br>
     *                  validator.getParameterValue
     *                  ("jp.terasoluna.fw.validation.ValidationErrors")=<br>
     *                  SpringValidatorErrors.getErrors()FErrorsCX^X<br>
     *                  validator.getParameterValue("java.lang.Object")=String("bean")<br>
     *                  validator.getFormName()=""<br>
     *         
     * <br>
     * beanName󕶎łAbeannot nullłAerrorsErrorsCX^X̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetValidator02() throws Exception {
        // O
        // beanName : ""
        String beanName = "";
        
        // bean : String("bean")
        Object bean = "bean";
        
        // errors : ErrorsCX^X
        Errors errors = new ErrorsImpl01();

        DefaultValidatorFactoryEx factory = new DefaultValidatorFactoryEx();
        
        // DefaultValidatorFactoryvalidatorResourcesݒ肷B
        ValidatorResources resources = new ValidatorResources();
        UTUtil.setPrivateField(factory, "validatorResources", resources);
        
        Validator validator = null;
        
        // eXg{
        validator = factory.getValidator(beanName, bean, errors);

        // 
        // errors : CX^X
        SpringValidationErrors resultErorrs = 
            (SpringValidationErrors) validator.getParameterValue(
                    "jp.terasoluna.fw.validation.ValidationErrors");
        assertSame(errors, resultErorrs.getErrors());
        
        // bean : new String("bean")
        assertSame(bean, validator.getParameterValue("java.lang.Object"));
        
        // beanName : ""
        assertEquals(beanName, validator.getFormName());
    }

    /**
     * testGetValidator03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() beanName:"beanName"<br>
     *         () bean:String("bean")<br>
     *         () errors:vf1ErrorsCX^X<br>
     *                {Object[0]=new Object}<br>
     *         
     * <br>
     * ҒlF(߂l) Validator:ValidatorCX^X<br>
     *                  validator.getParameterValue
     *                  ("jp.terasoluna.fw.validation.ValidationErrors")=<br>
     *                  SpringValidatorErrors.getErrors()F<br>
     *                  vf1ErrorsCX^X{Object[0]=new Object}<br>
     *                  validator.getParameterValue("java.lang.Object")=String("bean")<br>
     *                  validator.getFormName()="beanName"<br>
     *         
     * <br>
     * beanNamełAbeannot nullłAerrorsvf1ErrorsCX^X̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetValidator03() throws Exception {
        // O
        // beanName : "beanName"
        String beanName = "beanName";
        
        // bean : String("bean")
        Object bean = "bean";
        
        // errors : vf1ErrorsCX^X
        Errors errors = new ErrorsImpl01();
        List<Object> list = new ArrayList<Object>();
        list.add(0, new Object());
        UTUtil.setPrivateField(errors, "errors", list);

        DefaultValidatorFactoryEx factory = new DefaultValidatorFactoryEx();
        
        // DefaultValidatorFactoryvalidatorResourcesݒ肷B
        ValidatorResources resources = new ValidatorResources();
        UTUtil.setPrivateField(factory, "validatorResources", resources);
        
        Validator validator = null;
        
        // eXg{
        validator = factory.getValidator(beanName, bean, errors);

        // 
        // errors : CX^X
        SpringValidationErrors resultErorrs = 
            (SpringValidationErrors) validator.getParameterValue(
                    "jp.terasoluna.fw.validation.ValidationErrors");
        assertSame(errors, resultErorrs.getErrors());

        // bean : new String("bean")
        assertSame(bean, validator.getParameterValue("java.lang.Object"));
        
        // beanName : "beanName"
        assertEquals(beanName, validator.getFormName());
    }

    /**
     * testGetValidator04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() beanName:"beanName"<br>
     *         () bean:String("bean")<br>
     *         () errors:vf3ErrorsCX^X<br>
     *                {Object[0]=new Object,<br>
     *                Object[1]=new Object,<br>
     *                Object[2]=new Object}<br>
     *         
     * <br>
     * ҒlF(߂l) Validator:ValidatorCX^X<br>
     *                  validator.getParameterValue
     *                  ("jp.terasoluna.fw.validation.ValidationErrors")=<br>
     *                  SpringValidatorErrors.getErrors()Fvf1ErrorsCX^X<br>
     *                  {Object[0]=new Object,Object[1]=new Object,Object[2]=new Object}<br>
     *                  validator.getParameterValue("java.lang.Object")=String("bean")<br>
     *                  validator.getFormName()="beanName"<br>
     *         
     * <br>
     * beanNamełAbeannot nullłAerrorsvf3ErrorsCX^X̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetValidator04() throws Exception {
        // O
        // beanName : "beanName"
        String beanName = "beanName";
        
        // bean : String("bean")
        Object bean = "bean";
        
        // errors : vf3ErrorsCX^X
        Errors errors = new ErrorsImpl01();
        List<Object> list = new ArrayList<Object>();
        list.add(0, new Object());
        list.add(1, new Object());
        list.add(2, new Object());
        
        UTUtil.setPrivateField(errors, "errors", list);

        DefaultValidatorFactoryEx factory = new DefaultValidatorFactoryEx();
        
        // DefaultValidatorFactoryvalidatorResourcesݒ肷B
        ValidatorResources resources = new ValidatorResources();
        UTUtil.setPrivateField(factory, "validatorResources", resources);
        
        Validator validator = null;
        
        // eXg{
        validator = factory.getValidator(beanName, bean, errors);

        // 
        // errors : CX^X
        SpringValidationErrors resultErorrs = 
            (SpringValidationErrors) validator.getParameterValue(
                    "jp.terasoluna.fw.validation.ValidationErrors");
        assertSame(errors, resultErorrs.getErrors());

        // bean : new String("bean")
        assertSame(bean, validator.getParameterValue("java.lang.Object"));
        
        // beanName : "beanName"
        assertEquals(beanName, validator.getFormName());
    }
}