/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.response.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;

import jp.terasoluna.rich.functionsample.common.bean.StringBean;
import jp.terasoluna.rich.functionsample.response.bean.ResponseOutputData;


/**
 * X|XT[rXNX
 *
 */
public class ResponseServiceImpl implements ResponseService {

    /**
     * X|Xpʃf[^𐶐B
     *
     * @return X|Xpʃf[^
     */
    public ResponseOutputData execute() {
        
        ResponseOutputData result = new ResponseOutputData();
        
        String[] array = {"abc", "xyz"};
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("123");
        arrayList.add("098");
        StringBean[] beanArray = new StringBean[]{
            new StringBean("key1", "value1"),
            new StringBean("key2", "value2")};
        
        //X|Xpf[^̐ݒ
        result.setStringClass("string");
        result.setBooleanClass(new Boolean(true));
        result.setBooleanExample(true);
        result.setDoubleExample(10000D);
        result.setDoubleClass(new Double(11111D));
        result.setCharExample('a');
        result.setCharacterClass(new Character('A'));
        result.setFloatExample(-1.1F);
        result.setFloatClass(new Float(1.1F));
        result.setIntExample(123);
        result.setIntegerClass(new Integer(321));
        result.setLongExample(9223372036854775807L);
        result.setLongClass(new Long(-9223372036854775808L));
        result.setShortExample((short) 16);
        result.setShortClass(new Short((short) -16));
        result.setByteExample((byte) 127);
        result.setByteClass(new Byte((byte) -127));
        GregorianCalendar calendar =
            new GregorianCalendar(2006, 03, 10, 12, 12, 12);
        result.setDateClass(calendar.getTime());
        result.setBigDecimalClass(new BigDecimal(1111));
        result.setArrayClass(array);
        result.setArrayListClass(arrayList);
        result.setBeanArrayClass(beanArray);
        
        return result;
    }
    

}
