/*
 * Copyright (c) 2014 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.parser;

import org.apache.xerces.impl.Constants;
import org.exolab.castor.util.DTDResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/**
 * org.apache.xerces.parsers.SAXParser̃ZLAȃTuNXB
 * <p>
 * EntityResolverƂorg.exolab.castor.util.DTDResolverݒ肳ꂽꍇA
 * XMLf[^DTD܂ނƂeȂƂŁAXXEXML Bomb̐Ǝ㐫rB<br>
 * (org.exolab.castor.util.DTDResolveŕACastor}bsO`t@Cǂލۂɐݒ肳EntityResolverB)
 * </p>
 * <p>
 * ̃NXCastorŗp邱ƂOƂĂB<br>
 * NXpXcastor.propertiesɁA<br>
 * <code>
 * org.exolab.castor.parser=jp.terasoluna.fw.oxm.parser.DisallowDTDSecureSAXParser
 * </code><br>
 * ƋLq邱ƂŁÃNXgpB
 * </p>
 */
public class DisallowDTDSecureSAXParser extends AbstractSecureSAXParser {

    /**
     * RXgN^B
     * @throws SAXException@gpXercesɑzO̕ύXȂꍇA̗O͔ȂB
     */
    public DisallowDTDSecureSAXParser() throws SAXException {
        super();
    }

    /**
     * ZLA[hłKvꍇtrueԋpB
     * <p>
     * DTDResolver(TuNX܂)̃CX^XłtrueAłȂfalseԋpB
     * </p>
     * @param resolver@EntityResolver
     * @return ZLA[hłKvꍇtrueBȊOfalseB
     */
    @Override
    protected boolean needNotSecureMode(EntityResolver resolver) {

        // }bsO`t@C̓ǂݍݓA
        // dǂݍ݈ȊOŁACastorŎgpꍇYB
        return (resolver instanceof DTDResolver);
    }

    /**
     * ZLA[hɈڍsB
     * <p>
     * DTDeȂݒsB
     * </p>
     * @throws SAXException@gpXercesɑzO̕ύXȂꍇA̗O͔ȂB
     */
    @Override
    protected void toSecureMode() throws SAXException {

        // DTDeȂ(XXE & XML Bomb΍)
        // http://apache.org/xml/features/disallow-doctype-decl -> true
        setFeature(Constants.XERCES_FEATURE_PREFIX + Constants.DISALLOW_DOCTYPE_DECL_FEATURE, true);
    }

    /**
     * ʏ탂[hɈڍsB
     * <p>
     * DTDeȂݒB
     * </p>
     * @throws SAXException@gpXercesɑzO̕ύXȂꍇA̗O͔ȂB
     */
    @Override
    protected void toNormalMode() throws SAXException {

        // DTDeȂ(XXE & XML Bomb΍)ݒ
        // http://apache.org/xml/features/disallow-doctype-decl -> false
        setFeature(Constants.XERCES_FEATURE_PREFIX + Constants.DISALLOW_DOCTYPE_DECL_FEATURE, false);
    }
}
