/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * <code>Generics</code>߂̃[eBeBNXB
 *
 */
public class GenericsUtil {
    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(GenericsUtil.class);

    /**
     * NX̌^p[^̎ۂ̌^擾B
     * <p>
     * <h5>ۂ̌^̎擾̉</h5>
     * ̃NXŎۂ̌^擾ł̂́ANX錾Ŏۂ̌^
     * w肳ĂꍇłB NX錾Ŏۂ̌^w肳ĂȂꍇA
     * NX錾<code>WildCardType</code>
     * w肳ĂꍇAсAR[hŕϐ錾̍ۂɎۂ̌^
     * w肳Ăꍇ͎擾łȂB
     * <ul>
     *   <li>擾ł(qNX̂ŋ̃NXw肳Ă)
     *     <code><pre>
     *     public class Descendant extends Generic&lt;String, Integer&gt; {
     *        ...
     *     }
     *     </pre></code>
     * ̏ꍇA[<code>String</code>, <code>Integer</code>]
     * z񂪎擾ł
     *   </li>
     *   <li>擾ł(qNX̃NX錾Ŕz񂪎w肳Ă)
     *     <code><pre>
     *     public class Descendant extends Generic&lt;String[], Integer&gt; {
     *        ...
     *     }
     *     </pre></code>
     * ̏ꍇA[<code>String[]</code>, <code>Integer</code>]
     * z񂪎擾ł
     *   </li>
     *   <li>擾ł(qNX̃NX錾Ō^p[^̃NXw肳Ă)
     *     <code><pre>
     *     public class Descendant
     *         extends Generic&lt;String[], Map&lt;String, Object&gt;&gt; {
     *        ...
     *     }
     *     </pre></code>
     * ̏ꍇA[<code>String[]</code>, <code>Map</code>]
     * z񂪎擾ł
     *   </li>
     *   <li>擾łȂ(qNX̃NX錾Ō^p[^w肳Ă)
     *     <code><pre>
     *     public class Descendant&lt;P, Q&gt; extends Generic&lt;S, T&gt; {
     *        ...
     *     }
     *     </pre></code>
     *   </li>
     *   <li>擾łȂ(qNX̃NX錾ŃChJ[hw肳Ă)
     *     <code><pre>
     *     public class Descendant&lt;P extends String, Q super Bean&gt;
     *         extends Generic&lt;S, T&gt; {
     *        ...
     *     }
     *     </pre></code>
     *   </li>
     *   <li>擾łȂ(R[hŋ̃NXw肳Ă)
     *     <code><pre>
     *     Generic&lt;String, Integer&gt; descendant =
     *         new Generic&lt;String, Integer&gt;();
     *     </pre></code>
     *   </li>
     * </ul>
     * </p>
     * <p>
     * <h5>p̏ꍇ</h5>
     * <code>genericType</code><code>descendantClass</code>܂
     * ̌pꍇAۂ̌^擾邱ƂłB
     * <ul>
     *   <li>p̗
     *     <code><pre>
     *       public class Child&lt;S, T&gt; extends Generic&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class GrandChild&lt;S, T&gt; extends Child&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class Descendant extends GrandChild&lt;String, Integer&gt; {
     *          ...
     *       }
     * </pre></code>
     * ̏ꍇA[<code>String</code>, <code>Integer</code>]
     * z񂪎擾ł
     *   </li>
     * </ul>
     * </p>
     * <p>
     * <h5>^p[^̏ԂύXꂽꍇ</h5>
     * <code>genericType</code><code>descendantClass</code>܂ł
     * p̉ߒŌ^p[^̏ԂւꍇłA
     * <code>genercClass</code>Ő錾ꂽԂŎۂ̌^擾łB
     * <ul>
     *   <li>Ԃւꍇ̗
     *     <code><pre>
     *       public class Generic&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class Child&lt;A, T, B, S&gt; extends Generic&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class Descendant
     *            extends Generic&lt;Boolean, Integer, Double, String&gt; {
     *          ...
     *       }
     * </pre></code>
     * ̏ꍇA[<code>String</code>, <code>Integer</code>]
     * z񂪎擾ł
     *    </li>
     * </ul>
     * </p>
     *
     * @param <T> ^p[^錾NX̌^B
     * @param genericClass ^p[^錾NXB
     * @param descendantClass <code>genericsClass</code>pA
     *      ̓IȌ^p[^w肵NXB
     * @return ۂ̌^\<code>Class</code>CX^X̔zB
     *               Ԃ<code>genercClass</code>Ő錾ꂽԂłB
     * @throws IllegalArgumentException <code>genericClass</code>
     *      <code>null</code>̏ꍇB
     *      <code>descendantClass</code><code>null</code>̏ꍇB
     * @throws IllegalStateException
     *       <code>descendantClass</code>̎Ō^p[^
     *          ̃NXƂĎw肳ĂȂꍇB
     *      <code>genercClass</code>^p[^錾NXł
     *      ȂꍇB
     */
    @SuppressWarnings("unchecked")
    public static <T>  Class[] resolveParameterizedClass(
            Class<T> genericClass, Class<? extends T> descendantClass)
            throws IllegalArgumentException, IllegalStateException {
        if (genericClass == null) {
            throw new IllegalArgumentException(
                    "Argument 'genericsClass' ("
                    + Class.class.getName() + ") is null");
        }
        if (descendantClass == null) {
            throw new IllegalArgumentException(
                    "Argument 'descendantClass'("
                    + Class.class.getName() + ") is null");
        }

        List<ParameterizedType> ancestorTypeList =
                getAncestorTypeList(genericClass, descendantClass);

        ParameterizedType parameterizedType =
            ancestorTypeList.get(ancestorTypeList.size() - 1);
        // parameterizedType̎ۂ̌^\ Type IuWFNg̔z
        // FAbstractBLogic<P, R>̌^PRB
        Type[] actualTypes = parameterizedType.getActualTypeArguments();

        // CX^XŐ錾ꂽ^p[^ۂ̌^ɉB
        Class[] actualClasses = new Class[actualTypes.length];
        for (int i = 0; i < actualTypes.length; i++) {
            // actualTypes[i]iԖڂ̌^B
            // ancestorList^p[^錾ĂNX̃XgB
            actualClasses[i] =
                resolveTypeVariable(actualTypes[i], ancestorTypeList);
        }
        return actualClasses;
    }

    /**
     * ^p[^̎ۂ̌^擾B
     * <p>
     * <h5>ۂ̌^̎擾̉</h5>
     * ̃NXŎۂ̌^擾ł̂́ANX錾Ŏۂ̌^
     * w肳ĂꍇłB NX錾Ŏۂ̌^w肳ĂȂꍇA
     * NX錾<code>WildCardType</code>
     * w肳ĂꍇAсAR[hŕϐ錾̍ۂɎۂ̌^
     * w肳Ăꍇ͎擾łȂB
     * <ul>
     *   <li>擾ł(qNX̂ŋ̃NXw肳Ă)
     *     <code><pre>
     *     public class Descendant extends Generic&lt;String, Integer&gt; {
     *        ...
     *     }
     *     </pre></code>
     * ̏ꍇA<code>String</code>܂<code>Integer</code>
     * 擾ł
     *   </li>
     *   <li>擾ł(qNX̃NX錾Ŕz񂪎w肳Ă)
     *     <code><pre>
     *     public class Descendant extends Generic&lt;String[], Integer&gt; {
     *        ...
     *     }
     *     </pre></code>
     * ̏ꍇA<code>String[]</code>܂<code>Integer</code>
     * 擾ł
     *   </li>
     *   <li>擾ł(qNX̃NX錾Ō^p[^̃NXw肳Ă)
     *     <code><pre>
     *     public class Descendant
     *         extends Generic&lt;String[], Map&lt;String, Object&gt;&gt; {
     *        ...
     *     }
     *     </pre></code>
     * ̏ꍇA<code>String[]</code>܂<code>Map</code>
     * 擾ł
     *   </li>
     *   <li>擾łȂ(qNX̃NX錾Ō^p[^w肳Ă)
     *     <code><pre>
     *     public class Descendant&lt;P, Q&gt; extends Generic&lt;S, T&gt; {
     *        ...
     *     }
     *     </pre></code>
     *   </li>
     *   <li>擾łȂ(qNX̃NX錾ŃChJ[hw肳Ă)
     *     <code><pre>
     *     public class Descendant&lt;P extends String, Q super Bean&gt;
     *         extends Generic&lt;S, T&gt; {
     *        ...
     *     }
     *     </pre></code>
     *   </li>
     *   <li>擾łȂ(R[hŋ̃NXw肳Ă)
     *     <code><pre>
     *     Generic&lt;String, Integer&gt; descendant =
     *         new Generic&lt;String, Integer&gt;();
     *     </pre></code>
     *   </li>
     * </ul>

     * </p>
     * <p>
     * <h5>p̏ꍇ</h5>
     * <code>genericType</code><code>descendantClass</code>܂
     * ̌pꍇAۂ̌^擾邱ƂłB
     * <ul>
     *   <li>p̗
     *     <code><pre>
     *       public class Child&lt;S, T&gt; extends Generic&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class GrandChild&lt;S, T&gt; extends Child&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class Descendant extends GrandChild&lt;String, Integer&gt; {
     *          ...
     *       }
     * </pre></code>
     * ̏ꍇA<code>String</code>܂<code>Integer</code>
     * 擾ł
     *   </li>
     * </ul>
     * </p>
     * <p>
     * <h5>^p[^̏ԂύXꂽꍇ</h5>
     * <code>genericType</code><code>descendantClass</code>܂ł
     * p̉ߒŌ^p[^̏ԂւꍇłA
     * <code>genercClass</code>Ő錾ꂽԂŎۂ̌^擾łB
     * <ul>
     *   <li>Ԃւꍇ̗
     *     <code><pre>
     *       public class Generic&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class Child&lt;A, T, B, S&gt; extends Generic&lt;S, T&gt; {
     *          ...
     *       }
     *
     *       public class Descendant
     *            extends Generic&lt;Boolean, Integer, Double, String&gt; {
     *          ...
     *       }
     * </pre></code>
     * ̏ꍇA<code>String</code>܂<code>Integer</code>
     * 擾ł
     *    </li>
     * </ul>
     * </p>
     *
     * @param <T> ^p[^錾NX̌^B
     * @param genericClass ^p[^錾NXB
     * @param descendantClass <code>genericsClass</code>pA
     *      ̓IȌ^p[^w肵NXB
     * @param index ۂ̌^擾^p[^̐錾B
     * @return ۂ̌^\<code>Class</code>CX^XB
     * @throws IllegalArgumentException <code>genericClass</code>
     *      <code>null</code>̏ꍇB
     *      <code>descendantClass</code><code>null</code>̏ꍇB
     *      <code>index</code><code>0</code>菬A܂́A
     *      錾ꂽ^p[^ȏ̏ꍇB
     * @throws IllegalStateException
     *       <code>descendantClass</code>̎Ō^p[^
     *          ̃NXƂĎw肳ĂȂꍇB
     *      <code>genercClass</code>^p[^錾NXł
     *      ȂꍇB
     */
    @SuppressWarnings("unchecked")
    public static <T> Class resolveParameterizedClass(
            Class<T> genericClass, Class<? extends T> descendantClass,
            int index)
            throws IllegalArgumentException, IllegalStateException {
        if (genericClass == null) {
            throw new IllegalArgumentException(
                    "Argument 'genericsClass' ("
                    + Class.class.getName() + ") is null");
        }
        if (descendantClass == null) {
            throw new IllegalArgumentException(
                    "Argument 'descendantClass'("
                    + Class.class.getName() + ") is null");
        }

        List<ParameterizedType> ancestorTypeList =
                getAncestorTypeList(genericClass, descendantClass);

        ParameterizedType parameterizedType =
            ancestorTypeList.get(ancestorTypeList.size() - 1);
        // parameterizedType̎ۂ̌^\ Type IuWFNg̔z
        // FAbstractBLogic<P, R>̌^PRB
        Type[] actualTypes = parameterizedType.getActualTypeArguments();

        // CX^XŐ錾ꂽ^p[^ۂ̌^ɉB
        if (index < 0 || index >= actualTypes.length) {
            throw new IllegalArgumentException(
                    "Argument 'index'(" + Integer.toString(index)
                    + ") is out of bounds of"
                    + " generics parameters");
        }

        // actualTypes[index]indexԖڂ̌^B
        // ancestorList^p[^錾ĂNX̃XgB
        return resolveTypeVariable(actualTypes[index], ancestorTypeList);
    }

    /**
     * ̌^^p[^錾NX܂ł
     * <code>ParameterizedType</code>̃Xg擾B
     *
     * @param <T> ^p[^錾NX̌^B
     * @param genericClass ^p[^錾NXB
     * @param descendantClass <code>genericsClass</code>pA
     *      ̓IȌ^p[^w肵NXB
     * @return ̌^^p[^錾NX܂ł
     *      <code>ParameterizedType</code>̃XgB
     * @throws IllegalStateException <code>descendantClass</code>
     *      Ō^p[^̃NXƂĎw肳ĂȂꍇB
     *      <code>genercClass</code>^p[^錾NXł
     *      ȂꍇB
     */
    @SuppressWarnings("unchecked")
    protected static <T> List<ParameterizedType> getAncestorTypeList(
            Class<T> genericClass, Class<? extends T> descendantClass)
           throws IllegalStateException {
        List<ParameterizedType> ancestorTypeList =
            new ArrayList<ParameterizedType>();
        Class clazz = descendantClass;
        boolean isInterface = genericClass.isInterface();

        while (clazz != null) {
            Type type = clazz.getGenericSuperclass();
            if (checkParameterizedType(type, genericClass, ancestorTypeList)) {
                break;
            }

            // ^p[^錾NXC^tF[X̏ꍇA
            // C^tF[XɂĂ`FbNsB
            if (!isInterface) {
                clazz = clazz.getSuperclass();
                continue;
            }
            if (checkInterfaceAncestors(
                    genericClass, ancestorTypeList, clazz)) {
                break;
            }

            // NX̃C^tF[XɁAw肵C^tF[X݂Ȃ
            // ꍇɔāAeNX`FbNΏۂɂB
            // 󂱂̉ӏʉ߂邱Ƃ͂ȂƎvB
            // Ô߁A`FbNcĂB
            // ŔAGenerics̃tNVAPIɂĂ͎sł邽߂łB
            // 肪ꍇ́A폜邱ƁB
            clazz = clazz.getSuperclass();
        }

        // ^p[^錾ĂNX̃CX^X擾B
        // FAbstractBLogic<P, R>NXB
        if (ancestorTypeList.isEmpty()) {
            throw new IllegalStateException(
                    "Argument 'genericClass'("
                    + genericClass.getName()
                    + ") does not declare type parameter");
        }

        // ̉ӏ̃`FbNŗOoꍇ͂ȂƎv邪A
        // Ô߁A`FbNcĂB
        // ŔAGenerics̃tNVAPIɂĂ͎sł邽߂łB
        // 肪ꍇ́A폜邱ƁB
        ParameterizedType targetType =
            ancestorTypeList.get(ancestorTypeList.size() - 1);
        if (!targetType.getRawType().equals(genericClass)) {
            throw new IllegalStateException("Class("
                    + descendantClass.getName()
                    + ") is not concrete class of Class("
                    + genericClass.getName() + ")");
        }
        return ancestorTypeList;
    }

    /**
     * C^tF[X^^p[^錾NX܂ł
     * <code>ParameterizedType</code>̃Xg擾B
     *
     * @param <T> ^p[^錾NX̌^B
     *
     * @param genericClass ^p[^錾NXB
     * @param ancestorTypeList <code>ParameterizedType</code>
     *      ǉ郊XgB
     * @param clazz Ώۂ̃C^tF[X^B
     * @return ^p[^錾NXꍇ<code>true</code>B
     *      Ȃꍇ<code>false</code>B
     */
    @SuppressWarnings("unchecked")
    protected static <T> boolean checkInterfaceAncestors(Class<T> genericClass,
            List<ParameterizedType> ancestorTypeList, Class clazz) {
        boolean genericTypeFound = false;
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (Type interfaceType : interfaceTypes) {
            genericTypeFound = checkParameterizedType(
                    interfaceType, genericClass, ancestorTypeList);
            if (genericTypeFound) {
                return true;
            }
            Class[] interfaces = clazz.getInterfaces();
            for (Class interfaceClass : interfaces) {
                if (checkInterfaceAncestors(
                        genericClass, ancestorTypeList, interfaceClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * <code>Type</code>^`FbNA<code>ParameterizedType</code>
     * A^p[^錾NX̃TuNXłꍇAXgɒǉB
     *
     * @param <T> ^p[^錾NX̌^B
     *
     * @param type Ώۂ̌^B
     * @param genericClass ^p[^錾NXB
     * @param ancestorTypeList <code>ParameterizedType</code>
     *      ǉ郊XgB
     * @return <code>type</code>^p[^錾NXƓNX̏ꍇB
     */
    @SuppressWarnings("unchecked")
    protected static <T> boolean checkParameterizedType(
            Type type, Class<T> genericClass,
            List<ParameterizedType> ancestorTypeList) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }

        // ParameterizedTypẽCX^XłꍇAParameterizedType
        // ɃLXgB
        ParameterizedType parameterlizedType = (ParameterizedType) type;

        // C^tF[XGenerics̏ꍇAقȂParameterizedType
        // n邩Ȃ̂Ń`FbNB
        // Ał͈قȂ̂n邱Ƃ͂ȂƎvB
        // Ô߁A`FbNcĂB
        // ŔAGenerics̃tNVAPIɂĂ͎sł邽߂łB
        // 肪ꍇ́A폜邱ƁB
        if (!genericClass.isAssignableFrom(
                (Class) parameterlizedType.getRawType())) {
            return false;
        }
        ancestorTypeList.add(parameterlizedType);

        // #getRawType^p[^錾̂ȂType擾B
        if (parameterlizedType.getRawType().equals(genericClass)) {
            return true;
        }
        return false;
    }

    /**
     * ^p[^̋̓I<code>Type</code>擾B
     *
     * @param type Kv̂<code>Type</code>CX^XB
     * @param ancestorTypeList <code>type</code>̋̓IȌ^
     *      錾Ă\̂<code>ParameterizedType</code>̃XgB
     * @return š^ϐB
     * @throws IllegalStateException <code>type</code>
     *      <code>Class</code>^AсA
     *      <code>TypeVariable</code>^ł͂ȂꍇB
     *      <code>type</code>\bhA
     *      ܂́ARXgN^Ő錾ĂꍇB
     *      <code>type</code>̎ۂ̌^<code>Class</code>ł͂Ȃ
     *      (ChJ[hAz)ꍇB
     */
    @SuppressWarnings("unchecked")
    protected static Class resolveTypeVariable (Type type,
            List<ParameterizedType> ancestorTypeList)
            throws IllegalStateException {

        if (isNotTypeVariable(type)) {
            return getRawClass(type);
        }

        // TypeVariable:^ϐ`C^tF[XB
        TypeVariable targetType = (TypeVariable) type;
        Type actualType = null;
        for (int i = ancestorTypeList.size() - 1; i >= 0; i--) {
            ParameterizedType ancestorType = ancestorTypeList.get(i);

            // ^p[^錾ĂNX擾
            GenericDeclaration declaration = targetType.getGenericDeclaration();
            if (!(declaration instanceof Class)) {
                throw new IllegalStateException("TypeVariable("
                        + targetType.getName() + " is not declared at Class "
                        + "(ie. is declared at Method or Constructor)");
            }

            // cNXGenerics̐錾łȂꍇ͔΂B
            Class declaredClass = (Class) declaration;
            if (declaredClass != ancestorType.getRawType()) {
                continue;
            }

            // ^p[^̐錾āAꂽ^擾B
            // FConcreteAbstractBLogic<R,P> extends AbstractBLogic<P,R>
            //      ̂悤ȏꍇɐtypeɑΉp[^oB
            Type[] parameterTypes = declaredClass.getTypeParameters();
            int index = ArrayUtils.indexOf(parameterTypes, targetType);
            if (index == -1) {
                // ̉ӏ̃`FbNŗOoꍇ͂ȂƎv邪A
                // Ô߁A`FbNcĂB
                // ŔAGenerics̃tNVAPIɂĂ͎sł邽߂łB
                // 肪ꍇ́A폜邱ƁB
                throw new IllegalStateException("Class("
                        + declaredClass.getName()
                        + ") does not declare TypeValidable("
                        + targetType.getName() + ")");
            }
            actualType = ancestorType.getActualTypeArguments()[index];
            if (log.isDebugEnabled()) {
                log.debug("resolved " + targetType.getName()
                        + " -> " + actualType);
            }

            if (isNotTypeVariable(actualType)) {
                return getRawClass(actualType);
            }
            targetType = (TypeVariable) actualType;
        }

        throw new IllegalStateException("Concrete type of Type(" + type
                + ") was not found in ancestorList("
                + ancestorTypeList + ")");
    }

    /**
     * <code>type</code><code>Class</code>^
     * ł邩A<code>TypeVariable</code>^𔻒肷B
     *
     * @param type <code>Type</code>CX^XB
     * @return <code>type</code>
     *      <code>Class, ParameterizedType, GenericArrayType</code>̏ꍇ
     *        <code>true</code>B
     *      <code>type</code><code>TypeVariable</code>̏ꍇ
     *        <code>false</code>B
     * @throws IllegalStateException <code>type</code>
     *      <code>Class</code>A<code>ParameterizedType</code>A
     *      <code>GenericArrayType</code>A<code>TypeVariable</code>
     *      łȂꍇB
     */
    protected static boolean isNotTypeVariable(Type type)
        throws IllegalStateException {
        if (type instanceof Class) {
            return true;
        } else if (type instanceof TypeVariable) {
            return false;
        } else if (type instanceof ParameterizedType) {
            return true;
        } else if (type instanceof GenericArrayType) {
            return true;
        }
        throw new IllegalStateException("Type("
                + type + ") is not instance of "
                + TypeVariable.class.getName() + ", "
                + ParameterizedType.class.getName() + ", "
                + GenericArrayType.class.getName() + " nor "
                + Class.class.getName());
    }

    /**
     * <code>type</code>̎ۂ̌^ԋpB
     *
     * @param type <code>Type</code>CX^XB
     * @return <code>Class</code>CX^XB
     * @throws IllegalStateException <code>type</code>
     *      <code>Class</code>A<code>ParameterizedType</code>A
     *      <code>GenericArrayType</code>̂łȂꍇB
     */
    @SuppressWarnings("unchecked")
    protected static Class getRawClass(Type type)
            throws IllegalStateException {
        if (type instanceof Class) {
            return (Class) type;
        } else if (type instanceof ParameterizedType) {
            return getRawClass(((ParameterizedType) type).getRawType());
        } else if (type instanceof GenericArrayType) {
            Type componentType =
                ((GenericArrayType) type).getGenericComponentType();
            Class componentClass = getRawClass(componentType);
            return Array.newInstance(componentClass, 0).getClass();
        }
        throw new IllegalStateException("Type("
                + type + ") is not instance of "
                + ParameterizedType.class.getName() + ", "
                + GenericArrayType.class.getName() + " nor "
                + Class.class.getName());
    }

}
