/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;


/**
 * ^ϊs߂̃[eBeBNXB
 * 
 */
public class ConvertUtil {

    /**
     * <code>class</code>tB[h\tB[h
     */
    public static final String CLASS_FIELDNAME = "class";

    /**
     * IuWFNgzɕϊB
     * <ul>
     *   <li><code>null</code>̏ꍇ - <code>Object[0]</code>ԋp</li>
     *   <li><code>Object[]</code>̏ꍇ - ̂܂ܕԋp</li>
     *   <li><code>Collection</code>̏ꍇ - zɕϊĕԋp</li>
     *   <li>ȊȌꍇ - vf1zƂĕԋp</li>
     * </ul>
     * 
     * <p>
     * ^ۏႳꂽz񂪗~ꍇ́A{@link #toList(Object, Class)}
     * gpāAL̂悤ɂ邱ƁB
     * <code><pre>
     * List<String> list = ConvertUtil.toList(value, String.class);
     * String[] array = list.toArray(new String[list.size()]);
     * </pre></code>
     * </p>
     * 
     * @param obj IuWFNgB
     * @return IuWFNgϊzB
     */
    public static Object[] toArray(Object obj) {
        if (obj == null) {
            return new Object[0];
        } else if (obj.getClass().isArray()) {
            return (Object[]) obj;
        } else if (obj instanceof Collection) {
            return ((Collection) obj).toArray();
        }
        return new Object[]{ obj };
    }

    /**
     * IuWFNgXgɕϊB
     * <ul>
     *   <li><code>null</code>̏ꍇ - vfȂ<code>T</code>^̃XgƂĕԋp</li>
     *   <li><code>Object[]</code>̏ꍇ - <code>T</code>^̃Xgɕϊĕԋp</li>
     *   <li><code>Collection</code>̏ꍇ - <code>T</code>^̃XgƂĕԋp</li>
     *   <li>ȊȌꍇ - vf1<code>T</code>^̃XgƂĕԋp</li>
     * </ul>
     * 
     * @param <E> ԋp郊Xg̗vf\^B
     * @param obj IuWFNgB
     * @param elementClass ԋp郊Xg̗vf\^B 
     * @return IuWFNgϊXgB
     * @throws IllegalArgumentException <code>clazz</code>
     *           <code>null</code>̏ꍇ
     *           <code>obj</code>܂́A̗vf<code>T</code>^
     *           ł͂ȂꍇB
     */
    @SuppressWarnings("unchecked")
    public static <E> List<E> toList(Object obj, Class<E> elementClass)
            throws IllegalArgumentException {
        if (elementClass == null) {
            throw new IllegalArgumentException("Argument 'elementClass' ("
                    +  Class.class.getName() + ") is null");
        }
        
        Object[] array = toArray(obj);
        List<E> result = new ArrayList<E>();
        for (Object element : array) {
            if (element != null
                    && !elementClass.isAssignableFrom(element.getClass())) {
                String message = "Unable to cast '"
                    + element.getClass().getName()
                    + "' to '" + elementClass.getName() + "'";
                throw new IllegalArgumentException(
                        message, new ClassCastException(message));
            }
            result.add((E) element);
        }
        return result;
    }

    /**
     * IuWFNg<code>T</code>^ɕϊB
     * 
     * @param <T> ϊ̌^B
     * @param obj IuWFNgB
     * @param clazz ϊ̌^B
     * @return ϊ̃IuWFNgB
     * @throws IllegalArgumentException ϊɎsꍇB
     */
    public static <T> T convert(Object obj, Class<T> clazz)
            throws IllegalArgumentException {
        return convert(obj, clazz, true);
    }

    /**
     * <code>null</code>ł͂ȂIuWFNg
     * <code>T</code>^ɕϊB
     * <p>
     * v~eBu^ɑΉlȂǂ̕ϊɗpB
     * </p>
     * 
     * @param <T> ϊ̌^B
     * @param obj IuWFNgB
     * @param clazz ϊ̌^B
     * @return ϊ̃IuWFNgB
     * @throws IllegalArgumentException ϊɎsꍇB
     *      <code>obj</code><code>null</code>̏ꍇB
     */
    public static <T> T convertIfNotNull(Object obj, Class<T> clazz)
            throws IllegalArgumentException {
        return convert(obj, clazz, false);
    }
    
    /**
     * IuWFNg<code>T</code>^ɕϊB
     * <p>
     * <ul>
     *  <li><code>allowsNull</code><code>false</code>
     *        <code>obj</code><code>null</code> - OX[B
     *  <li><code>allowsNull</code><code>true</code>
     *        <code>obj</code><code>null</code> - <code>null</code>ԋpB
     *  <li><code>obj</code><code>clazz</code>^ - ̂܂ܕԋpB
     *  <li><code>obj</code><code>clazz</code>^ł͂Ȃ
     *        - <code>ConvertUtils</code>gpēK؂Ȍ^ɕϊĕԋpB
     * </ul>
     * </p>
     * 
     * @param <T> ϊ̌^B
     * @param obj IuWFNgB
     * @param clazz ϊ̌^B
     * @param allowsNull <code>obj</code><code>null</code>
     *      ꍇe邩ǂB
     * @return ϊ̃IuWFNgB
     * @throws IllegalArgumentException <code>clazz</code>
     *      <code>null</code>̏ꍇB
     *      <code>allowsNull</code><code>false</code>
     *        <code>obj</code><code>null</code>̏ꍇB
     *      ϊɎsꍇB
     */
    @SuppressWarnings("unchecked")
    public static <T> T convert(
            Object obj, Class<T> clazz, boolean allowsNull)
            throws IllegalArgumentException {

        if (clazz == null) {
            throw new IllegalArgumentException("Argument 'clazz' ("
                    +  Object.class.getName() + ") is null");
        }

        if (obj == null) {
            if (!allowsNull) {
                String message =
                    "Unable to cast 'null' to '" + clazz.getName() + "'";
                throw new IllegalArgumentException(
                        message, new ClassCastException(message));
            }
            return null;
        }

        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T) obj;
        }
        
        Object result = null;
        try {
            result = ConvertUtils.convert(obj.toString(), clazz);
        } catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
        return (T) result;
    }

    /**
     * <code>value</code>v~eBu^̔zł΁A
     * vf<code>String</code>ɕϊ<code>List</code>Ɋi[
     * 郆[eBeB\bhB
     * 
     * @param value v~eBu^̔zB
     * @return v~eBu^̔z̏ꍇASvfi[<code>List</code>B
     *          ȊȌꍇ͈<code>value</code>̂́B
     */
    public static Object convertPrimitiveArrayToList(Object value) {
        if (value == null) {
            return value;
        }
        Class type = value.getClass().getComponentType();
        
        // valuez^ł͂Ȃꍇ
        if (type == null) {
            return value;
        }
        
        // z̗vfv~eBu^ł͂Ȃꍇ
        if (!type.isPrimitive()) {
            return value;
        }
        
        List<Object> list = new ArrayList<Object>();
        
        if (value instanceof boolean[]) {
            for (boolean data : (boolean[]) value) {
                // String^ɕϊKv͂ȂB
                list.add(data);
            }
        } else if (value instanceof byte[]) {
            for (byte data : (byte[]) value) {
                list.add(Byte.toString(data));
            }
        } else if (value instanceof char[]) {
            for (char data : (char[]) value) {
                list.add(Character.toString(data));
            }
        } else if (value instanceof double[]) {
            for (double data : (double[]) value) {
                list.add(Double.toString(data));
            }
        } else if (value instanceof float[]) {
            for (float data : (float[]) value) {
                list.add(Float.toString(data));
            }
        } else if (value instanceof int[]) {
            for (int data : (int[]) value) {
                list.add(Integer.toString(data));
            }
        } else if (value instanceof long[]) {
            for (long data : (long[]) value) {
                list.add(Long.toString(data));
            }
        } else if (value instanceof short[]) {
            for (short data : (short[]) value) {
                list.add(Short.toString(data));
            }
        } 
        return list;
    }

    /**
     * IuWFNg̃RNV܂͔z}bṽXgɕϊB
     * <p>
     * Xg̗vfł}bv{@link #CLASS_FIELDNAME}SĂ
     * tB[hɂāAtB[hL[ƂlB
     * AtB[h啶Ŏn܂ĂꍇAŏ1
     * ɕϊ̂Œӂ邱ƁB
     * </p>
     * <ul>
     *   <li><code>null</code>̏ꍇ - vfȂ}bṽXgƂĕԋp</li>
     *   <li><code>Object[]</code>̏ꍇ - }bṽXgɕϊĕԋp</li>
     *   <li><code>Collection</code>̏ꍇ - }bṽXgƂĕԋp</li>
     *   <li>ȊȌꍇ - vf1}bṽXgƂĕԋp</li>
     * </ul>
     * @param obj IuWFNgB
     * @return IuWFNgϊ}bṽXgB
     * @throws IllegalArgumentException ϊɗ\ȂOꍇB
     */
    @SuppressWarnings("unchecked")
    public static List<Map<String, Object>> toListOfMap(Object obj)
            throws IllegalArgumentException {
        Object[] array = ConvertUtil.toArray(obj);
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object object : array) {
            
            Map<String, Object> map = null;
            if (object instanceof Map) {
                map = (Map) object;
            } else {
                try {
                    map = PropertyUtils.describe(object);
                } catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                } catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                } catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            map.remove(CLASS_FIELDNAME);
            result.add(map);
        }
    
        return result;
    }
}
