/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 *  (String)ACX^X𐶐郆[eBeBNXB
 * 
 * <li>ʏ̃CX^X</li>
 * <code><pre>
 *     Integer integer = new Integer("12");
 * </pre></code>
 * 
 * <li>ʏ̕(String)̃CX^X</li>
 * <code><pre>
 *     Integer integer = null;
 * 
 *     Class createClass = null;
 *     Class paramClass = null;
 * 
 *     //NX[_擾
 *     Thread t = Thread.currentThread();
 *     ClassLoader cl = t.getContextClassLoader();
 * 
 *     try {
 * 
 *         //NXClassIuWFNg擾
 *         createClass = cl.loadClass("java.lang.Integer");
 *         //RXgN^̈ƂȂNXClassIuWFNg擾
 *         paramClass = cl.loadClass("java.lang.String");
 * 
 *     } catch(ClassNotFoundException e) {
 *         //NXt@CȂꍇB
 *     }
 * 
 *     try {
 * 
 *         //ConstructorIuWFNg擾
 *         Constructor constructor =
 *             classObject.getConstructor(new Class[]{paramClassObject});
 * 
 *     } catch(NoSuchMethodException e) {
 *         //w肳ꂽ`RXgN^ꍇ
 *     } catch(SecurityException e) {
 *         //ւ̃ANZXۂꂽꍇ
 *     }
 * 
 *     try {
 * 
 *         //CX^X̐
 *         integer = constructor.newInstance(new Object{"12"});
 * 
 *     } catch (IllegalArgumentException e) {
 *         //sȈnꂽꍇ
 *     } catch (InstantiationException e) {
 *         //ۃNXꍇ
 *     } catch (IllegalAccessException e) {
 *         //RXgN^ɃANZXoȂꍇ
 *     } catch (InvocationTargetException e) {
 *         //RXgN^OX[ꍇ
 *     }
 * 
 * </pre></code>
 * 
 * <li>̃NXgpꍇ̃CX^X</li>
 * <code><pre>
 *     Integer integer = null;
 * 
 *     try {
 *         integer = (Integer) ClassUtil.create(
 *             "java.lang.Integer", new Object[] {"12"});
 *     } catch(ClassLoadException e) {
 *         //CX^XɗOꍇ
 *     }
 * </pre></code>
 * 
 * @see jp.terasoluna.fw.util.ClassLoadException
 * 
 */
public final class ClassUtil {

    /**
     * IuWFNg̃NXɃCX^X𐶐܂B
     * 
     * NX null œnꂽꍇA
     *  NullPointerException X[܂B
     * @param className
     * IuWFNg̃NX
     * @return
     * CX^X
     * @throws ClassLoadException
     * CX^XɔObvO
     */
    public static Object create(String className) throws ClassLoadException {

        // QƂ𐶐
        Object object = null;

        // NX[_擾
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();

        try {
            // ClassCX^X𐶐AIuWFNg𐶐B
            object = cl.loadClass(className).newInstance();

        } catch (InstantiationException e) {
            // ۃNXꍇ
            throw new ClassLoadException(e);
        } catch (IllegalAccessException e) {
            // RXgN^ɃANZXoȂꍇ
            throw new ClassLoadException(e);
        } catch (ClassNotFoundException e) {
            // *.classt@CȂꍇ
            throw new ClassLoadException(e);
        }

        // ꂽIuWFNgԂB
        return object;
    }

    /**
     * IuWFNg̃NXɃCX^X𐶐܂B
     * 
     * NX null œnꂽꍇA
     *  NullPointerException X[܂B
     * @param className
     * IuWFNg̃NX
     * @param constructorParameter
     * IuWFNg̃RXgN^̃p[^<br>
     * (:)̃p[^͐IuWFNg̈̏ԂƑΉKv܂B
     * @return
     * CX^X
     * @throws ClassLoadException
     * CX^XɔObvO
     */
    public static Object create(String className,
                                 Object[] constructorParameter)
                                 throws ClassLoadException {

        // QƂ̐
        Constructor[] constructors = null;

        // NX[_擾
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();

        try {
            // ClassCX^X̎A
            //SẴRXgN^IuWFNg擾B
            constructors = cl.loadClass(className).getConstructors();
        } catch (SecurityException e) {
            // ւ̃ANZXۂꂽꍇ
            throw new ClassLoadException(e);
        } catch (ClassNotFoundException e) {
            // *.classt@CȂꍇ
            throw new ClassLoadException(e);
        }

        // Cӂ̃IuWFNg܂ŁA
        // SẴRXgN^IuWFNg݂̐
        for (int i = 0; i < constructors.length; i++) {

            // QƂ𐶐
            Object object = null;

            try {
                // RXgN^ɈnAIuWFNg݂̐B
                object = constructors[i].newInstance(constructorParameter);
            } catch (IllegalArgumentException e) {
                // sȈnꂽꍇ
                continue;
            } catch (InstantiationException e) {
                // ۃNXꍇ
                throw new ClassLoadException(e);
            } catch (IllegalAccessException e) {
                // RXgN^ɃANZXoȂꍇ
                throw new ClassLoadException(e);
            } catch (InvocationTargetException e) {
                // RXgN^X[Obv
                throw new ClassLoadException(e);
            }

            // IuWFNgĂꍇI
            if (object != null) {
                return object;
            }

        }

        // IuWFNgAłȂꍇ́AOX[
        throw new ClassLoadException(
            new IllegalArgumentException("class name is " + className));
    }

}

