/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import jp.terasoluna.fw.validation.ValidationErrors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.springframework.validation.Errors;
import org.springmodules.validation.commons.MessageUtils;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks}NXɂāA
 * Springt[[N{@link org.springframework.validation.Errors}
 * C^tF[XɃG[ǉ邽߂̃NXB
 * 
 * <p>{NX{@link jp.terasoluna.fw.validation.FieldChecks}NX
 * ɂĎgpĂG[C^tF[X
 * {@link jp.terasoluna.fw.validation.ValidationErrors}
 * ̎NXłB
 * {@link jp.terasoluna.fw.validation.FieldChecks}NXɂ
 * ValidatorNX̊gNXł
 * {@link jp.terasoluna.fw.validation.springmodules.DefaultValidatorFactoryEx}
 * gpƁA{NXgpB</p>
 * 
 * @see jp.terasoluna.fw.validation.FieldChecks
 * @see jp.terasoluna.fw.validation.springmodules.DefaultValidatorFactoryEx
 */
public class SpringValidationErrors implements ValidationErrors {
    
    /**
     * {NXŗp郍OB
     */
    private static Log log = 
        LogFactory.getLog(SpringValidationErrors.class);
    
    /**
     * bvSpringt[[ÑG[IuWFNgB
     */
    private Errors errors = null;
    
    /**
     * Springt[[ÑG[IuWFNgݒ肷B
     * @param errors ݒ肷 errorsB
     */
    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    /**
     * Springt[[ÑG[IuWFNg擾B
     * @return errors ߂܂B
     */
    public Errors getErrors() {
        return errors;
    }
    
    /**
     * G[ǉB
     * bvSpringt[[ÑG[IuWFNg
     * G[ǉB
     * 
     * @param bean ؒ̃IuWFNgB
     * @param field commons-validatorFieldIuWFNgB
     * @param va  commons-validatorValidatorActionIuWFNgB
     */
    public void addError(Object bean, Field field, ValidatorAction va) {
        // G[̎o
        String fieldCode = field.getKey();
        String errorCode = MessageUtils.getMessageKey(va, field);
        Object[] args = MessageUtils.getArgs(va, field);

        if (log.isDebugEnabled()) {
            log.debug("Rejecting value [field='" + fieldCode + "', errorCode='"
                    + errorCode + "']");
        }

        // G[ǉ
        errors.rejectValue(fieldCode, errorCode, args, errorCode);
    }
}
