/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles3;

import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.renderer.DefinitionRenderer;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.servlet.ServletRequest;
import org.apache.tiles.request.servlet.ServletUtil;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesView
extends AbstractUrlBasedView {
    private Renderer renderer;
    private boolean exposeForwardAttributes = false;
    private boolean exposeJstlAttributes = true;
    private ApplicationContext applicationContext;

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    protected void setExposeJstlAttributes(boolean exposeJstlAttributes) {
        this.exposeJstlAttributes = exposeJstlAttributes;
    }

    protected void initServletContext(ServletContext servletContext) {
        super.initServletContext(servletContext);
        if (servletContext.getMajorVersion() == 2 && servletContext.getMinorVersion() < 5) {
            this.exposeForwardAttributes = true;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.applicationContext = ServletUtil.getApplicationContext((ServletContext)this.getServletContext());
        if (this.renderer == null) {
            TilesContainer container = TilesAccess.getContainer((ApplicationContext)this.applicationContext);
            this.renderer = new DefinitionRenderer(container);
        }
    }

    @Override
    public boolean checkResource(final Locale locale) throws Exception {
        HttpServletRequest servletRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && requestAttributes instanceof ServletRequestAttributes) {
            servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        ServletRequest request = new ServletRequest(this.applicationContext, servletRequest, null){

            public Locale getRequestLocale() {
                return locale;
            }
        };
        return this.renderer.isRenderable(this.getUrl(), (Request)request);
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        if (this.exposeJstlAttributes) {
            ServletContext servletContext = this.getServletContext();
            JstlUtils.exposeLocalizationContext(new RequestContext(request, servletContext));
        }
        if (!response.isCommitted() && this.exposeForwardAttributes) {
            try {
                WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
            }
            catch (Exception ex) {
                this.exposeForwardAttributes = false;
            }
        }
        Request tilesRequest = this.createTilesRequest(request, response);
        this.renderer.render(this.getUrl(), tilesRequest);
    }

    protected Request createTilesRequest(final HttpServletRequest request, HttpServletResponse response) {
        return new ServletRequest(this.applicationContext, request, response){

            public Locale getRequestLocale() {
                return RequestContextUtils.getLocale(request);
            }
        };
    }
}

