/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.batch.tutorial.sample005;

import jp.terasoluna.batch.tutorial.common.NyusyukkinData;
import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.db.DBCollector;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

/**
 * rWlXWbNNXB(oe[ucsvt@Cɏo͂NX)
 */
@Component
public class SMP005BLogic extends AbstractTransactionBLogic {

	private static final Log log = LogFactory.getLog(SMP005BLogic.class);

	@Autowired
	protected QueryRowHandleDAO queryRowHandleDAO;

	@Autowired
	@Qualifier(value = "csvFileUpdateDAO")
	protected FileUpdateDAO csvFileUpdateDAO;

	public int doMain(BLogicParam param) {

		// WuIR[hi0:IA-1:ُIj
		int returnCode = 0;

		// RN^
		Collector<NyusyukkinData> collector = new DBCollector<NyusyukkinData>(
				this.queryRowHandleDAO, "SMP005.selectNyusyukkin", null);

		// t@Co͗psC^̎擾(p)
		FileLineWriter<NyusyukkinData> fileLineWriterNyukin = csvFileUpdateDAO
				.execute("outputFile/SMP005_output_nyukin.csv",
						NyusyukkinData.class);

		// t@Co͗psC^̎擾(op)
		FileLineWriter<NyusyukkinData> fileLineWriterSyukkin = csvFileUpdateDAO
				.execute("outputFile/SMP005_output_syukkin.csv",
						NyusyukkinData.class);

		try {
			// DB擾f[^i[IuWFNg
			NyusyukkinData inputData = null;

			while (collector.hasNext()) {
				// DBf[^擾
				inputData = collector.next();

				// t@Cփf[^ói1sj
				// o敪ɂo̓t@CύX
				if (inputData != null && inputData.getNyusyukkinKubun() == 0) {
					fileLineWriterNyukin.printDataLine(inputData);
				}
				if (inputData != null && inputData.getNyusyukkinKubun() == 1) {
					fileLineWriterSyukkin.printDataLine(inputData);
				}
			}
		} catch (DataAccessException e) {
			if (log.isErrorEnabled()) {
				log.error("f[^ANZXG[܂", e);
			}

			returnCode = -1;
		} catch (Exception e) {
			if (log.isErrorEnabled()) {
				log.error("G[܂", e);
			}

			returnCode = -1;
		} finally {
			// RN^̃N[Y
			CollectorUtility.closeQuietly(collector);

			// t@C̃N[Y
			CollectorUtility.closeQuietly(fileLineWriterNyukin);
			CollectorUtility.closeQuietly(fileLineWriterSyukkin);

			// ĨO
			if (returnCode == 0 && log.isInfoEnabled()) {
				log.info("t@C݂ɏI܂B");
			}
		}

		return returnCode;
	}
}
