/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.executor.AbstractBatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.util.JobUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;
import jp.terasoluna.fw.util.PropertyUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractJobBatchExecutor
extends AbstractBatchExecutor {
    private static final TLogger LOGGER = TLogger.getLogger(AbstractJobBatchExecutor.class);
    protected static final String JOB_INTERVAL_TIME = "polling.interval";
    protected static final String EXECUTOR_END_MONITORING_FILE = "executor.endMonitoringFile";
    protected static final String EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME = "executor.jobTerminateWaitInterval";
    protected static final long DEFAULT_JOB_INTERVAL_TIME = 1000L;
    protected static final boolean DEFAULT_JOB_AFTER_GC = true;
    protected static final long DEFAULT_EXECUTOR_LOOP_INTERVAL_TIME = 1000L;
    protected static final String DEFAULT_EXECUTOR_END_MONITORING_FILE = null;
    protected static final long DEFAULT_EXECUTOR_QUEUE_CHECK_INTERVAL_TIME = 1000L;
    protected static final long DEFAULT_EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME = 5000L;
    protected long jobIntervalTime = 1000L;
    protected String executorEndMonitoringFile = DEFAULT_EXECUTOR_END_MONITORING_FILE;
    protected long executorJobTerminateWaitIntervalTime = 5000L;
    protected boolean changeStartStatus = false;

    protected AbstractJobBatchExecutor() {
        this.initParameter();
    }

    protected void initDefaultAppContext() {
        String defaultAppContextName = AbstractJobBatchExecutor.getDefaultBeanFileName();
        if (defaultAppContextName == null || "".equals(defaultAppContextName)) {
            LOGGER.error("EAL025003");
            return;
        }
        String dataSourceAppContextName = AbstractJobBatchExecutor.getDataSourceBeanFileName();
        if (dataSourceAppContextName == null || "".equals(dataSourceAppContextName)) {
            LOGGER.error("EAL025003");
            return;
        }
        this.defaultApplicationContext = AbstractJobBatchExecutor.getApplicationContext(defaultAppContextName, dataSourceAppContextName);
        if (this.defaultApplicationContext == null) {
            LOGGER.error("EAL025016", new Object[]{defaultAppContextName, dataSourceAppContextName});
            return;
        }
    }

    protected void initSystemDatasourceDao() {
        if (this.defaultApplicationContext == null) {
            return;
        }
        String queryDaoKey = PropertyUtil.getProperty((String)"systemDataSource.queryDAO");
        String updateDaoKey = PropertyUtil.getProperty((String)"systemDataSource.updateDAO");
        String transactionManagerKey = PropertyUtil.getProperty((String)"systemDataSource.transactionManager");
        if (queryDaoKey != null && queryDaoKey.length() != 0 && this.defaultApplicationContext.containsBean(queryDaoKey)) {
            try {
                this.sysQueryDAO = (QueryDAO)this.defaultApplicationContext.getBean(queryDaoKey, QueryDAO.class);
            }
            catch (Throwable e) {
                LOGGER.error("EAL025017", e, new Object[]{queryDaoKey});
            }
        }
        if (updateDaoKey != null && updateDaoKey.length() != 0 && this.defaultApplicationContext.containsBean(updateDaoKey)) {
            try {
                this.sysUpdateDAO = (UpdateDAO)this.defaultApplicationContext.getBean(updateDaoKey, UpdateDAO.class);
            }
            catch (Throwable e) {
                LOGGER.error("EAL025018", e, new Object[]{updateDaoKey});
            }
        }
        if (transactionManagerKey != null && transactionManagerKey.length() != 0 && this.defaultApplicationContext.containsBean(transactionManagerKey)) {
            try {
                this.sysTransactionManager = (PlatformTransactionManager)this.defaultApplicationContext.getBean(transactionManagerKey, PlatformTransactionManager.class);
            }
            catch (Throwable e) {
                LOGGER.error("EAL025019", e, new Object[]{transactionManagerKey});
            }
        }
        if (this.sysQueryDAO == null) {
            LOGGER.error("EAL025020");
        }
        if (this.sysUpdateDAO == null) {
            LOGGER.error("EAL025021");
        }
        if (this.sysTransactionManager == null) {
            LOGGER.error("EAL025022");
        }
    }

    protected void initParameter() {
        String executorEndMonitoringFileStr;
        String jobIntervalTimeStr = PropertyUtil.getProperty((String)JOB_INTERVAL_TIME);
        if (jobIntervalTimeStr != null && jobIntervalTimeStr.length() != 0) {
            try {
                this.jobIntervalTime = Long.parseLong(jobIntervalTimeStr);
            }
            catch (NumberFormatException e) {
                this.jobIntervalTime = 1000L;
            }
        } else {
            this.jobIntervalTime = 1000L;
        }
        this.executorEndMonitoringFile = (executorEndMonitoringFileStr = PropertyUtil.getProperty((String)EXECUTOR_END_MONITORING_FILE)) != null && executorEndMonitoringFileStr.length() != 0 ? executorEndMonitoringFileStr : DEFAULT_EXECUTOR_END_MONITORING_FILE;
        String executorJobTerminateWaitIntervalTimeStr = PropertyUtil.getProperty((String)EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME);
        if (executorJobTerminateWaitIntervalTimeStr != null && executorJobTerminateWaitIntervalTimeStr.length() != 0) {
            try {
                this.executorJobTerminateWaitIntervalTime = Long.parseLong(executorJobTerminateWaitIntervalTimeStr);
            }
            catch (NumberFormatException e) {
                this.executorJobTerminateWaitIntervalTime = 5000L;
            }
        } else {
            this.executorJobTerminateWaitIntervalTime = 5000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BLogicResult executeBatch(String jobSequenceId) {
        block52: {
            block45: {
                block51: {
                    block44: {
                        block50: {
                            block43: {
                                result = new BLogicResult();
                                st = false;
                                AbstractJobBatchExecutor.LOGGER.info("IAL025001", new Object[]{jobSequenceId});
                                if (this.sysQueryDAO == null || this.sysUpdateDAO == null || this.sysTransactionManager == null) {
                                    AbstractJobBatchExecutor.LOGGER.error("EAL025023", new Object[]{jobSequenceId});
                                    return result;
                                }
                                try {
                                    block46: {
                                        jobRecord = null;
                                        try {
                                            jobRecord = JobUtil.selectJob(jobSequenceId, false, this.sysQueryDAO);
                                        }
                                        catch (DataAccessException e) {
                                            AbstractJobBatchExecutor.LOGGER.error("EAL025049", new Object[]{jobSequenceId});
                                            var6_8 = result;
                                            var9_12 = null;
                                            try {
                                                st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                            }
                                            catch (DataAccessException e) {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                                return result;
                                            }
                                            catch (TransactionException e) {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                                return result;
                                            }
                                            if (st) {
                                                return var6_8;
                                            }
                                            if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                                            }
                                            return result;
                                        }
                                        if (jobRecord == null) {
                                            AbstractJobBatchExecutor.LOGGER.error("EAL025024", new Object[]{jobSequenceId});
                                            e = result;
                                            var9_13 = null;
                                            break block43;
                                        }
                                        if (!this.changeStartStatus) break block46;
                                        try {
                                            status = this.startBatchStatus(jobSequenceId, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                        }
                                        catch (DataAccessException e) {
                                            block47: {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025050", (Throwable)e, new Object[]{jobSequenceId});
                                                var7_33 = result;
                                                var9_14 = null;
                                                ** try [egrp 3[TRYBLOCK] [10, 11 : 331->353)] { 
lbl48:
                                                // 1 sources

                                                break block47;
lbl49:
                                                // 1 sources

                                                catch (DataAccessException e) {
                                                    AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                                    return result;
                                                }
lbl52:
                                                // 1 sources

                                                catch (TransactionException e) {
                                                    AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                                    return result;
                                                }
                                            }
                                            st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                            if (st) {
                                                return var7_33;
                                            }
                                            if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                                            }
                                            return result;
                                        }
                                        catch (TransactionException e) {
                                            block48: {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025050", (Throwable)e, new Object[]{jobSequenceId});
                                                var7_34 = result;
                                                var9_15 = null;
                                                ** try [egrp 3[TRYBLOCK] [10, 11 : 331->353)] { 
lbl68:
                                                // 1 sources

                                                break block48;
lbl69:
                                                // 1 sources

                                                catch (DataAccessException e) {
                                                    AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                                    return result;
                                                }
lbl72:
                                                // 1 sources

                                                catch (TransactionException e) {
                                                    AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                                    return result;
                                                }
                                            }
                                            st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                            if (st) {
                                                return var7_34;
                                            }
                                            if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                                            }
                                            return result;
                                        }
                                        if (!status) {
                                            AbstractJobBatchExecutor.LOGGER.error("EAL025050", new Object[]{jobSequenceId});
                                            var6_11 = result;
                                            break block44;
                                        }
                                    }
                                    if (jobRecord.getJobAppCd() != null) {
                                        jobRecord.setJobAppCd(jobRecord.getJobAppCd().trim());
                                    }
                                    result = this.executeBatch(jobRecord);
                                    if (AbstractJobBatchExecutor.LOGGER.isDebugEnabled()) {
                                        AbstractJobBatchExecutor.LOGGER.debug("DAL025021", new Object[]{result.getBlogicStatus()});
                                    }
                                    break block45;
                                }
                                catch (Throwable var8_35) {
                                    block49: {
                                        var9_18 = null;
                                        ** try [egrp 3[TRYBLOCK] [10, 11 : 331->353)] { 
lbl99:
                                        // 1 sources

                                        break block49;
lbl100:
                                        // 1 sources

                                        catch (DataAccessException e) {
                                            AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                            return result;
                                        }
lbl103:
                                        // 1 sources

                                        catch (TransactionException e) {
                                            AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                            return result;
                                        }
                                    }
                                    st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                    if (st) {
                                        throw var8_35;
                                    }
                                    if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                        AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                                    }
                                    return result;
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [10, 11 : 331->353)] { 
lbl115:
                            // 1 sources

                            break block50;
lbl116:
                            // 1 sources

                            catch (DataAccessException e) {
                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                return result;
                            }
lbl119:
                            // 1 sources

                            catch (TransactionException e) {
                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                                return result;
                            }
                        }
                        st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                        if (!st) {
                            if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                            }
                            return result;
                        }
                        return e;
                    }
                    var9_16 = null;
                    ** try [egrp 3[TRYBLOCK] [10, 11 : 331->353)] { 
lbl132:
                    // 1 sources

                    break block51;
lbl133:
                    // 1 sources

                    catch (DataAccessException e) {
                        AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                        return result;
                    }
lbl136:
                    // 1 sources

                    catch (TransactionException e) {
                        AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                        return result;
                    }
                }
                st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                if (!st) {
                    if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                        AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                    }
                    return result;
                }
                return var6_11;
            }
            var9_17 = null;
            ** try [egrp 3[TRYBLOCK] [10, 11 : 331->353)] { 
lbl149:
            // 1 sources

            break block52;
lbl150:
            // 1 sources

            catch (DataAccessException e) {
                AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                return result;
            }
lbl153:
            // 1 sources

            catch (TransactionException e) {
                AbstractJobBatchExecutor.LOGGER.error("EAL025025", (Throwable)e, new Object[]{jobSequenceId, result.getBlogicStatus()});
                return result;
            }
        }
        st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
        if (!st) {
            if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
            }
            return result;
        }
        if (AbstractJobBatchExecutor.LOGGER.isInfoEnabled()) {
            AbstractJobBatchExecutor.LOGGER.info("IAL025003", new Object[]{jobSequenceId, result.getBlogicStatus()});
        }
        return result;
    }

    protected boolean startBatchStatus(String jobSequenceId, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        return this.updateBatchStatus(jobSequenceId, "0", null, queryDAO, updateDAO, transactionManager);
    }

    protected boolean endBatchStatus(String jobSequenceId, BLogicResult result, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        String blogicStatus = null;
        if (result != null) {
            blogicStatus = Integer.toString(result.getBlogicStatus());
        }
        return this.updateBatchStatus(jobSequenceId, "1", blogicStatus, queryDAO, updateDAO, transactionManager);
    }

    /*
     * Loose catch block
     */
    protected boolean updateBatchStatus(String jobSequenceId, String eventCode, String blogicStatus, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        block21: {
            String changeStatus;
            BatchJobData job;
            TransactionStatus tranStatus;
            block19: {
                block17: {
                    tranStatus = null;
                    DefaultTransactionDefinition tranDef = new DefaultTransactionDefinition();
                    tranStatus = transactionManager.getTransaction((TransactionDefinition)tranDef);
                    LOGGER.debug("DAL025022");
                    job = JobUtil.selectJob(jobSequenceId, true, queryDAO);
                    if (job != null) break block17;
                    LOGGER.error("EAL025026", new Object[]{jobSequenceId});
                    boolean bl = false;
                    Object var13_13 = null;
                    try {
                        if (tranStatus != null && !tranStatus.isCompleted()) {
                            transactionManager.rollback(tranStatus);
                        }
                        LOGGER.debug("DAL025025");
                    }
                    catch (Exception e) {
                        LOGGER.error("EAL025028", (Throwable)e);
                    }
                    return bl;
                }
                changeStatus = this.judgmentStatus(job, jobSequenceId, eventCode, blogicStatus);
                if (changeStatus != null) break block19;
                boolean bl = false;
                Object var13_14 = null;
                try {
                    if (tranStatus != null && !tranStatus.isCompleted()) {
                        transactionManager.rollback(tranStatus);
                    }
                    LOGGER.debug("DAL025025");
                }
                catch (Exception e) {
                    LOGGER.error("EAL025028", (Throwable)e);
                }
                return bl;
            }
            LOGGER.debug("DAL025023", new Object[]{jobSequenceId, changeStatus});
            JobUtil.updateJobStatus(job.getJobSequenceId(), changeStatus, null, blogicStatus, queryDAO, updateDAO);
            transactionManager.commit(tranStatus);
            LOGGER.debug("DAL025024");
            Object var13_15 = null;
            try {
                if (tranStatus != null && !tranStatus.isCompleted()) {
                    transactionManager.rollback(tranStatus);
                }
                LOGGER.debug("DAL025025");
            }
            catch (Exception e) {
                LOGGER.error("EAL025028", (Throwable)e);
            }
            break block21;
            {
                catch (Exception e) {
                    LOGGER.error("EAL025027", (Throwable)e);
                    if (e instanceof DataAccessException) {
                        throw (DataAccessException)((Object)e);
                    }
                    if (e instanceof TransactionException) {
                        throw (TransactionException)((Object)e);
                    }
                    throw new BatchException(e);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (tranStatus != null && !tranStatus.isCompleted()) {
                        transactionManager.rollback(tranStatus);
                    }
                    LOGGER.debug("DAL025025");
                }
                catch (Exception e) {
                    LOGGER.error("EAL025028", (Throwable)e);
                }
                throw throwable;
            }
        }
        return true;
    }

    protected String judgmentStatus(BatchJobData job, String jobSequenceId, String eventCode, String blogicStatus) {
        String judge = null;
        judge = "0".equals(eventCode) ? ("0".equals(job.getCurAppStatus()) ? "1" : null) : ("1".equals(job.getCurAppStatus()) ? "2" : null);
        if (judge == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("IAL025004", new Object[]{jobSequenceId, blogicStatus, eventCode, job.getCurAppStatus(), judge});
            }
            return null;
        }
        return judge.toString();
    }

    public long getJobIntervalTime() {
        return this.jobIntervalTime;
    }

    public String getExecutorEndMonitoringFile() {
        return this.executorEndMonitoringFile;
    }

    public long getExecutorJobTerminateWaitIntervalTime() {
        return this.executorJobTerminateWaitIntervalTime;
    }

    public void setChangeStartStatus(boolean changeStartStatus) {
        this.changeStartStatus = changeStartStatus;
    }
}

