/*
 * $Id: FileControlImplTest.java 5576 2007-11-15 13:13:32Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.util.FileControlImpl} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> FileControlC^tF[XNX.
 * <p>
 * @author gM
 * @see jp.terasoluna.fw.file.util.FileControlImpl
 */
public class FileControlImplTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FileControlImplTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
        // FileUtility̏~߂
        VMOUTUtil.setReturnValueAtAllTimes(FileUtility.class, "copyFile", null);
        VMOUTUtil.setReturnValueAtAllTimes(FileUtility.class, "deleteFile",
                null);
        VMOUTUtil
                .setReturnValueAtAllTimes(FileUtility.class, "mergeFile", null);
        VMOUTUtil.setReturnValueAtAllTimes(FileUtility.class, "renameFile",
                null);
        VMOUTUtil.setReturnValueAtAllTimes(FileUtility.class,
                "isCheckFileExist", null);
        VMOUTUtil.setReturnValueAtAllTimes(FileUtility.class,
                "setCheckFileExist", null);
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public FileControlImplTest(String name) {
        super(name);
    }

    /**
     * testCopyFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testCopyFile01_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testCopyFile01_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility#copyFile():Ăяo邱ƂmFB<br>
     * srcFileAnewFilȅFileUtilitÿɓn邱ƂmFB<br>
     * <br>
     * Rs[ƃRs[̃t@CpXɐ΃pXw肷P[XB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCopyFile01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile01_src.txt";
        String newFile = directoryPath + "testCopyFile01_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "copyFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "copyFile", 0);
            assertEquals(srcFile, arguments.get(0));
            assertEquals(newFile, arguments.get(1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testCopyFile02_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testCopyFile02_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility#copyFile():Ăяo邱ƂmFB<br>
     * srcFileAnewFilȅ<br>
     * FileControl.basePathꂼ̐擪ɂ<br>
     * FileUtilitÿɓn邱ƂmFB<br>
     * <br>
     * Rs[ƃRs[̃t@CpXɑ΃pXw肷P[XB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCopyFile02() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testCopyFile02_src.txt";
        String newFile = "testCopyFile02_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "copyFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "copyFile", 0);
            assertEquals(basePath + srcFile, arguments.get(0));
            assertEquals(basePath + newFile, arguments.get(1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testCopyFile03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testCopyFile03_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility#copyFile():Ăяo邱ƂmFB<br>
     * srcFileAnewFilȅ<br>
     * FileControl.basePathꂼ̐擪ɂƂȂ<br>
     * FileUtilitÿɓn邱ƂmFB<br>
     * <br>
     * ̃t@CpX΃pXłApXݒ肳Ăꍇ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCopyFile03() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile03_src.txt";
        String newFile = directoryPath + "testCopyFile03_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "copyFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "copyFile", 0);
            assertEquals(srcFile, arguments.get(0));
            assertEquals(newFile, arguments.get(1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile04() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testCopyFile04_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testCopyFile04_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility#copyFile():Ăяo邱ƂmFB<br>
     * srcFileAnewFilȅɓn邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłApXݒ肳ĂȂP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCopyFile04() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testCopyFile04_src.txt";
        String newFile = "testCopyFile04_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "copyFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "copyFile", 0);
            assertEquals(srcFile, arguments.get(0));
            assertEquals(newFile, arguments.get(1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:null<br>
     * () newFile:StringCX^X<br>
     * "(pX)testCopyFile05_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * bZ[WF"File name is not set."<br>
     * <br>
     * srcFilenullݒ肳ꂽꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile05() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = null;
        String newFile = directoryPath + "testCopyFile05_new.txt";

        // eXgOAΏۃt@C
        File file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertFalse(VMOUTUtil.isCalled(FileUtility.class, "copyFile"));
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        } finally {
            // eXgAΏۃt@C
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testCopyFile06_src.txt"<br>
     * () newFile:null<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * bZ[WF"File name is not set."<br>
     * <br>
     * newFilenullݒ肳ꂽꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile06() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile06_src.txt";
        String newFile = null;

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertFalse(VMOUTUtil.isCalled(FileUtility.class, "copyFile"));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testCopyFile07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testCopyFile07_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testCopyFile07_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility#copyFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * Filẽt@CpX΃pXŁAnewFilẽt@CpX΃pX̏ꍇAsrcFilẽt@CpXɊpXt^newFilẽt@CpXɂ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCopyFile07() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testCopyFile07_src.txt";
        String newFile = directoryPath + "testCopyFile07_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "copyFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "copyFile", 0);
            assertEquals(basePath + srcFile, arguments.get(0));
            assertEquals(newFile, arguments.get(1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testCopyFile08_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testCopyFile08_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility#copyFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * Filẽt@CpX΃pXŁAnewFilẽt@CpX΃pX̏ꍇAsrcFilẽt@CpXɊpXt^ꂸnewFilẽt@CpXɂ͊pXt^邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCopyFile08() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile08_src.txt";
        String newFile = "testCopyFile08_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "copyFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "copyFile", 0);
            assertEquals(srcFile, arguments.get(0));
            assertEquals(basePath + newFile, arguments.get(1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testDeleteFile01_src.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.deleteFile():ĂяoB<br>
     * srcFilen邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testDeleteFile01_src.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.deleteFile(srcFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "deleteFile"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "deleteFile", 0, 0));
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testDeleteFile02_src.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.deleteFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile02() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testDeleteFile02_src.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.deleteFile(srcFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "deleteFile"));
            assertEquals(basePath + srcFile, VMOUTUtil.getArgument(
                    FileUtility.class, "deleteFile", 0, 0));
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testDeleteFile03_src.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.deleteFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * ̃t@CpX΃pXłApXݒ肳Ăꍇ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile03() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testDeleteFile03_src.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.deleteFile(srcFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "deleteFile"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "deleteFile", 0, 0));
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile04() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testDeleteFile04_src.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.deleteFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłApXݒ肳ĂȂP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile04() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testDeleteFile04_src.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.deleteFile(srcFile);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "deleteFile"));
            assertEquals(basePath + srcFile, VMOUTUtil.getArgument(
                    FileUtility.class, "deleteFile", 0, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:null<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * <br>
     * nullݒ肳ꂽꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile05() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String srcFile = null;

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.deleteFile(srcFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertFalse(VMOUTUtil.isCalled(FileUtility.class, "deleteFile"));
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        }
    }

    /**
     * testMergeFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:vfȂArrayListCX^X<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile01_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * newFileAfileListn邱ƂmFB<br>
     * <br>
     * fileList̗vfłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String newFile = directoryPath + "testMergeFile01_new.txt";

        // eXgOAΏۃt@C
        File file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            assertEquals(fileList, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 1));
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"(pX)testMergeFile02-01_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile02_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * newFileAfileListn邱ƂmFB<br>
     * <br>
     * fileList̗vf1ŁAt@C̃pX΃pXłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile02() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile02-01_src.txt";
        fileList.add(srcFile1);

        String newFile = directoryPath + "testMergeFile02_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            assertEquals(fileList, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile1, VMOUTUtil.getArgument(
                    fileControl.getClass(), "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile1);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"testMergeFile03-01_src.txt"<br>
     * vf2:"testMergeFile03-02_src.txt"<br>
     * vf3:"testMergeFile03-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testMergeFile03_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * newFileAfileListFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * fileList̗vf3ŁAt@C̃pX΃pXłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testMergeFile03() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = "testMergeFile03-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = "testMergeFile03-02_src.txt";
        fileList.add(srcFile2);

        String srcFile3 = "testMergeFile03-03_src.txt";
        fileList.add(srcFile3);

        String newFile = "testMergeFile03_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile2);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "mergeFile", 0);
            List getFileList = (List) arguments.get(0);
            assertEquals(basePath + srcFile1, getFileList.get(0));
            assertEquals(basePath + srcFile2, getFileList.get(1));
            assertEquals(basePath + srcFile3, getFileList.get(2));
            assertEquals(basePath + newFile, arguments.get(1));

            assertEquals(4, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);
            String fileName3 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 2, 0);
            assertEquals(srcFile3, fileName3);
            String getNewFile = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 3, 0);
            assertEquals(newFile, getNewFile);
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile1);
            file.delete();
            file = new File(directoryPath + srcFile2);
            file.delete();
            file = new File(directoryPath + srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"(pX)testMergeFile04-01_src.txt"<br>
     * vf2:"(pX)testMergeFile04-02_src.txt"<br>
     * vf3:"(pX)testMergeFile04-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile04_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * newFileAfileListFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * ̃t@CpX΃pXłApXݒ肳Ăꍇ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile04() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile04-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = directoryPath + "testMergeFile04-02_src.txt";
        fileList.add(srcFile2);

        String srcFile3 = directoryPath + "testMergeFile04-03_src.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile04_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(srcFile2);
        file.delete();
        file.createNewFile();

        file = new File(srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            assertEquals(fileList, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 1));

            assertEquals(4, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);
            String fileName3 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 2, 0);
            assertEquals(srcFile3, fileName3);
            String getNewFile = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 3, 0);
            assertEquals(newFile, getNewFile);
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile05() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"testMergeFile05-01_src.txt"<br>
     * vf2:"testMergeFile05-02_src.txt"<br>
     * vf3:"testMergeFile05-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testMergeFile05_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * newFileAfileListFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłApXݒ肳ĂȂP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile05() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = "testMergeFile05-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = "testMergeFile05-02_src.txt";
        fileList.add(srcFile2);

        String srcFile3 = "testMergeFile05-03_src.txt";
        fileList.add(srcFile3);

        String newFile = "testMergeFile05_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile2);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            assertEquals(fileList, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "mergeFile", 0, 1));

            assertEquals(4, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);
            String fileName3 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 2, 0);
            assertEquals(srcFile3, fileName3);
            String getNewFile = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 3, 0);
            assertEquals(newFile, getNewFile);
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile1);
            file.delete();
            file = new File(directoryPath + srcFile2);
            file.delete();
            file = new File(directoryPath + srcFile3);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileList:null<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile06_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:ONullPointerExceptionB<br>
     * <br>
     * fileListnullݒ肳ꂽꍇ́ANullPointerExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile06() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = null;
        String newFile = directoryPath + "testMergeFile06_new.txt";

        // eXgOAΏۃt@C
        File file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);
            fail("NullPointerException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(NullPointerException.class, e.getClass());
        } finally {
            // eXgAΏۃt@C
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"(pX)testMergeFile07-01_src.txt"<br>
     * () newFile:null<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * bZ[WF"File name is not set."<br>
     * <br>
     * newFilenullݒ肳ꂽꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile07() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile07-01_src.txt";
        fileList.add(srcFile1);

        String newFile = null;

        // eXgOAΏۃt@C
        File file = new File(srcFile1);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile1, VMOUTUtil.getArgument(
                    fileControl.getClass(), "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile1);
            file.delete();
        }
    }

    /**
     * testMergeFile08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"(pX)testMergeFile08-01_src.txt"<br>
     * vf2:null<br>
     * vf3:"(pX)testMergeFile08-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile08_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * bZ[WF"File name is not set."<br>
     * <br>
     * fileList̗vfnull܂܂Ăꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile08() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile08-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = null;
        fileList.add(srcFile2);

        String srcFile3 = directoryPath + "testMergeFile08-03_src.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile08_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);

            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile1);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile09() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"testMergeFile09-01_src.txt"<br>
     * vf2:"testMergeFile09-02_src.txt"<br>
     * vf3:"testMergeFile09-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile09_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * fileListFileControl.basePath擪ɂēn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * fileList̃t@CpX΃pXŁAnewFilẽt@CpX΃pX̏ꍇB<br>
     * fileList̃t@CpXɊpXt^newFilẽt@CpXɂ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testMergeFile09() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = "testMergeFile09-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = "testMergeFile09-02_src.txt";
        fileList.add(srcFile2);

        String srcFile3 = "testMergeFile09-03_src.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile09_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile2);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "mergeFile", 0);
            List getFileList = (List) arguments.get(0);
            assertEquals(basePath + srcFile1, getFileList.get(0));
            assertEquals(basePath + srcFile2, getFileList.get(1));
            assertEquals(basePath + srcFile3, getFileList.get(2));
            assertEquals(newFile, arguments.get(1));

            assertEquals(4, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);
            String fileName3 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 2, 0);
            assertEquals(srcFile3, fileName3);
            String getNewFile = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 3, 0);
            assertEquals(newFile, getNewFile);
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile1);
            file.delete();
            file = new File(directoryPath + srcFile2);
            file.delete();
            file = new File(directoryPath + srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile10() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"(pX)testMergeFile10-01_src.txt"<br>
     * vf2:"testMergeFile10-02_src.txt"<br>
     * vf3:"(pX)testMergeFile10-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testMergeFile10_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * fileList̗vf1A3FileControl.basePath擪ɂɓn邱ƂmFB<br>
     * fileList̗vf2FileControl.basePath擪ɂēn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * fileList̗vfɃt@CpX΃pXƐ΃pX܂܂ĂāAnewFilẽt@CpX΃pX̏ꍇB<br>
     * fileList̗vf2̃t@CpXɊpXt^ꂻ̗̑vfɂ͕t^ꂸAnewFilẽt@CpXɂ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testMergeFile10() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile10-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = "testMergeFile10-02_src.txt";
        fileList.add(srcFile2);

        String srcFile3 = directoryPath + "testMergeFile10-03_src.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile10_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + srcFile2);
        file.delete();
        file.createNewFile();

        file = new File(srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "mergeFile", 0);
            List getFileList = (List) arguments.get(0);
            assertEquals(srcFile1, getFileList.get(0));
            assertEquals(basePath + srcFile2, getFileList.get(1));
            assertEquals(srcFile3, getFileList.get(2));
            assertEquals(newFile, arguments.get(1));

            assertEquals(4, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);
            String fileName3 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 2, 0);
            assertEquals(srcFile3, fileName3);
            String getNewFile = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 3, 0);
            assertEquals(newFile, getNewFile);
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile1);
            file.delete();
            file = new File(directoryPath + srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile11() <br>
     * <br>
     * (n) <br>
     * ϓ_FD, E, F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfArrayListCX^X<br>
     * vf1:"(pX)testMergeFile11-01_src.txt"<br>
     * vf2:"(pX)testMergeFile11-02_src.txt"<br>
     * vf3:"(pX)testMergeFile11-03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testMergeFile11_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.mergeFile():1ĂяoB<br>
     * fileListFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * fileList̃t@CpX΃pXŁAnewFilẽt@CpX΃pX̏ꍇB<br>
     * fileList̃t@CpXɊpXt^ꂸnewFilẽt@CpXɂ͊pXt^邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testMergeFile11() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile11-01_src.txt";
        fileList.add(srcFile1);

        String srcFile2 = directoryPath + "testMergeFile11-02_src.txt";
        fileList.add(srcFile2);

        String srcFile3 = directoryPath + "testMergeFile11-03_src.txt";
        fileList.add(srcFile3);

        String newFile = "testMergeFile11_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile1);
        file.delete();
        file.createNewFile();

        file = new File(srcFile2);
        file.delete();
        file.createNewFile();

        file = new File(srcFile3);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "mergeFile"));
            List arguments = VMOUTUtil.getArguments(FileUtility.class,
                    "mergeFile", 0);
            List getFileList = (List) arguments.get(0);
            assertEquals(srcFile1, getFileList.get(0));
            assertEquals(srcFile2, getFileList.get(1));
            assertEquals(srcFile3, getFileList.get(2));
            assertEquals(basePath + newFile, arguments.get(1));

            assertEquals(4, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            String fileName1 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 0, 0);
            assertEquals(srcFile1, fileName1);
            String fileName2 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 1, 0);
            assertEquals(srcFile2, fileName2);
            String fileName3 = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 2, 0);
            assertEquals(srcFile3, fileName3);
            String getNewFile = (String) VMOUTUtil.getArgument(fileControl
                    .getClass(), "getAbsolutePath", 3, 0);
            assertEquals(newFile, getNewFile);
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testRenameFile01_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testRenameFile01_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.renameFile():ĂяoB<br>
     * srcFileAnewFilen邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile01_src.txt";
        String newFile = directoryPath + "testRenameFile01_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "renameFile"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testRenameFile02_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testRenameFile02_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.renameFile():ĂяoB<br>
     * srcFileAnewFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłP[XB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile02() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testRenameFile02_src.txt";
        String newFile = "testRenameFile02_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "renameFile"));
            assertEquals(basePath + srcFile, VMOUTUtil.getArgument(
                    FileUtility.class, "renameFile", 0, 0));
            assertEquals(basePath + newFile, VMOUTUtil.getArgument(
                    FileUtility.class, "renameFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testRenameFile03_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testRenameFile03_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.renameFile():ĂяoB<br>
     * srcFileAnewFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * ̃t@CpX΃pXłApXݒ肳Ăꍇ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile03() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile03_src.txt";
        String newFile = directoryPath + "testRenameFile03_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "renameFile"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile04() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testRenameFile04_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testRenameFile04_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) FileUtility.renameFile():ĂяoB<br>
     * srcFileAnewFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * t@C̃pX΃pXłApXݒ肳ĂȂP[XB<br>
     * OFileExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile04() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testRenameFile04_src.txt";
        String newFile = "testRenameFile04_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "renameFile"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:null<br>
     * () newFile:StringCX^X<br>
     * "(pX)testRenameFile05_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * bZ[WF"File name is not set."<br>
     * <br>
     * srcFilenullݒ肳ꂽꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile05() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = null;
        String newFile = directoryPath + "testRenameFile05_new.txt";

        // eXgOAΏۃt@C
        File file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertFalse(VMOUTUtil.isCalled(FileUtility.class, "renameFile"));
            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        } finally {
            // eXgAΏۃt@C
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testRenameFile06_src.txt"<br>
     * () newFile:null<br>
     * () FileControl.basePath:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:OFileExceptionB<br>
     * bZ[WF"File name is not set."<br>
     * <br>
     * newFilenullݒ肳ꂽꍇ́AFileExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile06() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile06_src.txt";
        String newFile = null;

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = "";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
            assertFalse(VMOUTUtil.isCalled(FileUtility.class, "renameFile"));
            assertEquals(FileException.class, e.getClass());
            assertEquals("File name is not set.", e.getMessage());
            assertNull(e.getFileName());
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testRenameFile07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testRenameFile07_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "(pX)testRenameFile07_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.renameFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * <br>
     * Filẽt@CpX΃pXŁAnewFilẽt@CpX΃pX̏ꍇAsrcFilẽt@CpXɊpXt^newFilẽt@CpXɂ͊pXt^ȂƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile07() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testRenameFile07_src.txt";
        String newFile = directoryPath + "testRenameFile07_new.txt";

        // eXgOAΏۃt@C
        File file = new File(directoryPath + srcFile);
        file.delete();
        file.createNewFile();

        file = new File(newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "renameFile"));
            assertEquals(basePath + srcFile, VMOUTUtil.getArgument(
                    FileUtility.class, "renameFile", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)testRenameFile08_src.txt"<br>
     * () newFile:StringCX^X<br>
     * "testRenameFile08_new.txt"<br>
     * () FileControl.basePath:StringCX^X<br>
     * "(pX)"<br>
     * <br>
     * ҒlF(ԕω) FileUtility.renameFile():ĂяoB<br>
     * srcFileFileControl.basePath擪ɂɓn邱ƂmFB<br>
     * newFileFileControl.basePath擪ɂēn邱ƂmFB<br>
     * <br>
     * Filẽt@CpX΃pXŁAnewFilẽt@CpX΃pX̏ꍇAsrcFilẽt@CpXɊpXt^ꂸnewFilẽt@CpXɂ͊pXt^邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile08() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile08_src.txt";
        String newFile = "testRenameFile08_new.txt";

        // eXgOAΏۃt@C
        File file = new File(srcFile);
        file.delete();
        file.createNewFile();

        file = new File(directoryPath + newFile);
        file.delete();
        file.createNewFile();

        // O̐ݒ
        String basePath = directoryPath;
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        try {
            // eXg{
            fileControl.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "renameFile"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "renameFile", 0, 0));
            assertEquals(basePath + newFile, VMOUTUtil.getArgument(
                    FileUtility.class, "renameFile", 0, 1));
            assertEquals(2, VMOUTUtil.getCallCount(fileControl.getClass(),
                    "getAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(fileControl.getClass(),
                    "getAbsolutePath", 1, 0));
        } finally {
            // eXgAΏۃt@C
            file = new File(srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testGetBasePath01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() basePath:StringCX^X<br>
     * "aaa"<br>
     * <br>
     * ҒlF(߂l) String:ObasePathƓ<br>
     * StringCX^X<br>
     * <br>
     * 擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBasePath01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // Ȃ

        // O̐ݒ
        String basePath = "aaa";
        UTUtil.setPrivateField(fileControl, "basePath", basePath);

        // eXg{
        String getBasePath = fileControl.getBasePath();

        // ԋpl̊mF
        assertEquals(basePath, getBasePath);

        // ԕωȂ
    }

    /**
     * testSetBasePath01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() basePath:StringCX^X<br>
     * "aaa"<br>
     * () basePath:""<br>
     * <br>
     * ҒlF(ԕω) basePath:basePathƓ<br>
     * StringCX^X<br>
     * <br>
     * ɐݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBasePath01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        String basePath = "aaa";

        // O̐ݒ
        UTUtil.setPrivateField(fileControl, "basePath", "");

        // eXg{
        fileControl.setBasePath(basePath);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(basePath, UTUtil.getPrivateField(fileControl, "basePath"));
    }

    /**
     * testSetCheckFileExist01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() checkFileExist:true<br>
     * <br>
     * ҒlF(ԕω) setCheckFileExist:ĂяoB<br>
     * checkFileExistn邱ƂmFB<br>
     * <br>
     * true <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetCheckFileExist01() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        boolean checkFileExist = true;

        // OȂ

        // eXg{
        fileControl.setCheckFileExist(checkFileExist);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                "setCheckFileExist"));
        assertEquals(checkFileExist, VMOUTUtil.getArgument(FileUtility.class,
                "setCheckFileExist", 0, 0));
    }

    /**
     * testSetCheckFileExist02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() checkFileExist:false<br>
     * <br>
     * ҒlF(ԕω) setCheckFileExist:ĂяoB<br>
     * checkFileExistn邱ƂmFB<br>
     * <br>
     * false <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetCheckFileExist02() throws Exception {
        // eXgΏۂ̃CX^X
        FileControlImpl fileControl = new FileControlImpl();

        // ̐ݒ
        boolean checkFileExist = false;

        // OȂ

        // eXg{
        fileControl.setCheckFileExist(checkFileExist);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                "setCheckFileExist"));
        assertEquals(checkFileExist, VMOUTUtil.getArgument(FileUtility.class,
                "setCheckFileExist", 0, 0));
    }
}
