/*
 * $Id: UTUtil.java 5230 2007-09-28 10:04:13Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */
package jp.terasoluna.fw.file.ut;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

import junit.framework.Assert;

/**
 *  JUnitł̒P̃eXgT|[g郆[eBeBNXB
 * @version 2003.08.29
 * @author OH 
 */
public class UTUtil {

    /**
     * t̃tH[}bg
     */
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    /**
     * tr邽߂assert[eBeB\bhB <BR>
     * <BR>
     * selectRows()DATE^̒l"yyyy-MM-dd HH:mm:ss.fffffffff"tH[}bg ԋp悤ɂȂĂ邽߁Â܂܂ł͒l̔rÂ炢B<BR>
     * ̂߁Atpassert[eBeB\bhpӂĂB <BR>
     * <BR>
     * 
     * <pre>
     * [gp]
     * List list = UTUtil.selectRows(&quot;CUSTOMER&quot;, &quot;C_ID=1&quot;);
     * Map map = (Map) list.get(0);
     * UTUtil.assertEqualsDate(&quot;2003-01-01&quot;, map.get(&quot;C_REGIST_DATE&quot;));
     * </pre>
     * @param expected Ғl
     * @param actual ۂ̒l
     */
    public static void assertEqualsDate(Object expected, Object actual) {

        // p[^String^łȂΗOԂB
        if ((expected != null) && (!(expected instanceof String))) {
            throw new IllegalArgumentException();
        }
        if ((actual != null) && (!(actual instanceof String))) {
            throw new IllegalArgumentException();
        }

        // "yyyy-MM-dd HH:mm:ss.fffffffff""yyyy-MM-dd"oB
        String actualDate = (actual != null) ? ((String) actual).substring(0,
                10) : null;

        // StringɃLXgassertEqualsB
        String expectedDate = (String) expected;
        Assert.assertEquals(expectedDate, actualDate);
    }

    /**
     * r邽߂assert[eBeB\bhB <BR>
     * <BR>
     * selectRows()DATE^̒l"yyyy-MM-dd HH:mm:ss.fffffffff"tH[}bg ԋp悤ɂȂĂ邽߁Â܂܂ł͒l̔rÂ炢B<BR>
     * ̂߁Apassert[eBeB\bhpӂĂB <BR>
     * <BR>
     * 
     * <pre>
     * [gp]
     * List list = UTUtil.selectRows(&quot;CUSTOMER&quot;, &quot;C_ID=1&quot;);
     * Map map = (Map) list.get(0);
     * UTUtil.assertEqualsDate(&quot;12:34:56&quot;, map.get(&quot;C_UPDATE_TIME&quot;));
     * </pre>
     * @param expected Ғl
     * @param actual ۂ̒l
     */
    public static void assertEqualsTime(Object expected, Object actual) {

        // p[^String^łȂΗOԂB
        if ((expected != null) && (!(expected instanceof String))) {
            throw new IllegalArgumentException();
        }
        if ((actual != null) && (!(actual instanceof String))) {
            throw new IllegalArgumentException();
        }

        // "yyyy-MM-dd HH:mm:ss.fffffffff""HH:mm:ss"oB
        String actualTime = (actual != null) ? ((String) actual).substring(11,
                19) : null;

        // StringɃLXgassertEqualsB
        String expectedTime = (String) expected;
        Assert.assertEquals(expectedTime, actualTime);
    }

    /**
     * t{r邽߂assert[eBeB\bhB <BR>
     * <BR>
     * selectRows()DATE^̒l"yyyy-MM-dd HH:mm:ss.fffffffff"tH[}bg ԋp悤ɂȂĂ邽߁Â܂܂ł͒l̔rÂ炢B<BR>
     * ̂߁At{passert[eBeB\bhpӂĂB <BR>
     * <BR>
     * 
     * <pre>
     * [gp]
     * List list = UTUtil.selectRows(&quot;CUSTOMER&quot;, &quot;C_ID=1&quot;);
     * Map map = (Map) list.get(0);
     * UTUtil.assertEqualsDateTime(&quot;2003-01-01 12:00:05&quot;,
     *     map.get(&quot;C_UPDATE_DATE&quot;));
     * </pre>
     * @param expected Ғl
     * @param actual ۂ̒l
     */
    public static void assertEqualsDateTime(Object expected, Object actual) {

        // p[^String^łȂΗOԂB
        if ((expected != null) && (!(expected instanceof String))) {
            throw new IllegalArgumentException();
        }
        if ((actual != null) && (!(actual instanceof String))) {
            throw new IllegalArgumentException();
        }

        // "yyyy-MM-dd HH:mm:ss.fffffffff""yyyy-MM-dd HH:mm:ss"oB
        String actualDateTime = (actual != null) ? ((String) actual).substring(
                0, 19) : null;

        // StringɃLXgassertEqualsB
        String expectedDateTime = (String) expected;
        Assert.assertEquals(expectedDateTime, actualDateTime);
    }

    /**
     * ݓtƔr邽߂assert[eBeB\bhB <BR>
     * <BR>
     * selectRows()DATE^̒l"yyyy-MM-dd HH:mm:ss.fffffffff"tH[}bg ԋp悤ɂȂĂ邽߁Â܂܂ł͒l̔rÂ炢B<BR>
     * ̂߁AݓtƔrassert[eBeB\bhpӂĂB
     * 
     * <pre>
     * [gp]
     * List list = UTUtil.selectRows(&quot;CUSTOMER&quot;, &quot;C_ID=1&quot;);
     * Map map = (Map) list.get(0);
     * UTUtil.assertEqualsToday(map.get(&quot;C_UPDATE_DATE&quot;));
     * </pre>
     * @param actual ۂ̒l
     */
    public static void assertEqualsToday(Object actual) {

        // p[^String^łȂΗOԂB
        if ((actual != null) && (!(actual instanceof String))) {
            throw new IllegalArgumentException();
        }

        // ݓt̕擾B
        Date d = new Date();
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        String currentDate = f.format(d);

        // t̕assertEqualsB
        assertEqualsDate(currentDate, actual);
    }

    /**
     * t@C̒goCirB
     * 
     * <pre>
     * [gp]
     * class SampleTest extends TestCase {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testDoSomething() throws Excepton {
     *         // Ȃ炩̏sʂ̃t@C߂B
     *         File actual = Sample.doSomething();
     * 
     *         // r邽߂̊Ғlf[^̃t@C擾B
     *         // t@CSampleTestNXƓtH_ɒuĂB
     *         File expected = UTUtil.getFile(this, &quot;expected.txt&quot;);
     * 
     *         // t@C̔rB
     *         UTUtil.assertEqualsFile(expected, actual);
     *          
     *     }
     * }
     * </pre>
     * @param expected Ғl̃t@C
     * @param actual ۂ̒l̃t@C
     */
    public static void assertEqualsFile(File expected, File actual) {

        // p[^null̏ꍇ͗OԂB
        if ((expected == null) || (actual == null)) {
            throw new IllegalArgumentException();
        }

        // gr邽߂̃bp[IuWFNg(FileContent)𐶐
        FileContent expectedContent = new FileContent(expected);
        FileContent actualContent = new FileContent(actual);

        // assertɂB
        Assert.assertTrue(expectedContent.equals(actualContent));
    }

    /**
     * eXgNXƓtH_ɒuĂeXgpt@C FileIuWFNg擾B
     * 
     * <pre>
     * [gp]
     * class SampleTest extends TestCase {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testDoSomething() throws Excepton {
     *         // Ȃ炩̏sʂ̃t@C߂B
     *         File actual = Sample.doSomething();
     * 
     *         // r邽߂̊Ғlf[^̃t@C擾B
     *         // t@CSampleTestNXƓtH_ɒuĂB
     *         File expected = UTUtil.getFile(SampleTest.class, &quot;expected.txt&quot;);
     * 
     *         // t@C̔rB
     *         UTUtil.assertEqualsFile(expected, actual);
     *          
     *     }
     * }
     * </pre>
     * @param cls eXgNXClassIuWFNg
     * @param filename t@C
     * @return w肳ꂽt@CFileIuWFNgB t@C݂ȂꍇnullԂB
     */
    @SuppressWarnings("unchecked")
    public static File getFile(Class cls, String filename) {

        // t@CkA󕶎̏ꍇ̓kԂB
        if ((filename == null) || ("".equals(filename))) {
            return null;
        }

        // w肳ꂽt@CURL擾B
        // "file://c:/folder/filename"̂悤URLB
        URL url = cls.getResource(filename);

        // URLkȂ΃kԂB
        if (url == null) {
            return null;
        }

        // URLURI𐶐B
        // URISyntaxException邱Ƃ͎゠蓾Ȃ̂ŁAcatchȉ
        // R[h̓kԂɂĂB
        URI uri = null;
        try {
            uri = new URI(url.toString());
        } catch (URISyntaxException e) {
            return null;
        }

        // FileIuWFNg𐶐ĕԂB
        return new File(uri);
    }

    /**
     * eXgNXƓtH_ɒuĂeXgpt@C FileIuWFNg擾B
     * 
     * <pre>
     * [gp]
     * class SampleTest extends TestCase {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testDoSomething() throws Excepton {
     *         // Ȃ炩̏sʂ̃t@C߂B
     *         File actual = Sample.doSomething();
     * 
     *         // r邽߂̊Ғlf[^̃t@C擾B
     *         // t@CSampleTestNXƓtH_ɒuĂB
     *         File expected = UTUtil.getFile(this, &quot;expected.txt&quot;);
     * 
     *         // t@C̔rB
     *         UTUtil.assertEqualsFile(expected, actual);
     *          
     *     }
     * }
     * </pre>
     * @param instance eXgNX̃CX^X
     * @param filename t@C
     * @return w肳ꂽt@CFileIuWFNgB t@C݂ȂꍇnullԂB
     */
    public static File getFile(Object instance, String filename) {
        return getFile(instance.getClass(), filename);
    }

    /**
     * private\bhistaticłȂ́jĂяoB<BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA 𗘗pVvɋLqłB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int calcAdd(int val1, int val2, int val3) {
     *         return val1 + val2 + val3;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Sample sample = new Sample();
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             sample,
     *             &quot;calcAdd&quot;,
     *             new Class[] { int.class, int.class, int.class },
     *             new Object[] { new Integer(1), new Integer(2), 
     *                            new Integer(3) }
     *         );
     *         assertEquals(6, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Object target, String methodName,
            Class[] argTypes, Object[] args) throws Exception {

        return PrivateAccessUtil.invokePrivate(target, methodName, argTypes,
                args);
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^0pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int getString() {
     *         return &quot;success&quot;;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testGetString() {
     *         Sample sample = new Sample();
     *         String result = 
     *             (String) UTUtil.invokePrivate(sample, &quot;getString&quot;):
     *         assertEquals(&quot;success&quot;, result);
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName)
                                                                        throws Exception {

        return invokePrivate(target, methodName, new Class[] {},
                new Object[] {});
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^1pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private long square(long val) {
     *         return val &circ; 2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testSquare() {
     *         Sample sample = new Sample();
     *         Long result = (Long) UTUtil.invokePrivate(
     *             sample, &quot;square&quot;, long.class, new Long(2L)):
     *         assertEquals(4, result.longValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Object target, String methodName,
            Class argType, Object arg) throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
                new Object[] { arg });
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^2pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2) {
     *         return val1 + val2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Sample sample = new Sample();
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             sample,
     *             &quot;calcAdd&quot;,
     *             int.class,
     *             int.class,
     *             new Integer(1),
     *             new Integer(2)
     *         );
     *         assertEquals(3, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Object target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
                                                                     throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType1,
                argType2 }, new Object[] { arg1, arg2 });
    }

    /**
     * staticprivate\bhĂяoB <BR>
     * <BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA 𗘗pVvɋLqłB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2, int val3) {
     *         return val1 + val2 + val3;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             Sample.class,
     *             &quot;calcAdd&quot;,
     *             new Class[] { int.class, int.class, int.class },
     *             new Object[] { new Integer(1), new Integer(2), 
     *                            new Integer(3) }
     *         );
     *         assertEquals(6, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName,
            Class[] argTypes, Object[] args) throws Exception {

        return PrivateAccessUtil.invokePrivate(target, methodName, argTypes,
                args);
    }

    /**
     * staticprivate\bhĂяoip[^0pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int getString() {
     *         return &quot;success&quot;;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testGetString() {
     *         String result = (String) UTUtil.invokePrivate(
     *             Sample.class, &quot;getString&quot;):
     *         assertEquals(&quot;success&quot;, result);
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName)
                                                                       throws Exception {

        return invokePrivate(target, methodName, new Class[] {},
                new Object[] {});
    }

    /**
     * staticprivate\bhĂяoip[^1pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static long square(long val) {
     *         return val &circ; 2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testSquare() {
     *         Long result = (Long) UTUtil.invokePrivate(
     *             Sample.class, &quot;square&quot;, long.class, new Long(2L)):
     *         assertEquals(4, result.longValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName,
            Class argType, Object arg) throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
                new Object[] { arg });
    }

    /**
     * staticprivate\bhĂяoip[^2pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2) {
     *         return val1 + val2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             Sample.class,
     *             &quot;calcAdd&quot;,
     *             int.class,
     *             int.class,
     *             new Integer(1),
     *             new Integer(2)
     *         );
     *         assertEquals(3, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
                                                                     throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType1,
                argType2 }, new Object[] { arg1, arg2 });
    }

    /**
     * w肵IuWFNgprivatetB[h̒lԂB
     * @param target Ώۂ̃IuWFNg
     * @param fieldName l擾privatetB[h̖O
     * @return privatetB[h̒l
     * @exception NoSuchFieldException
     */
    @SuppressWarnings("unchecked")
    public static Object getField(Object target, String fieldName)
                                                                  throws NoSuchFieldException {

        // p[^l̃`FbN
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (fieldName == null || fieldName.equals("")) {
            throw new IllegalArgumentException();
        }

        // privatetB[h擾B
        // X[p[NXSĂɂČĂяogCB
        for (Class c = target.getClass(); c != null; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(target);
            } catch (Exception e) {
                // 擾悤ƂtB[h݂ȂꍇAȂB
                // (eNXœgCJԂ)
            }
        }
        // 擾悤ƂtB[h݂Ȃꍇ
        throw new NoSuchFieldException("Could get value for field "
                + target.getClass().getName() + "." + fieldName);
    }

    /**
     * w肵NXstaticprivatetB[h̒lԂB
     * @param target Ώۂ̃NX
     * @param fieldName l擾privatetB[h̖O
     * @return privatetB[h̒l
     * @exception NoSuchFieldException
     */
    @SuppressWarnings("unchecked")
    public static Object getField(Class target, String fieldName)
                                                                 throws NoSuchFieldException {

        // p[^l̃`FbN
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (fieldName == null || fieldName.equals("")) {
            throw new IllegalArgumentException();
        }

        // privatetB[h擾B
        // X[p[NXSĂɂČĂяogCB
        Class c = target;
        while (c != null) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(c);
            } catch (Exception e) {
                // 擾悤ƂtB[h݂ȂꍇAȂB
                // (eNXœgCJԂ)
            }
            c = c.getSuperclass();
        }
        // 擾悤ƂtB[h݂Ȃꍇ
        throw new NoSuchFieldException("Could get value for field "
                + target.getName() + "." + fieldName);
    }

    /**
     * w肵IuWFNgprivatetB[hɒlݒ肷B
     * @param target Ώۂ̃IuWFNg
     * @param fieldName lݒ肷privatetB[h̖O
     * @param value ݒ肷lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @exception NoSuchFieldException
     */
    @SuppressWarnings("unchecked")
    public static void setField(Object target, String fieldName, Object value)
                                                                              throws NoSuchFieldException {

        // p[^l̃`FbN
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (fieldName == null || fieldName.equals("")) {
            throw new IllegalArgumentException();
        }

        // privatetB[hݒ菈B
        // X[p[NXSĂɂČĂяogCB
        for (Class c = target.getClass(); c != null; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(target, value);
                return;
            } catch (Exception e) {
                // ݒ肵悤ƂtB[h݂ȂꍇAȂB
                // (eNXœgCJԂ)
            }
        }
        // ݒ肵悤ƂtB[h݂Ȃꍇ
        throw new NoSuchFieldException("Could set value for field "
                + target.getClass().getName() + "." + fieldName);
    }

    /**
     * w肵NXstaticprivatetB[hɒlݒ肷B
     * @param target Ώۂ̃NX
     * @param fieldName lݒ肷privatetB[h̖O
     * @param value ݒ肷lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @exception NoSuchFieldException
     */
    @SuppressWarnings("unchecked")
    public static void setField(Class target, String fieldName, Object value)
                                                                             throws NoSuchFieldException {

        // p[^l̃`FbN
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (fieldName == null || fieldName.equals("")) {
            throw new IllegalArgumentException();
        }

        Class c = target;
        while (c != null) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(c, value);
                return;
            } catch (Exception ex) {
                // ݒ肵悤ƂtB[h݂ȂꍇAȂB
                // (eNXœgCJԂ)
            }
            c = c.getSuperclass();
        }
        // ݒ肵悤ƂtB[h݂Ȃꍇ
        throw new NoSuchFieldException("Could set value for static field "
                + target.getName() + "." + fieldName);
    }
}
