/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.PlainFileUpdateDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CsIuWFNgpȂt@Co͗pFileLineWriter𐶐B<br>
 * AbstractFileUpdateDAÕTuNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.PlainFileUpdateDAO
 */
public class PlainFileUpdateDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(PlainFileUpdateDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public PlainFileUpdateDAOTest(String name) {
        super(name);
    }

    /**
     * testExecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:PlainFileUpdateDAO01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:PlainFileUpdateDAO_Stub01<br>
     * @<br>
     * () AbstractFileUpdateDAO.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatterCX^X<br>
     * <br>
     * ҒlF(߂l) FileLineWriter:PlainFileLineWriter̃CX^X<br>
     * (ԕω) PlainFileLineWriter#PlainFileLineWriter():PĂяo邱<br>
     * n邱<br>
     * <br>
     * p^[<br>
     * ꂼnot nullł΁A߂lAĂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecute01() throws Exception {
        // eXgΏۂ̃CX^X
        PlainFileUpdateDAO fileUpdateDAO = new PlainFileUpdateDAO();

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<PlainFileUpdateDAO_Stub01> clazz = PlainFileUpdateDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        UTUtil.setPrivateField(fileUpdateDAO, "columnFormatterMap",
                columnFormatterMap);

        // eXg{
        FileLineWriter fileLineWriter = fileUpdateDAO.execute(fileName, clazz);

        // ԋpl̊mF
        assertEquals(PlainFileLineWriter.class, fileLineWriter.getClass());

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(PlainFileLineWriter.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(PlainFileLineWriter.class,
                "<init>", 0);
        assertSame(fileName, arguments.get(0));
        assertSame(clazz, arguments.get(1));
        assertSame(columnFormatterMap, arguments.get(2));
    }
}
