/*
 * $Id: NullColumnFormatterTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.NullColumnFormatter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Ame[VcolumnFormat̋Lqɏ]A̕ϊsB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.NullColumnFormatter
 */
public class NullColumnFormatterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(NullColumnFormatterTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public NullColumnFormatterTest(String name) {
        super(name);
    }

    /**
     * testFormat01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lF"aaa"<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(߂l) String:methodString^Ɋi[Ăl̕B<br>
     * <br>
     * t@CsIuWFNgString^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat01() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub01 stub = new NullColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "string", "aaa");
        Method method = stub.getClass().getDeclaredMethod("getString");
        String columnFormat = new String();

        // OȂ

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("aaa", testResult);

        // ԕωȂ
    }

    /**
     * testFormat02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lF"aaa"<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fprivate<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) -:IllegalAccessException邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgString^getter\bhɃANZXłȂꍇAIllegalAccessExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat02() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub02 stub = new NullColumnFormatter_Stub02();
        UTUtil.setPrivateField(stub, "string", "aaa");
        Method method = stub.getClass().getDeclaredMethod("getString");
        String columnFormat = new String();

        // OȂ

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("IllegalAccessException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalAccessException.class, e.getClass());
        }
    }

    /**
     * testFormat03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lFOX[<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) -:InvocationTargetException邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgString^getter\bhOX[ꍇAgetter\bhX[ObvInvocationTargetExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat03() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub03 stub = new NullColumnFormatter_Stub03();
        UTUtil.setPrivateField(stub, "string", "aaa");
        Method method = stub.getClass().getMethod("getString");
        String columnFormat = new String();

        // OȂ

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("InvocationTargetException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(InvocationTargetException.class, e.getClass());
        }
    }

    /**
     * testFormat04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lF"aaa"<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) -:IllegalArgumentException邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgString^getter\bḧꍇAIllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat04() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub04 stub = new NullColumnFormatter_Stub04();
        UTUtil.setPrivateField(stub, "string", "aaa");
        Method method = stub.getClass().getDeclaredMethod("getString",
                new Class[] { String.class });
        String columnFormat = new String();

        // OȂ

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    /**
     * testFormat05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(߂l) String:""(󕶎)<br>
     * <br>
     * t@CsIuWFNg̃tB[hNull̏ꍇA󕶎ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat05() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub01 stub = new NullColumnFormatter_Stub01();
        Method method = stub.getClass().getDeclaredMethod("getString");
        String columnFormat = new String();

        // OȂ

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("", testResult);

        // ԕωȂ
    }

    /**
     * testFormat06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :null<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:MethodCX^X<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) -:NullPointException邱ƂmF<br>
     * <br>
     * tnullꍇ́ANullPointerExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat06() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub01 stub = new NullColumnFormatter_Stub01();
        Method method = stub.getClass().getDeclaredMethod("getString");
        String columnFormat = new String();

        // OȂ

        // eXg{
        try {
            columnFormatter.format(null, method, columnFormat);
            fail("NullPointerException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(NullPointerException.class, e.getClass());
        }
    }

    /**
     * testFormat07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lF"aaa"<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:null<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) -:NullPointException邱ƂmF<br>
     * <br>
     * t@CsIuWFNg(t)ɂString^getter\bhmethodNull̏ꍇNullPointExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat07() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub01 stub = new NullColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "string", "aaa");
        String columnFormat = new String();

        // OȂ

        // eXg{
        try {
            columnFormatter.format(stub, null, columnFormat);
            fail("NullPointerException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(NullPointerException.class, e.getClass());
        }
    }

    /**
     * testFormat08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :IuWFNg<br>
     * ȉ̒l<br>
     * @lF"aaa"<br>
     * () t@CsIuWFNg(t)ɂString^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:null<br>
     * <br>
     * ҒlF(߂l) String:methodString^Ɋi[Ăl̕B<br>
     * <br>
     * tH[}bgp̕columnFormatNull̏ꍇɐšʂݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat08() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new NullColumnFormatter();

        // ̐ݒ
        NullColumnFormatter_Stub01 stub = new NullColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "string", "aaa");
        Method method = stub.getClass().getDeclaredMethod("getString");
        String columnFormat = null;

        // OȂ

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("aaa", testResult);

        // ԕωȂ
    }
}
