/*
 * $Id: EncloseCharLineFeed2LineReaderTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.easymock.classextension.EasyMock;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.EncloseCharLineFeed2LineReader} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ͂ݕLAs؂蕶2̏ꍇ̃t@C1s̕擾鏈sB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.EncloseCharLineFeed2LineReader
 */
public class EncloseCharLineFeed2LineReaderTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(EncloseCharLineFeed2LineReaderTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public EncloseCharLineFeed2LineReaderTest(String name) {
        super(name);
    }

    /**
     * testEncloseCharLineFeed2LineReader01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() delimiterCharacter:not null<br>
     * 'a'<br>
     * () encloseCharacter:not null<br>
     * 'b'<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:not noll<br>
     * "\r\n"<br>
     * <br>
     * ҒlF(ԕω) this.delimiterCharacter:delimiterCharacterƓCX^X<br>
     * (ԕω) this.encloseCharacter:encloseCharacterƓCX^X<br>
     * (ԕω) this.reader:readerƓCX^X<br>
     * (ԕω) this.lineFeedChar:lineFeedCharƓCX^X<br>
     * <br>
     * IuWFNgł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader01() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char dChar = 'a';
        char[] eChar = { 'b' };
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";

        // OȂ

        // eXg{
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // ԋplȂ

        // ԕω̊mF
        char delimiterCharacter = (Character) UTUtil.getPrivateField(testCalss,
                "delimiterCharacter");
        assertEquals(dChar, delimiterCharacter);
        char[] encloseCharacter = (char[]) UTUtil.getPrivateField(testCalss,
                "columnEncloseCharacter");
        assertEquals(eChar, encloseCharacter);
        Reader reader = (Reader) UTUtil.getPrivateField(testCalss, "reader");
        assertEquals(bufferedReader, reader);
        String lineFeedChar = (String) UTUtil.getPrivateField(testCalss,
                "lineFeedChar");
        assertEquals(parm, lineFeedChar);
    }

    /**
     * testEncloseCharLineFeed2LineReader02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() delimiterCharacter:Character.MIN_VALUE<br>
     * () encloseCharacter:\"<br>
     * () reader:BufferedReader̃CX^X<br>
     * () lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF"delimiterCharacter can not use '\\u0000'."<br>
     * <br>
     * ؂蕶'\u0000'ꍇAIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader02() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char delimiterCharacter = Character.MIN_VALUE;
        char[] encloseCharacter = { '"' };
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";

        // OȂ

        // eXg{
        try {
            new EncloseCharLineFeed2LineReader(delimiterCharacter,
                    Character.MIN_VALUE, encloseCharacter, bufferedReader,
                    lineFeedChar);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("delimiterCharacter can not use '\\u0000'.", e
                    .getMessage());
        }
    }

    /**
     * testEncloseCharLineFeed2LineReader03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() delimiterCharacter:,'<br>
     * () encloseCharacter:Character.MIN_VALUE<br>
     * () reader:BufferedReader̃CX^X<br>
     * () lineFeedChar:""<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF"encloseCharacter can not use '\\u0000'."<br>
     * <br>
     * ͂ݕ'\u0000'ꍇAIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader03() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char delimiterCharacter = ',';
        char[] encloseCharacter = null;
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";

        // OȂ

        // eXg{
        try {
            new EncloseCharLineFeed2LineReader(delimiterCharacter,
                    Character.MIN_VALUE, encloseCharacter, bufferedReader,
                    lineFeedChar);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("columnEncloseCharacter is required.", e.getMessage());
        }
    }

    /**
     * testEncloseCharLineFeed2LineReader04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() delimiterCharacter:,'<br>
     * () encloseCharacter:"\"<br>
     * () reader:null<br>
     * () lineFeedChar:""<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF"reader is required."<br>
     * <br>
     * t@CANZXp̕Xg[nullꍇAIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader04() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char delimiterCharacter = ',';
        char[] encloseCharacter = { '\"' };
        BufferedReader bufferedReader = null;
        String lineFeedChar = "\r\n";

        // OȂ

        // eXg{
        try {
            new EncloseCharLineFeed2LineReader(delimiterCharacter,
                    Character.MIN_VALUE, encloseCharacter, bufferedReader,
                    lineFeedChar);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("reader is required.", e.getMessage());
        }
    }

    /**
     * testEncloseCharLineFeed2LineReader05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() delimiterCharacter:,'<br>
     * () encloseCharacter:"\"<br>
     * () reader:BufferedReader̃CX^X<br>
     * () lineFeedChar:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF"lineFeedChar is required."<br>
     * <br>
     * s؂蕶nullꍇAIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader05() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char delimiterCharacter = ',';
        char[] encloseCharacter = { '\"' };
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String lineFeedChar = null;

        // OȂ

        // eXg{
        try {
            new EncloseCharLineFeed2LineReader(delimiterCharacter,
                    Character.MIN_VALUE, encloseCharacter, bufferedReader,
                    lineFeedChar);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("lineFeedChar is required.", e.getMessage());
        }
    }

    /**
     * testEncloseCharLineFeed2LineReader06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() delimiterCharacter:,'<br>
     * () encloseCharacter:"\"<br>
     * () reader:BufferedReader̃CX^X<br>
     * () lineFeedChar:""<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF"lineFeedChar should be defined by 2 digit of character string."<br>
     * <br>
     * s؂蕶2ȊOꍇAIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader06() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char delimiterCharacter = ',';
        char[] encloseCharacter = { '\"' };
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "";

        // OȂ

        // eXg{
        try {
            new EncloseCharLineFeed2LineReader(delimiterCharacter,
                    Character.MIN_VALUE, encloseCharacter, bufferedReader,
                    lineFeedChar);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("lineFeedChar should be defined by 2"
                    + " digit of character string.", e.getMessage());
        }
    }

    /**
     * testEncloseCharLineFeed2LineReader07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() delimiterCharacter:,'<br>
     * () encloseCharacter:"\"<br>
     * () reader:BufferedReader̃CX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF"lineFeedChar should be defined by 2 digit of character string."<br>
     * <br>
     * s؂蕶2ȊOꍇAIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testEncloseCharLineFeed2LineReader07() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        char delimiterCharacter = ',';
        char[] encloseCharacter = { '\"' };
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r";

        // OȂ

        // eXg{
        try {
            new EncloseCharLineFeed2LineReader(delimiterCharacter,
                    Character.MIN_VALUE, encloseCharacter, bufferedReader,
                    lineFeedChar);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("lineFeedChar should be defined by 2"
                    + " digit of character string.", e.getMessage());
        }
    }

    /**
     * testReadLine01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() reader:not null<br>
     * ReaderX^u<br>
     * #ready(), #read()IOExceptionX[<br>
     * () lineFeedChar:not null<br>
     * "\r\n"<br>
     * () delimiter:not null<br>
     * 'a'<br>
     * () encloseCharacter:not null<br>
     * 'b'<br>
     * <br>
     * ҒlF(ԕω) Ȃ:IOExceptionBFileExceptioɃbv邱ƂmFB<br>
     * bZ[WF"Reader control operation was failed."<br>
     * <br>
     * Readerf[^̓ǂݎɎsꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine01() throws Exception {
        // Mock쐬
        Reader reader = EasyMock.createMock(Reader.class);
        EasyMock.expect(reader.read()).andReturn(null).andThrow(
                new IOException());
        EasyMock.replay(reader);

        // eXgΏۂ̃CX^X
        char dChar = 'a';
        char[] eChar = { 'b' };
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader target = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, reader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        try {
            target.readLine();
            fail("FileExceptionX[܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals(IOException.class.getName(), e.getCause().getClass()
                    .getName());
            assertEquals("Reader control operation was failed.", e.getMessage());
        }
    }

    /**
     * testReadLine02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:""()<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:not null<br>
     * "\r\n"<br>
     * () delimiter:not null<br>
     * 'a'<br>
     * () encloseCharacter:not null<br>
     * 'b'<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * ǂݍ񂾃f[^Ȃi󕶎j̏ꍇA󕶎ƂĕԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine02() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = 'a';
        char[] eChar = { 'b' };
        byte[] buf = "".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("", result);

        // ԕωȂ
    }

    /**
     * testReadLine03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,aaa,aaa\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aaa,aaa"<br>
     * <br>
     * ͂ݕȂꍇ́As؂蕶񂪕ԋp <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine03() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "aaa,aaa,aaa\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("aaa,aaa,aaa", result);

        // ԕωȂ
    }

    /**
     * testReadLine04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aaa\",\"aaa\",\"aaa\"\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"\"aaa\",\"aaa\",\"aaa\""<br>
     * <br>
     * ͂ݕꍇ́AŌ̍s؂蕶񂪕ԋp <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine04() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "\"aaa\",\"aaa\",\"aaa\"\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("\"aaa\",\"aaa\",\"aaa\"", result);

        // ԕωȂ
    }

    /**
     * testReadLine05() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aa,a\",\"aa\"\"a\",\"aa\r\na\"\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"\"aa,a\",\"aa\"\"a\",\"aa\r\na\""<br>
     * <br>
     * ̒Ɉ͂ݕA؂蕶As؂蕶܂܂ĂꍇB@i͂ݕ̃GXP[vȂǁj <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine05() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "\"aa,a\",\"aa\"\"a\",\"aa\r\na\"\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("\"aa,a\",\"aa\"\"a\",\"aa\r\na\"", result);

        // ԕωȂ
    }

    /**
     * testReadLine06() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aaa\",\"aaa\",\"aaa\"aaa\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"\"aaa\",\"aaa\",\"aaa\"aaa"<br>
     * <br>
     * 1sԋpB͂ݕ(I)̌ɕ񂪂ȂꍇA؂蕶͍s؂蕶܂ł͑̕SđÕJɊ܂܂B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine06() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "\"aaa\",\"aaa\",\"aaa\"aaa\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("\"aaa\",\"aaa\",\"aaa\"aaa", result);

        // ԕωȂ
    }

    /**
     * testReadLine07() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * ̒ɍs؂蕶̂݁B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine07() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("", result);
    }

    /**
     * testReadLine08() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\n\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"\n"<br>
     * <br>
     * s؂蕶\Ă镶̂P{s؂蕶ǂݍ񂾏ꍇA\̂ݕԋp <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine08() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "\n\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("\n", result);

        // ԕωȂ
    }

    /**
     * testReadLine09() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"aaa"<br>
     * <br>
     * s؂蕶Ȃf[^ǂݍ񂾏ꍇAŏIf[^܂ł̕񂪕ԋp <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine09() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "aaa".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("aaa", result);

        // ԕωȂ
    }

    /**
     * testReadLine10() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,aaa,aaa\r\naaa,aaa"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aaa,aaa"<br>
     * <br>
     * ǂݍ񂾃f[^̓rɍs؂蕶܂܂ĂꍇA܂ł̕񂪕ԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine10() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "aaa,aaa,aaa\r\naaa,aaa".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("aaa,aaa,aaa", result);

        // ԕωȂ
    }

    /**
     * testReadLine11() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,aa\ra,aaa\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aa\ra,aaa"<br>
     * <br>
     * ǂݍ񂾃f[^̓r\r܂܂ĂꍇÄꕔɊ܂܂B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine11() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "aaa,aa\ra,aaa\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("aaa,aa\ra,aaa", result);

        // ԕωȂ
    }

    /**
     * testReadLine12() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,,\r\n"<br>
     * () reader:not null<br>
     * BufferedReader̃CX^X<br>
     * () lineFeedChar:'\r\n'<br>
     * () delimiter:','<br>
     * () encloseCharacter:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"aaa,,"<br>
     * <br>
     * ǂݍ񂾃f[^̓rɑSp܂܂ꍇB<br>
     * s؂蕶񂪕ԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine12() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', '\"', '\"', '\"' };
        byte[] buf = "aaa,,\r\n".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // Ȃ

        // O(CX^XŐݒ肳B)

        // eXg{
        String result = testCalss.readLine();

        // ԋpl̊mF
        assertEquals("aaa,,", result);

        // ԕωȂ
    }

    /**
     * n<br>
     * J̈͂ݕݒL
     * @throws Exception
     */
    public void testReadLine13() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', Character.MIN_VALUE, '|' };
        byte[] buf = "\"aaa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // eXg{
        String result = testCalss.readLine();

        // ԋplȂ
        assertEquals("\"aaa\",\"aaa\",|aaaaaa|", result);
    }

    /**
     * n<br>
     * J̈͂ݕݒL
     * @throws Exception
     */
    public void testReadLine14() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eChar = { '\"', Character.MIN_VALUE, '|' };
        byte[] buf = "\"a\r\naa\",\"aaa\",|aaa\r\naaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, Character.MIN_VALUE, eChar, bufferedReader, parm);

        // eXg{
        String result = testCalss.readLine();

        // ԋplȂ
        assertEquals("\"a\r\naa\",\"aaa\",|aaa\r\naaa|", result);
    }

    /**
     * n<br>
     * eColChar.length : 0
     * @throws Exception
     */
    public void testReadLine15() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eColChar = {};
        char eChar = '\"';
        byte[] buf = "\"a\r\naa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, eChar, eColChar, bufferedReader, parm);

        // eXg{
        String result = testCalss.readLine();

        // ԋplȂ
        assertEquals("\"a\r\naa\",\"aaa\",|aaaaaa|", result);
    }

    /**
     * testGetEncloseCharcter001.
     * @throws Exception
     */
    public void testGetEncloseCharcter001() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eColChar = { '\"', '\"', '\"', '\"' };
        char eChar = '\'';
        byte[] buf = "\"a\raa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, eChar, eColChar, bufferedReader, parm);

        int index = 0;

        // eXg{
        Object result = UTUtil.invokePrivate(testCalss, "getEncloseCharcter",
                int.class, index);

        // ԋplȂ
        assertNotNull(result);
        assertEquals(Character.valueOf('\"'), (Character) result);
    }

    /**
     * testGetEncloseCharcter002.
     * @throws Exception
     */
    public void testGetEncloseCharcter002() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eColChar = { '\"', '\"', '\"', '\"' };
        char eChar = '\'';
        byte[] buf = "\"a\raa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, eChar, eColChar, bufferedReader, parm);

        int index = 1;

        // eXg{
        Object result = UTUtil.invokePrivate(testCalss, "getEncloseCharcter",
                int.class, index);

        // ԋplȂ
        assertNotNull(result);
        assertEquals(Character.valueOf('\"'), (Character) result);
    }

    /**
     * testGetEncloseCharcter003.
     * @throws Exception
     */
    public void testGetEncloseCharcter003() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eColChar = { '\"', '\"', '\"', '\"' };
        char eChar = '\'';
        byte[] buf = "\"a\raa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, eChar, eColChar, bufferedReader, parm);

        int index = 3;

        // eXg{
        Object result = UTUtil.invokePrivate(testCalss, "getEncloseCharcter",
                int.class, index);

        // ԋplȂ
        assertNotNull(result);
        assertEquals(Character.valueOf('\"'), (Character) result);
    }

    /**
     * testGetEncloseCharcter004.
     * @throws Exception
     */
    public void testGetEncloseCharcter004() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eColChar = { '\"', '\"', '\"', '\"' };
        char eChar = '\'';
        byte[] buf = "\"a\raa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, eChar, eColChar, bufferedReader, parm);

        int index = 4;

        // eXg{
        Object result = UTUtil.invokePrivate(testCalss, "getEncloseCharcter",
                int.class, index);

        // ԋplȂ
        assertNotNull(result);
        assertEquals(Character.valueOf('\''), (Character) result);
    }

    /**
     * testGetEncloseCharcter005.
     * @throws Exception
     */
    public void testGetEncloseCharcter005() throws Exception {
        // eXgΏۂ̃CX^X
        char dChar = ',';
        char[] eColChar = { '\"', '\"', '\"', '\"' };
        char eChar = '\'';
        byte[] buf = "\"a\raa\",\"aaa\",|aaaaaa|\r\naaa".getBytes();

        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(new ByteArrayInputStream(buf)));

        String parm = "\r\n";
        EncloseCharLineFeed2LineReader testCalss = new EncloseCharLineFeed2LineReader(
                dChar, eChar, eColChar, bufferedReader, parm);

        int index = 5;

        // eXg{
        Object result = UTUtil.invokePrivate(testCalss, "getEncloseCharcter",
                int.class, index);

        // ԋplȂ
        assertNotNull(result);
        assertEquals(Character.valueOf('\''), (Character) result);
    }

}
