/*
 * $Id: 
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.DateColumnParser} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> w肳ꂽp[YADate^ɕϊB<br>
 * ϊʂt@CsIuWFNgDate^̑ɒli[B
 * <p>
 * @author c Ni
 * @see jp.terasoluna.fw.file.dao.standard.DateColumnParser
 */
public class DateColumnParserTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(DateColumnParserTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DateColumnParserTest(String name) {
        super(name);
    }

    /**
     * testParse01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() column:"20060101"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:null  󕶎<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 yyyyMMdd`̕Date^Ƀp[Xl<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * <br>
     * columnFormatnull󕶎ŁA}bv̏ꍇA tH[}bgp̃CX^XLbV邱ƂmFB<br>
     * t@CsIuWFNgɁAcolumnŐݒ肵 Date^Ƀp[Xlݒł邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse01() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "20060101";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(dateColumnParser, "map", map);

        // eXg{
        dateColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        // 񂩂Date^ɕϊ
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setLenient(false);
        Date expected = simpleDateFormat.parse(column);
        assertEquals(expected, result);

        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));

        assertEquals(1, map.size());
        assertNotNull(map.get("yyyyMMdd"));
    }

    /**
     * testParse02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() column:"20060101"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:null  󕶎<br>
     * () map:key:"yyyyMMdd"<br>
     * value:new DateFormatLocal("yyyyMMdd")<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 yyyyMMdd`̕Date^Ƀp[Xl<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bhĂ΂ȂB<br>
     * <br>
     * columnFormatnull󕶎ŁA}bv"yyyyMMdd"L[ɂ LbV݂ꍇ́AVɃLbVȂƁB<br>
     * t@CsIuWFNgɁAcolumnŐݒ肵 Date^Ƀp[Xlݒł邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse02() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "20060101";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        DateFormatLocal cache = new DateFormatLocal("yyyyMMdd");
        map.put("yyyyMMdd", cache);
        UTUtil.setPrivateField(dateColumnParser, "map", map);

        // eXg{
        dateColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setLenient(false);
        Date expected = simpleDateFormat.parse(column);
        assertEquals(expected, result);
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "put"));

        assertEquals(1, map.size());
        assertSame(cache, map.get("yyyyMMdd"));
    }

    /**
     * testParse03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() column:"20060101"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂ Date^setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:null  󕶎<br>
     * () map:key:"yyyy-MM-dd"<br>
     * value:new DateFormatLocal("yyyy-MM-dd")<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 yyyyMMdd`̕Date^Ƀp[Xl<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * <br>
     * columnFormatnull󕶎ŁA}bv"yyyyMMdd"ȊOL[ɂ LbV݂ꍇ́A"yyyyMMdd"L[ɂtH[}bgp CX^XLbV邱ƁB<br>
     * t@CsIuWFNgɁAcolumnŐݒ肵Date^ p[Xlݒł邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse03() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "20060101";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        DateFormatLocal cache = new DateFormatLocal("yyyy-MM-dd");
        map.put("yyyy-MM-dd", cache);
        UTUtil.setPrivateField(dateColumnParser, "map", map);

        // eXg{
        dateColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setLenient(false);
        Date expected = simpleDateFormat.parse(column);
        assertEquals(expected, result);
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));

        assertEquals(2, map.size());
        assertNotNull(map.get("yyyyMMdd"));
        assertSame(cache, map.get("yyyy-MM-dd"));
    }

    /**
     * testParse04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 yyyy-MM-dd`̕Date^Ƀp[Xl<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * <br>
     * columnFormatɃtH[}bgp񂪐ݒ肳ĂA }bv̏ꍇ́AcolumnFormat̕L[ɃLbV邱ƁB<br>
     * t@CsIuWFNgɁAcolumnŐݒ肵Date^ p[Xlݒł邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse04() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(dateColumnParser, "map", map);

        // eXg{
        dateColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setLenient(false);
        Date expected = simpleDateFormat.parse(column);
        assertEquals(expected, result);
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));

        assertEquals(1, map.size());
        assertNotNull(map.get("yyyy-MM-dd"));
    }

    /**
     * testParse05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂ Date^setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:key:"yyyy-MM-dd"<br>
     * value:new DateFormatLocal("yyyy-MM-dd")<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 yyyy-MM-dd`̕Date^Ƀp[Xl<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bhĂ΂ȂB<br>
     * <br>
     * columnFormatɃtH[}bgp񂪐ݒ肳ĂA }bvɃtH[}bgpL[ɂLbV݂ꍇ́A VɃLbVȂƁB<br>
     * t@CsIuWFNgɁAcolumnŐݒ肵Date^ p[Xlݒł邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse05() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        DateFormatLocal cache = new DateFormatLocal(columnFormat);
        map.put(columnFormat, cache);
        UTUtil.setPrivateField(dateColumnParser, "map", map);

        // eXg{
        dateColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setLenient(false);
        Date expected = simpleDateFormat.parse(column);
        assertEquals(expected, result);
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "put"));

        assertEquals(1, map.size());
        assertSame(cache, map.get("yyyy-MM-dd"));
    }

    /**
     * testParse06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:key:"yyyy/MM/dd"<br>
     * value:new DateFormatLocal("yyyy/MM/dd")<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 yyyy-MM-dd`̕Date^Ƀp[Xl<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * <br>
     * columnFormatɃtH[}bgp񂪐ݒ肳ĂA }bvɃtH[}bgpL[ɂLbV݂Ȃꍇ́A LbV邱ƁB<br>
     * t@CsIuWFNgɁAcolumnŐݒ肵Date^ p[Xlݒł邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse06() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        DateFormatLocal cache = new DateFormatLocal("yyyy/MM/dd");
        map.put("yyyy/MM/dd", cache);
        UTUtil.setPrivateField(dateColumnParser, "map", map);

        // eXg{
        dateColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setLenient(false);
        Date expected = simpleDateFormat.parse(column);
        assertEquals(expected, result);
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));

        assertEquals(2, map.size());
        assertSame(cache, map.get("yyyy/MM/dd"));
        assertNotNull(map.get("yyyy-MM-dd"));
    }

    /**
     * testParse07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:formatłȂ<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:ParseException邱ƂmFB<br>
     * <br>
     * tH[}bgɂ肦Ȃlݒ肳ꂽꍇAParseException 邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse07() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd-MM";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("ParseExceptionX[܂B");
        } catch (ParseException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(ParseException.class, e.getClass());
            assertEquals("Unparseable date: \"2006-01-01\"", e.getMessage());
        }
    }

    /**
     * testParse08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fprivate<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:IllegalAccessException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgDate^setter\bh ANZXłȂꍇAIllegalAccessExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse08() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod(
                "setAPrivate", new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("IllegalAccessExceptionX[܂łB");
        } catch (IllegalAccessException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalAccessException.class, e.getClass());
        }
    }

    /**
     * testParse09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFOX[<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:InvocationTargetException 邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgDate^setter\bhO X[ꍇAsetter\bhX[Obv InvocationTargetExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse09() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod(
                "setAException", new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("InvocationTargetExceptionX[܂B");
        } catch (InvocationTargetException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(InvocationTargetException.class, e.getClass());
        }
    }

    /**
     * testParse10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"2006-01-01"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException 邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgDate^setter\bḧꍇA IllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse10() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2006-01-01";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod(
                "setAAndB", new Class[] { Date.class, Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    /**
     * testParse11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"2008-01-32"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:ParseException邱ƂmFB<br>
     * <br>
     * Date^̑̒lz肳Ȃt̏ꍇA ParseException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse11() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "2008-01-32";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("ParseExceptionX[܂łB");
        } catch (ParseException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(ParseException.class, e.getClass());
            assertEquals("Unparseable date: \"2008-01-32\"", e.getMessage());
        }
    }

    /**
     * testParse12() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:null<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:NullPointerException 邱ƂmFB<br>
     * <br>
     * columnnullݒ肳ꂽꍇ́ANullPointerException 邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse12() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = null;
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("NullPointerExceptionX[܂łB");
        } catch (NullPointerException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(NullPointerException.class, e.getClass());
        }
    }

    /**
     * testParse13() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"20080101"<br>
     * () t@CsIuWFNg<br>
     * :Date^̃tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^ setter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F1<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy-MM-dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:ParseException邱ƂmFB<br>
     * <br>
     * columñtH[}bgƃtH[}bgp̕񂪈قȂꍇ́A ParseException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse13() throws Exception {
        // eXgΏۂ̃CX^X
        DateColumnParser dateColumnParser = new DateColumnParser();

        // ̐ݒ
        String column = "20080101";
        DateColumnParser_Stub01 t = new DateColumnParser_Stub01();
        Method method = DateColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Date.class });
        String columnFormat = "yyyy-MM-dd";

        // O̐ݒ
        // ftHgŗvfȂmap̂ŁAȂB

        try {
            // eXg{
            dateColumnParser.parse(column, t, method, columnFormat);
            fail("ParseExceptionX[܂łB");
        } catch (ParseException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(ParseException.class, e.getClass());
            assertEquals("Unparseable date: \"20080101\"", e.getMessage());
        }
    }

}
