/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao;

import java.util.List;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.FileLineException} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CANZX@\ŔObvRuntimeException
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.FileLineException
 */
public class FileLineExceptionTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FileLineExceptionTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public FileLineExceptionTest(String name) {
        super(name);
    }

    /**
     * testFileLineExceptionException01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() e:not null<br>
     * ExceptioñCX^X<br>
     * <br>
     * ҒlF(ԕω) columnName:null<br>
     * (ԕω) columnIndex:-1<br>
     * (ԕω) lineNo:-1<br>
     * (ԕω) FileLineException.cause: eƓ̃IuWFNgB<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^̈Ŏ󂯎Exceptionbv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionException01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        Exception exception = new Exception();

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(exception);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertNull(UTUtil.getPrivateField(fe, "columnName"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "columnIndex"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "lineNo"));
        assertSame(exception, fe.getCause());

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(1, arguments.size());
        assertSame(exception, arguments.get(0));
    }

    /**
     * testFileLineExceptionString01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() message:not null<br>
     * StringCX^X<br>
     * <br>
     * ҒlF(ԕω) columnName:null<br>
     * (ԕω) columnIndex:-1<br>
     * (ԕω) lineNo:-1<br>
     * (ԕω) FileLineException.detailMessage: messageƓ̃IuWFNgB<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^ɗObZ[Wݒ肷B<br>
     * OIuWFNgɃbZ[Wi[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionString01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String message = new String();

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(message);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertNull(UTUtil.getPrivateField(fe, "columnName"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "columnIndex"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "lineNo"));
        assertEquals(message, fe.getMessage());

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(1, arguments.size());
        assertSame(message, arguments.get(0));
    }

    /**
     * testFileLineExceptionStringException01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() message:not null<br>
     * StringCX^X<br>
     * () exceotion:not null<br>
     * ExceptioñCX^X<br>
     * <br>
     * ҒlF(ԕω) columnName:null<br>
     * (ԕω) columnIndex:-1<br>
     * (ԕω) lineNo:-1<br>
     * (ԕω) FileLineException.detailMessage: messageƓ̃IuWFNgB<br>
     * (ԕω) FileLineException.caouse: exceptionƓ̃IuWFNg<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^ɗObZ[Wݒ肷B<br>
     * OIuWFNgɃbZ[Wi[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionStringException01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String message = new String();
        Exception exception = new Exception();

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(message, exception);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertNull(UTUtil.getPrivateField(fe, "columnName"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "columnIndex"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "lineNo"));
        assertSame(message, fe.getMessage());
        assertSame(exception, fe.getCause());

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(2, arguments.size());
        assertSame(message, arguments.get(0));
        assertSame(exception, arguments.get(1));
    }

    /**
     * testFileLineExceptionExceptionStringint01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() exception:not null<br>
     * ExceptionCX^X<br>
     * () fileName:not null<br>
     * StringCX^X<br>
     * () lineNo:1<br>
     * <br>
     * ҒlF(ԕω) this.colmnName:null<br>
     * (ԕω) this.columnIndex:-1<br>
     * (ԕω) this.lineNo:1<br>
     * (ԕω) FileLineException.cause: exceptionƓ̃IuWFNg<br>
     * (ԕω) FileLineException.fileName: fileNameƓIuWFNg<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^Ƀt@Cݒ肷B<br>
     * OIuWFNgɃt@Ci[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionExceptionStringint01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        Exception exception = new Exception();
        String fileName = new String();
        int lineNo = 1;

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(exception, fileName,
                lineNo);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertNull(UTUtil.getPrivateField(fe, "columnName"));
        assertEquals(-1, UTUtil.getPrivateField(fe, "columnIndex"));
        assertEquals(1, UTUtil.getPrivateField(fe, "lineNo"));
        assertSame(exception, fe.getCause());
        assertSame(fileName, UTUtil.getPrivateField(fe, "fileName"));

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(2, arguments.size());
        assertSame(exception, arguments.get(0));
        assertSame(fileName, arguments.get(1));
    }

    /**
     * testFileLineExceptionStringExceptionStringint01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() message:StringCX^X<br>
     * () e:ExceptionCX^X<br>
     * () fileName:StringCX^X<br>
     * () lineNo:1<br>
     * <br>
     * ҒlF(ԕω) FileLineException.cause: eƓ̃IuWFNg<br>
     * (ԕω) FileLineException.fileName: fileNameƓ̃IuWFNg<br>
     * (ԕω) FileLineException.detailMessage: messageƓ̃IuWFNg<br>
     * (ԕω) lineNo:lineNoƓl<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^Ƀt@Cݒ肷B<br>
     * OIuWFNgɃt@Ci[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionStringExceptionStringint01()
                                                                 throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String message = new String();
        Exception exception = new Exception();
        String fileName = new String();
        int lineNo = 1;

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(message, exception,
                fileName, lineNo);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertSame(exception, fe.getCause());
        assertSame(fileName, UTUtil.getPrivateField(fe, "fileName"));
        assertSame(message, fe.getMessage());
        assertEquals(1, UTUtil.getPrivateField(fe, "lineNo"));

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(3, arguments.size());
        assertSame(message, arguments.get(0));
        assertSame(exception, arguments.get(1));
        assertSame(fileName, arguments.get(2));
    }

    /**
     * testFileLineExceptionExceptionStringintStringint01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() exception:not null<br>
     * ExceptionCX^X<br>
     * () fileName:not null<br>
     * StringCX^X<br>
     * () lineNo:1<br>
     * () columnName:not null<br>
     * StringCX^X<br>
     * () columnIndex:1<br>
     * <br>
     * ҒlF(ԕω) FileLineException.cause: exceptionƓ̃IuWFNg<br>
     * (ԕω) FileLineException.fileName: fileNameƓ̃IuWFNg<br>
     * (ԕω) FileLineException.lineNo: lineNoƓl<br>
     * (ԕω) FileLineException.columnName: columnNameƓ̃IuWFNg<br>
     * (ԕω) FileLineException.columnIndex: columnIndexƓl<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^Ƀt@Cݒ肷B<br>
     * OIuWFNgɃt@Ci[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionExceptionStringintStringint01()
                                                                    throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        Exception exception = new Exception();
        String fileName = new String();
        int lineNo = 1;
        String columnName = new String();
        int columnIndex = 1;

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(exception, fileName,
                lineNo, columnName, columnIndex);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertSame(exception, fe.getCause());
        assertEquals(fileName, UTUtil.getPrivateField(fe, "fileName"));
        assertEquals(lineNo, UTUtil.getPrivateField(fe, "lineNo"));
        assertEquals(columnName, UTUtil.getPrivateField(fe, "columnName"));
        assertEquals(columnIndex, UTUtil.getPrivateField(fe, "columnIndex"));

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(2, arguments.size());
        assertSame(exception, arguments.get(0));
        assertSame(fileName, arguments.get(1));
    }

    /**
     * testFileLineExceptionStringExceptionStringintStringint01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() message:not null<br>
     * StringCX^X<br>
     * () exception:not null<br>
     * ExceptionCX^X<br>
     * () fileName:not null<br>
     * StringCX^X<br>
     * () lineNo:1<br>
     * () columnName:not null<br>
     * StringCX^X<br>
     * () columnIndex:1<br>
     * <br>
     * ҒlF(ԕω) FileLineException.message: messageƓ̃IuWFNg<br>
     * (ԕω) FileLineException.cause: exceptionƓ̃IuWFNg<br>
     * (ԕω) FileLineException.fileName: fileNameƓ̃IuWFNg<br>
     * (ԕω) FileLineException.lineNo: lineNoƓl<br>
     * (ԕω) FileLineException.columnName: columnNameƓ̃IuWFNg<br>
     * (ԕω) FileLineException.columnIndex: columnIndexƓl<br>
     * (ԕω) FileException:1Ă΂B<br>
     * <br>
     * RXgN^Ƀt@Cݒ肷B<br>
     * OIuWFNgɃt@Ci[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFileLineExceptionStringExceptionStringintStringint01()
                                                                          throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String message = new String();
        Exception exception = new Exception();
        String fileName = new String();
        int lineNo = 1;
        String columnName = new String();
        int columnIndex = 1;

        // O̐ݒ
        // Ȃ

        // eXg{
        FileLineException fe = new FileLineException(message, exception,
                fileName, lineNo, columnName, columnIndex);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertSame(message, fe.getMessage());
        assertSame(exception, fe.getCause());
        assertEquals(fileName, UTUtil.getPrivateField(fe, "fileName"));
        assertEquals(lineNo, UTUtil.getPrivateField(fe, "lineNo"));
        assertEquals(columnName, UTUtil.getPrivateField(fe, "columnName"));
        assertEquals(columnIndex, UTUtil.getPrivateField(fe, "columnIndex"));

        assertTrue(VMOUTUtil.isCalled(FileException.class, "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(FileException.class, "<init>"));
        List arguments = VMOUTUtil.getArguments(FileException.class, "<init>",
                0);
        assertEquals(3, arguments.size());
        assertSame(message, arguments.get(0));
        assertSame(exception, arguments.get(1));
        assertSame(fileName, arguments.get(2));
    }

    /**
     * testGetColumnName01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() message:not null<br>
     * StringCX^X<br>
     * () exception:not null<br>
     * ExceptionCX^X<br>
     * () fileName:not null<br>
     * StringCX^X<br>
     * () lineNo:1<br>
     * () columnName:not null<br>
     * StringCX^X<br>
     * () columnIndex:0<br>
     * <br>
     * ҒlF(߂l) String:OcolumnNameƓ̃IuWFNg<br>
     * <br>
     * columnNamegetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testGetColumnName01() throws Exception {
        // eXgΏۂ̃CX^X
        String message = new String();
        Exception exception = new Exception();
        String fileName = new String();
        int lineNo = 1;
        String columnName = new String();
        int columnIndex = 1;
        FileLineException fe = new FileLineException(message, exception,
                fileName, lineNo, columnName, columnIndex);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        String result = fe.getColumnName();

        // ԋpl̊mF
        assertSame(columnName, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetLineNo01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() message:not null<br>
     * StringCX^X<br>
     * () exception:not null<br>
     * ExceptionCX^X<br>
     * () fileName:not null<br>
     * StringCX^X<br>
     * () lineNo:1<br>
     * () columnName:not null<br>
     * StringCX^X<br>
     * () columnIndex:0<br>
     * <br>
     * ҒlF(߂l) int:OlineNoƓl<br>
     * <br>
     * lineNogetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testGetLineNo01() throws Exception {
        // eXgΏۂ̃CX^X
        String message = new String();
        Exception exception = new Exception();
        String fileName = new String();
        int lineNo = 1;
        String columnName = new String();
        int columnIndex = 1;
        FileLineException fe = new FileLineException(message, exception,
                fileName, lineNo, columnName, columnIndex);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        int result = fe.getLineNo();

        // ԋpl̊mF
        assertEquals(lineNo, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetColumnIndex01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() message:not null<br>
     * StringCX^X<br>
     * () exception:not null<br>
     * ExceptionCX^X<br>
     * () fileName:not null<br>
     * StringCX^X<br>
     * () lineNo:-1<br>
     * () columnName:not null<br>
     * StringCX^X<br>
     * () columnIndex:1<br>
     * <br>
     * ҒlF(߂l) int:OcolumnIndexƓl<br>
     * <br>
     * ̒ll擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testGetColumnIndex01() throws Exception {
        // eXgΏۂ̃CX^X
        FileLineException fe = new FileLineException(new String());

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        int columnIndex = 1;
        UTUtil.setPrivateField(fe, "columnIndex", columnIndex);

        // eXg{
        int result = fe.getColumnIndex();

        // ԋpl̊mF
        assertEquals(columnIndex, result);

        // ԕω̊mF
        // Ȃ
    }

}
