/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.date;

import java.util.Calendar;
import java.util.Date;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.date.AbstractDateCondition;

public class IsAfterDateCondition
extends AbstractDateCondition {
    private Calendar earlier;

    public IsAfterDateCondition(Date earlier) {
        Assert.notNull((Object)earlier, (String)"IsAfterDateCondition cannot be initialized with a null date");
        this.earlier = Calendar.getInstance();
        this.earlier.setTime(earlier);
    }

    public IsAfterDateCondition(Calendar earlier) {
        Assert.notNull((Object)earlier, (String)"IsAfterDateCondition cannot be initialized with a null calendar");
        this.earlier = earlier;
    }

    protected boolean checkCalendar(Calendar calendar) {
        return this.earlier.getTimeInMillis() < calendar.getTimeInMillis();
    }

    public Calendar getEarlier() {
        return this.earlier;
    }
}

