/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.blogic;

import java.util.Map;
import jp.terasoluna.fw.batch.blogic.AbstractBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.logger.TLogger;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionBLogic
extends AbstractBLogic {
    private static final int PROCESS_END_STATUS_FAILURE = 255;
    private static final TLogger LOGGER = TLogger.getLogger(AbstractTransactionBLogic.class);
    private Map<?, ?> transactionManagerMap = null;
    private Map<String, TransactionStatus> transactionStatusMap = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(BLogicParam param) {
        int status = 255;
        ApplicationContext ctx = this.getApplicationContext();
        this.transactionManagerMap = ctx.getBeansOfType(PlatformTransactionManager.class);
        this.transactionStatusMap = this.startTransactions(this.transactionManagerMap);
        try {
            try {
                status = this.doMain(param);
                this.commitTransactions(this.transactionManagerMap, this.transactionStatusMap);
            }
            catch (Throwable e) {
                if (!(e instanceof RuntimeException)) throw new BatchException(e);
                throw (RuntimeException)e;
            }
            Object var6_4 = null;
            boolean et = this.endTransactions(this.transactionManagerMap, this.transactionStatusMap);
            if (et) return status;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            boolean et = this.endTransactions(this.transactionManagerMap, this.transactionStatusMap);
            if (et) throw throwable;
            LOGGER.error("EAL025001");
            throw throwable;
        }
        LOGGER.error("EAL025001");
        return status;
    }

    public abstract int doMain(BLogicParam var1);

    private Map<String, TransactionStatus> startTransactions(Map<?, ?> trnMngMap) {
        return BatchUtil.startTransactions(BatchUtil.getTransactionDefinition(), trnMngMap, (Log)LOGGER);
    }

    private void commitTransactions(Map<?, ?> trnMngMap, Map<String, TransactionStatus> tranStatMap) {
        BatchUtil.commitTransactions(trnMngMap, tranStatMap, (Log)LOGGER);
    }

    private boolean endTransactions(Map<?, ?> trnMngMap, Map<String, TransactionStatus> tranStatMap) {
        return BatchUtil.endTransactions(trnMngMap, tranStatMap, (Log)LOGGER);
    }
}

