/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.taglib;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import junit.framework.TestCase;

/**
 * (O)
 * E^OkeyPropertýAtldt@CŕK{ݒƂĂ邽߁AKݒ肳
 */
public class ExtractTagTest extends TestCase {
    
    private List<ExtractTag_JavaBeanStub01> dynamicCodeList;
    
    public ExtractTagTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        dynamicCodeList = new ArrayList<ExtractTag_JavaBeanStub01>();
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key2");
        bean.setWriteValue("writeValue2");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key3");
        bean.setWriteValue("writeValue3");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key4");
        bean.setWriteValue("writeValue4");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key5");
        bean.setWriteValue("writeValue5 < > & \" '");
        dynamicCodeList.add(bean);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wid̂ݎgp
     * EõIuWFNǵAlCollection(0)gp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeanListō\zAy[WXR[vɊi[邱ƂmFB
     * EoʂList0ł邱ƂmFB
     * E߂lSKIP_BODYł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag01() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        List<String> condition = new ArrayList<String>();
        tag.setCondition(condition);
        tag.setId("resultList");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE);
        assertNull(pageContext.getAttribute("resultList", PageContext.REQUEST_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.SESSION_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.APPLICATION_SCOPE));
        assertNotNull(resultList);
        assertEquals(0, resultList.size());
    }

    /**
     * testDoStartTag02B
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎widtoScopegp
     * EtoScopeɂ"page"w
     * EõIuWFNǵAlCollection(1)gp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeanListō\zAy[WXR[vɊi[邱ƂmFB
     * EoʂListAoƃL[v1ł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag02() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        List<String> condition = new ArrayList<String>();
        condition.add("key3");
        tag.setCondition(condition);
        tag.setId("resultList");
        tag.setToScope("page");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE);
        assertNull(pageContext.getAttribute("resultList", PageContext.REQUEST_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.SESSION_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.APPLICATION_SCOPE));
        assertNotNull(resultList);
        assertEquals(1, resultList.size());
        assertEquals("writeValue3", resultList.get(0).getWriteValue());
    }

    /**
     * testDoStartTag03B
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎widtoScopegp
     * EtoScopeɂ"request"w
     * EõIuWFNǵAlCollection(3)gp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeanListō\zANGXgXR[vɊi[邱ƂmFB
     * EoʂListAoƃL[v3ł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag03() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        List<String> condition = new ArrayList<String>();
        condition.add("key1");
        condition.add("key3");
        condition.add("key5");
        tag.setCondition(condition);
        tag.setId("resultList");
        tag.setToScope("request");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        assertNull(pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE));
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.REQUEST_SCOPE);
        assertNull(pageContext.getAttribute("resultList", PageContext.SESSION_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.APPLICATION_SCOPE));
        assertNotNull(resultList);
        assertEquals(3, resultList.size());
        assertEquals("writeValue1", resultList.get(0).getWriteValue());
        assertEquals("writeValue3", resultList.get(1).getWriteValue());
        assertEquals("writeValue5 < > & \" '", resultList.get(2).getWriteValue());
    }

    /**
     * testDoStartTag04B
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎widtoScopegp
     * EtoScopeɂ"session"w
     * EõIuWFNǵACollectionłȂlgp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂZbVXR[vɊi[邱ƂmFB
     * EoʂAoƃL[vJavaBeanł邱ƂmFB
     */
    public void testDoStartTag04() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        String condition = "key2";
        tag.setCondition(condition);
        tag.setId("resultBean");
        tag.setToScope("session");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        assertNull(pageContext.getAttribute("resultBean", PageContext.PAGE_SCOPE));
        assertNull(pageContext.getAttribute("resultBean", PageContext.REQUEST_SCOPE));
        ExtractTag_JavaBeanStub01 resultBean = (ExtractTag_JavaBeanStub01) pageContext.getAttribute("resultBean", PageContext.SESSION_SCOPE);
        assertNull(pageContext.getAttribute("resultBean", PageContext.APPLICATION_SCOPE));
        assertNotNull(resultBean);
        assertEquals("writeValue2", resultBean.getWriteValue());
    }

    /**
     * testDoStartTag05B
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎widtoScopegp
     * EtoScopeɂ"application"w
     * EIR[hXg0
     * EõIuWFNǵAlCollection(0)gp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeanListō\zAAvP[VXR[vɊi[邱ƂmFB
     * EoʂList0ł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag05() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(new ArrayList());
        tag.setKeyProperty("key");
        List<String> condition = new ArrayList<String>();
        tag.setCondition(condition);
        tag.setId("resultList");
        tag.setToScope("application");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        assertNull(pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.REQUEST_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.SESSION_SCOPE));
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.APPLICATION_SCOPE);
        assertNotNull(resultList);
        assertEquals(0, resultList.size());
    }

    /**
     * testDoStartTag06B
     * EIR[hXg̎wcollectionNamê݂gp
     * Eo̎wconditionNameconditionScopegp
     * EconditionScopeɂ"page"w
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     */
    public void testDoStartTag06() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        pageContext.setAttribute("dynamicCodeList1", dynamicCodeList, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeList1");
        tag.setKeyProperty("key");
        String condition = "key1";
        pageContext.setAttribute("condition1", condition, PageContext.PAGE_SCOPE);
        tag.setConditionName("condition1");
        tag.setConditionScope("page");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue1", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag07B
     * EIR[hXg̎wcollectionNamecollectionScopegp
     * EcollectionScopeɂ"page"w
     * Eo̎wconditionNameconditionScopegp
     * EconditionScopeɂ"request"w
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     */
    public void testDoStartTag07() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        pageContext.setAttribute("dynamicCodeList1", dynamicCodeList, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeList1");
        tag.setCollectionScope("page");
        tag.setKeyProperty("key");
        String condition = "key2";
        pageContext.setAttribute("condition1", condition, PageContext.REQUEST_SCOPE);
        tag.setConditionName("condition1");
        tag.setConditionScope("request");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue2", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag08B
     * EIR[hXg̎wcollectionNamecollectionScopegp
     * EcollectionScopeɂ"request"w
     * Eo̎wconditionNameconditionScopegp
     * EconditionScopeɂ"session"w
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     */
    public void testDoStartTag08() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        pageContext.setAttribute("dynamicCodeList1", dynamicCodeList, PageContext.REQUEST_SCOPE);
        tag.setCollectionName("dynamicCodeList1");
        tag.setCollectionScope("request");
        tag.setKeyProperty("key");
        String condition = "key3";
        pageContext.setAttribute("condition1", condition, PageContext.SESSION_SCOPE);
        tag.setConditionName("condition1");
        tag.setConditionScope("session");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue3", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag09B
     * EIR[hXg̎wcollectionNamecollectionScopegp
     * EcollectionScopeɂ"session"w
     * Eo̎wconditionNameconditionScopegp
     * EconditionScopeɂ"application"w
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     */
    public void testDoStartTag09() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        pageContext.setAttribute("dynamicCodeList1", dynamicCodeList, PageContext.SESSION_SCOPE);
        tag.setCollectionName("dynamicCodeList1");
        tag.setCollectionScope("session");
        tag.setKeyProperty("key");
        String condition = "key4";
        pageContext.setAttribute("condition1", condition, PageContext.APPLICATION_SCOPE);
        tag.setConditionName("condition1");
        tag.setConditionScope("application");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue4", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag10B
     * EIR[hXg̎wcollectionNamecollectionScopegp
     * EcollectionScopeɂ"application"w
     * Eo̎wconditionNamê݂gp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * Efilter͎w肵Ȃ
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     * Eo͓eTj^CY邱ƂmFB
     */
    public void testDoStartTag10() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        pageContext.setAttribute("dynamicCodeList1", dynamicCodeList, PageContext.APPLICATION_SCOPE);
        tag.setCollectionName("dynamicCodeList1");
        tag.setCollectionScope("application");
        tag.setKeyProperty("key");
        String condition = "key5";
        pageContext.setAttribute("condition1", condition, PageContext.PAGE_SCOPE);
        tag.setConditionName("condition1");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue5 &lt; &gt; &amp; &quot; &#39;", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag11B
     * EIR[hXg̎wcollectionNamecollectionScopegp
     * EcollectionScopeɂ"application"w
     * Eo̎wconditionNamê݂gp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * Efilter"false"w
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     * Eo͓eTj^CYȂƂmFB
     */
    public void testDoStartTag11() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        pageContext.setAttribute("dynamicCodeList1", dynamicCodeList, PageContext.APPLICATION_SCOPE);
        tag.setCollectionName("dynamicCodeList1");
        tag.setCollectionScope("application");
        tag.setKeyProperty("key");
        String condition = "key5";
        pageContext.setAttribute("condition1", condition, PageContext.PAGE_SCOPE);
        tag.setConditionName("condition1");
        tag.setWriteProperty("writeValue");
        tag.setFilter(false);
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue5 < > & \" '", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag12B
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵACollectionłȂlgp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeańAwritePropertyŎw肳ꂽvpeB̒l\邱ƂmFB
     */
    public void testDoStartTag12() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        ExtractTag_JavaBeanStub02 dynamicCodeListWrapBean = new ExtractTag_JavaBeanStub02();
        dynamicCodeListWrapBean.setCollection(dynamicCodeList);
        pageContext.setAttribute("dynamicCodeListWrapBean", dynamicCodeListWrapBean, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collection");
        tag.setKeyProperty("key");
        String condition = "key3";
        ExtractTag_JavaBeanStub02 conditionWrapBean = new ExtractTag_JavaBeanStub02();
        conditionWrapBean.setCondition(condition);
        pageContext.setAttribute("conditionWrapBean", conditionWrapBean, PageContext.PAGE_SCOPE);
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("condition");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("writeValue3", TagUTUtil.getOutputString(tag));
    }

    /**
     * testDoStartTag13B
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wid̂ݎgp
     * EõIuWFNǵAl̔z(3)gp
     * L̏ŎsƂA
     * E߂lSKIP_BODYł邱ƂmFB
     * EoʂJavaBeanListō\zAy[WXR[vɊi[邱ƂmFB
     * EoʂListAoƃL[v3ł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag13() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        String[] condition = new String[] { "key1", "key3", "key5" };
        tag.setCondition(condition);
        tag.setId("resultList");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE);
        assertNull(pageContext.getAttribute("resultList", PageContext.REQUEST_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.SESSION_SCOPE));
        assertNull(pageContext.getAttribute("resultList", PageContext.APPLICATION_SCOPE));
        assertNotNull(resultList);
        assertEquals(3, resultList.size());
        assertEquals("writeValue1", resultList.get(0).getWriteValue());
        assertEquals("writeValue3", resultList.get(1).getWriteValue());
        assertEquals("writeValue5 < > & \" '", resultList.get(2).getWriteValue());
    }

    /**
     * testDoStartTag14B
     * (ُn)
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EcollectionPropertyŎw肵vpeBɁAIR[hXg̃IuWFNg݂Ȃ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     */
    public void testDoStartTag14() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        ExtractTag_JavaBeanStub02 dynamicCodeListWrapBean = new ExtractTag_JavaBeanStub02();
        pageContext.setAttribute("dynamicCodeListWrapBean", dynamicCodeListWrapBean, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collection");
        tag.setKeyProperty("key");
        String condition = "key3";
        ExtractTag_JavaBeanStub02 conditionWrapBean = new ExtractTag_JavaBeanStub02();
        conditionWrapBean.setCondition(condition);
        pageContext.setAttribute("conditionWrapBean", conditionWrapBean, PageContext.PAGE_SCOPE);
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("condition");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals("Failed to find collection. collection object is not set. collectionName: dynamicCodeListWrapBean"
                            + ", collectionProperty: collection"
                            + ", collectionScope: null", e.getMessage());
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag15B
     * (ُn)
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EcollectionPropertyŎw肵vpeB݂Ȃ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB(StrutsTagUtils#lookup̓)
     */
    public void testDoStartTag15() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        ExtractTag_JavaBeanStub02 dynamicCodeListWrapBean = new ExtractTag_JavaBeanStub02();
        pageContext.setAttribute("dynamicCodeListWrapBean", dynamicCodeListWrapBean, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collectionXXX");
        tag.setKeyProperty("key");
        String condition = "key3";
        ExtractTag_JavaBeanStub02 conditionWrapBean = new ExtractTag_JavaBeanStub02();
        conditionWrapBean.setCondition(condition);
        pageContext.setAttribute("conditionWrapBean", conditionWrapBean, PageContext.PAGE_SCOPE);
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("condition");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            // Ғʂ
        }
    }

    /**
     * testDoStartTag16B
     * (ُn)
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EconditionNameŎw肵Bean݂Ȃ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB(StrutsTagUtils#lookup̓)
     */
    public void testDoStartTag16() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collection");
        tag.setKeyProperty("key");
        String condition = "key3";
        ExtractTag_JavaBeanStub02 conditionWrapBean = new ExtractTag_JavaBeanStub02();
        conditionWrapBean.setCondition(condition);
        pageContext.setAttribute("conditionWrapBean", conditionWrapBean, PageContext.PAGE_SCOPE);
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("condition");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            // Ғʂ
        }
    }

    /**
     * testDoStartTag17B
     * (ُn)
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EconditionPropertyŎw肵vpeBɁAõIuWFNg݂Ȃ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     */
    public void testDoStartTag17() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        ExtractTag_JavaBeanStub02 dynamicCodeListWrapBean = new ExtractTag_JavaBeanStub02();
        dynamicCodeListWrapBean.setCollection(dynamicCodeList);
        pageContext.setAttribute("dynamicCodeListWrapBean", dynamicCodeListWrapBean, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collection");
        tag.setKeyProperty("key");
        ExtractTag_JavaBeanStub02 conditionWrapBean = new ExtractTag_JavaBeanStub02();
        pageContext.setAttribute("conditionWrapBean", conditionWrapBean, PageContext.PAGE_SCOPE);
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("condition");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals("Failed to find condition. condition object is not set. conditionName: conditionWrapBean"
                            + ", conditionProperty: condition"
                            + ", conditionScope: null", e.getMessage());
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag18B
     * (ُn)
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EconditionPropertyŎw肵vpeB݂Ȃ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB(StrutsTagUtils#lookup̓)
     */
    public void testDoStartTag18() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        ExtractTag_JavaBeanStub02 dynamicCodeListWrapBean = new ExtractTag_JavaBeanStub02();
        dynamicCodeListWrapBean.setCollection(dynamicCodeList);
        pageContext.setAttribute("dynamicCodeListWrapBean", dynamicCodeListWrapBean, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collection");
        tag.setKeyProperty("key");
        ExtractTag_JavaBeanStub02 conditionWrapBean = new ExtractTag_JavaBeanStub02();
        pageContext.setAttribute("conditionWrapBean", conditionWrapBean, PageContext.PAGE_SCOPE);
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("conditionXXX");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            // Ғʂ
        }
    }

    /**
     * testDoStartTag19B
     * (ُn)
     * EIR[hXg̎wcollectionNamecollectionPropertygp
     * Eo̎wconditionNameconditionPropertygp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EconditionNameŎw肵Bean݂Ȃ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB(StrutsTagUtils#lookup̓)
     */
    public void testDoStartTag19() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        ExtractTag_JavaBeanStub02 dynamicCodeListWrapBean = new ExtractTag_JavaBeanStub02();
        dynamicCodeListWrapBean.setCollection(dynamicCodeList);
        pageContext.setAttribute("dynamicCodeListWrapBean", dynamicCodeListWrapBean, PageContext.PAGE_SCOPE);
        tag.setCollectionName("dynamicCodeListWrapBean");
        tag.setCollectionProperty("collection");
        tag.setKeyProperty("key");
        tag.setConditionName("conditionWrapBean");
        tag.setConditionProperty("condition");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            // Ғʂ
        }
    }

    /**
     * testDoStartTag20B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎widwriteProperty𕹗p({Ap֎~)
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     */
    public void testDoStartTag20() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition("key3");
        tag.setId("resultBean");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals("Illegal usage. It is necessary to specify either of id or writeProperty.", e.getMessage());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag21B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւw肵Ȃ({AidwritePropertŷǂ炩ݒ肵Ȃ΂ȂȂ)
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     */
    public void testDoStartTag21() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition("key3");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals("Illegal usage. It is necessary to specify either of id or writeProperty.", e.getMessage());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag22B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EõIuWFNǵAl̔z(1)gp({AozCollectionɂĂꍇAwritePropertył͂ȂidgpȂ΂ȂȂ)
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     */
    public void testDoStartTag22() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition(new String[] { "key3" });
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals("Illegal usage. condition is Collection class or Array. In this case, id should not be null.", e.getMessage());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag23B
     * L[vpeB̒lnull̂ƂA󕶎񈵂ƂȂ邱Ƃ̊mFB
     * EIR[hXgJavaBeañL[vpeB̒lnull̂ƂA
     *   onullZbgĂAoȂƂmFB
     * E߂lSKIP_BODYł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag23() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey(null);
        bean.setWriteValue("writeValueNull");
        dynamicCodeList.add(bean);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition(new String[] { null });
        tag.setId("resultList");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE);
        assertNotNull(resultList);
        assertEquals(0, resultList.size());
    }

    /**
     * testDoStartTag24B
     * L[vpeB̒lnull̂ƂA󕶎񈵂ƂȂ邱Ƃ̊mFB
     * EIR[hXgJavaBeañL[vpeB̒lnull̂ƂA
     *   oɋ󕶎Zbg΁Ao邱ƂmFB
     * E߂lSKIP_BODYł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testDoStartTag24() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey(null);
        bean.setWriteValue("writeValueNull");
        dynamicCodeList.add(bean);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition(new String[] { "" });
        tag.setId("resultList");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        PageContext pageContext = TagUTUtil.getPageContext(tag);
        List<ExtractTag_JavaBeanStub01> resultList = (List<ExtractTag_JavaBeanStub01>) pageContext.getAttribute("resultList", PageContext.PAGE_SCOPE);
        assertNotNull(resultList);
        assertEquals(1, resultList.size());
        assertEquals("writeValueNull", resultList.get(0).getWriteValue());
    }

    /**
     * testDoStartTag25B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EkeyPropertyŎw肵vpeBgetterȂ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     * EJspExceptionɂNoSuchMethodExceptioni[Ă邱ƂmFB
     */
    public void testDoStartTag25() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("keyXXX");
        tag.setCondition("key1");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals(NoSuchMethodException.class, e.getRootCause().getClass());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag26B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EkeyPropertyŎw肵vpeBgetterOX[
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     * EJspExceptionɂ́AgetterX[Oi[Ă邱ƂmFB
     *   (InvocationTargetExceptionAoAgetterX[Oi[)
     */
    public void testDoStartTag26() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        List<ExtractTag_JavaBeanStub03> dynamicCodeList = new ArrayList<ExtractTag_JavaBeanStub03>();
        ExtractTag_JavaBeanStub03 bean = new ExtractTag_JavaBeanStub03();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub03();
        bean.setKey("key2");
        bean.setWriteValue("writeValue2");
        dynamicCodeList.add(bean);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition("key1");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals(RuntimeException.class, e.getRootCause().getClass());
            assertEquals("test", e.getRootCause().getMessage());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag27B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EwritePropertyŎw肵vpeBgetterȂ
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     * EJspExceptionɂNoSuchMethodExceptioni[Ă邱ƂmFB
     */
    public void testDoStartTag27() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition("key1");
        tag.setWriteProperty("writeValueXXX");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals(NoSuchMethodException.class, e.getRootCause().getClass());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag28B
     * (ُn)
     * EIR[hXg̎wcollectiongp
     * Eo̎wconditiongp
     * E`͕\Ɋւ̎wwritePropertŷ݂gp
     * EwritePropertyŎw肵vpeBgetterOX[
     * L̏ŎsƂA
     * EJspExceptionX[邱ƂmFB
     * EX[ꂽOƓ̂NGXgorg.apache.struts.action.EXCEPTIONɊi[邱ƂmFB
     * EJspExceptionɂ́AgetterX[Oi[Ă邱ƂmFB
     *   (InvocationTargetExceptionAoAgetterX[Oi[)
     */
    public void testDoStartTag28() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        List<ExtractTag_JavaBeanStub04> dynamicCodeList = new ArrayList<ExtractTag_JavaBeanStub04>();
        ExtractTag_JavaBeanStub04 bean = new ExtractTag_JavaBeanStub04();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub04();
        bean.setKey("key2");
        bean.setWriteValue("writeValue2");
        dynamicCodeList.add(bean);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition("key1");
        tag.setWriteProperty("writeValue");
        
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            assertEquals(RuntimeException.class, e.getRootCause().getClass());
            assertEquals("test", e.getRootCause().getMessage());
            PageContext pageContext = TagUTUtil.getPageContext(tag);
            assertSame(e, pageContext.getAttribute("org.apache.struts.action.EXCEPTION", PageContext.REQUEST_SCOPE));
        }
    }

    /**
     * testDoStartTag29B
     * o̓vpeB̒lnull̏ꍇAwritePropertypĕ\ƂA
     * \(󕶎\Ɠ`)ƂȂ邱Ƃ̊mFB
     * EIR[hXgJavaBean̏o̓vpeB̒lnull̂ƂA
     *   \(󕶎\Ɠ`)ƂȂ邱ƂmFB
     * E߂lSKIP_BODYł邱ƂmFB
     */
    public void testDoStartTag29() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("keyNull");
        bean.setWriteValue(null);
        dynamicCodeList.add(bean);
        tag.setCollection(dynamicCodeList);
        tag.setKeyProperty("key");
        tag.setCondition("keyNull");
        tag.setWriteProperty("writeValue");
        
        int ret = tag.doStartTag();
        
        assertEquals(Tag.SKIP_BODY, ret);
        assertEquals("", TagUTUtil.getOutputString(tag));
    }

    /**
     * testGetIterator01B
     * ̓IR[hXgẑƂAzvfCe[g邽߂Iterator擾ł邱ƂmFB
     */
    public void testGetIterator01() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        ExtractTag_JavaBeanStub01[] dynamicCodeList = new ExtractTag_JavaBeanStub01[3];
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeList[0] = bean;
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key2");
        bean.setWriteValue("writeValue2");
        dynamicCodeList[1] = bean;
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key3");
        bean.setWriteValue("writeValue3");
        dynamicCodeList[2] = bean;
        
        Iterator<?> it = tag.getIterator(dynamicCodeList);
        
        assertTrue(it.hasNext());
        ExtractTag_JavaBeanStub01 elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key1", elem.getKey());
        assertEquals("writeValue1", elem.getWriteValue());
        assertTrue(it.hasNext());
        elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key2", elem.getKey());
        assertEquals("writeValue2", elem.getWriteValue());
        assertTrue(it.hasNext());
        elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key3", elem.getKey());
        assertEquals("writeValue3", elem.getWriteValue());
        assertFalse(it.hasNext());
    }

    /**
     * testGetIterator02B
     * ̓IR[hXgCollection(List)̂ƂACollection̗vfCe[g邽߂Iterator擾ł邱ƂmFB
     */
    public void testGetIterator02() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        List<ExtractTag_JavaBeanStub01> dynamicCodeList = new ArrayList<ExtractTag_JavaBeanStub01>();
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key2");
        bean.setWriteValue("writeValue2");
        dynamicCodeList.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key3");
        bean.setWriteValue("writeValue3");
        dynamicCodeList.add(bean);
        
        Iterator<?> it = tag.getIterator(dynamicCodeList);
        
        assertTrue(it.hasNext());
        ExtractTag_JavaBeanStub01 elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key1", elem.getKey());
        assertEquals("writeValue1", elem.getWriteValue());
        assertTrue(it.hasNext());
        elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key2", elem.getKey());
        assertEquals("writeValue2", elem.getWriteValue());
        assertTrue(it.hasNext());
        elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key3", elem.getKey());
        assertEquals("writeValue3", elem.getWriteValue());
        assertFalse(it.hasNext());
    }

    /**
     * testGetIterator03B
     * ̓IR[hXgIterator̂ƂAɗ^Iterator擾ł邱ƂmFB
     */
    public void testGetIterator03() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        List<ExtractTag_JavaBeanStub01> dynamicCodeListBase = new ArrayList<ExtractTag_JavaBeanStub01>();
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeListBase.add(bean);
        Iterator<ExtractTag_JavaBeanStub01> dynamicCodeList = dynamicCodeListBase.iterator();
        
        Iterator<?> it = tag.getIterator(dynamicCodeList);
        
        assertSame(dynamicCodeList, it);
    }

    /**
     * testGetIterator04B
     * ̓IR[hXgMap̂ƂAMap̑SMap.EntryvfƂIterator擾ł邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testGetIterator04() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        Map<String, String> dynamicCodeList = new LinkedHashMap<String, String>();
        dynamicCodeList.put("key1", "writeValue1");
        dynamicCodeList.put("key2", "writeValue2");
        dynamicCodeList.put("key3", "writeValue3");
        
        Iterator<?> it = tag.getIterator(dynamicCodeList);
        
        assertTrue(it.hasNext());
        Map.Entry<String, String> elem = (Map.Entry<String, String>) it.next();
        assertEquals("key1", elem.getKey());
        assertEquals("writeValue1", elem.getValue());
        assertTrue(it.hasNext());
        elem = (Map.Entry<String, String>) it.next();
        assertEquals("key2", elem.getKey());
        assertEquals("writeValue2", elem.getValue());
        assertTrue(it.hasNext());
        elem = (Map.Entry<String, String>) it.next();
        assertEquals("key3", elem.getKey());
        assertEquals("writeValue3", elem.getValue());
        assertFalse(it.hasNext());
    }

    /**
     * testGetIterator05B
     * ̓IR[hXgEnumeration̂ƂAEnumeration̗vfCe[g邽߂Iterator擾ł邱ƂmFB
     */
    public void testGetIterator05() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        Vector<ExtractTag_JavaBeanStub01> dynamicCodeListBase = new Vector<ExtractTag_JavaBeanStub01>();
        ExtractTag_JavaBeanStub01 bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key1");
        bean.setWriteValue("writeValue1");
        dynamicCodeListBase.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key2");
        bean.setWriteValue("writeValue2");
        dynamicCodeListBase.add(bean);
        bean = new ExtractTag_JavaBeanStub01();
        bean.setKey("key3");
        bean.setWriteValue("writeValue3");
        dynamicCodeListBase.add(bean);
        Enumeration<ExtractTag_JavaBeanStub01> dynamicCodeList = dynamicCodeListBase.elements();
        
        Iterator<?> it = tag.getIterator(dynamicCodeList);
        
        assertTrue(it.hasNext());
        ExtractTag_JavaBeanStub01 elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key1", elem.getKey());
        assertEquals("writeValue1", elem.getWriteValue());
        assertTrue(it.hasNext());
        elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key2", elem.getKey());
        assertEquals("writeValue2", elem.getWriteValue());
        assertTrue(it.hasNext());
        elem = (ExtractTag_JavaBeanStub01) it.next();
        assertEquals("key3", elem.getKey());
        assertEquals("writeValue3", elem.getWriteValue());
        assertFalse(it.hasNext());
    }

    /**
     * testGetIterator06B
     * ̓IR[hXgAzACollectionAIteratorAMapAEnumeration̂łȂƂAJspExceptionX[邱ƂmFB
     */
    public void testGetIterator06() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        Object dynamicCodeList = new Object();
        String expectedMessage = "Failed to getIterator: " + dynamicCodeList.toString();
        
        try {
            tag.getIterator(dynamicCodeList);
            fail();
        } catch (JspException e) {
            assertEquals(expectedMessage, e.getMessage());
        }
    }

    /**
     * testRelease01B
     * SẴvpeB()邱ƂmFB
     */
    public void testRelease01() throws Exception {
        ExtractTag tag = (ExtractTag) TagUTUtil.create(ExtractTag.class);
        tag.setCollection(new ArrayList<ExtractTag_JavaBeanStub01>());
        tag.setCollectionName("collectionName");
        tag.setCollectionProperty("collectionProperty");
        tag.setCollectionScope("session");
        tag.setKeyProperty("keyProperty");
        tag.setCondition("aaa");
        tag.setConditionName("conditionName");
        tag.setConditionProperty("conditionProperty");
        tag.setConditionScope("session");
        tag.setId("id");
        tag.setToScope("page");
        tag.setWriteProperty("writeProperty");
        tag.setFilter(false);
            
        tag.release();
        
        assertNull(tag.getCollection());
        assertNull(tag.getCollectionName());
        assertNull(tag.getCollectionProperty());
        assertNull(tag.getCollectionScope());
        assertNull(tag.getKeyProperty());
        assertNull(tag.getCondition());
        assertNull(tag.getConditionName());
        assertNull(tag.getConditionProperty());
        assertNull(tag.getConditionScope());
        assertNull(tag.getId());
        assertNull(tag.getToScope());
        assertNull(tag.getWriteProperty());
        assertTrue(tag.isFilter());
    }

}
