/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.spring.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.IllegalClassTypeException;
import jp.terasoluna.fw.dao.QueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * QueryDAÕbNAbvNXB
 * 
 * P̎QueryDAO̎NXƂĐݒ肷B
 * QueryDAÕ\bh̕ԋpliҒlj
 * \bhs鏇ԂqueryDAOResultsɓo^A
 * eXgΏۃNXQueryDAOtB[hɐݒ肷B
 * eXgsɁAQueryDAÕ\bhĂ΂x
 * queryDAOResultsɓo^ĂIuWFNgɕԋpB
 *
 */
public class MockQueryDAO implements QueryDAO {
    
    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(MockQueryDAO.class);
    
    /**
     * \bhs񃊃XgB
     * NX̃\bhsxɁAɊi[B
     */
    private List<DAOParams> queryDAOParams = new ArrayList<DAOParams>();
    
    /**
     * \bhs񃊃Xg擾B
     *
     * @return \bhs񃊃Xg
     */
    public List<DAOParams> getQueryDAOParams() {
        return queryDAOParams;
    }

    /**
     * \bhԋplXgB
     * NX̃\bhsxɁAԋpli[B
     */
    private List<Object> queryDAOResults = new ArrayList<Object>();

    /**
     * \bhԋplXgɒǉB
     *
     * @param queryDAOResult \bhԋpl
     */
    public void addQueryDAOResults(Object queryDAOResult) {
        queryDAOResults.add(queryDAOResult);
    }
    
    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽIuWFNgԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param clazz ԋpl̃NX
     * @return SQL̎s
     */
    public <E> E executeForObject(String sqlID, Object bindParams, Class clazz) {
        if (log.isDebugEnabled()) {
            log.debug("executeForObject Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setClazz(clazz);
        
        // \bhi[
        params.setMethodName("executeForObject");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        E rObj = proessForObject(clazz);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObject End.");
        }
        return rObj;
    }
    
    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽIuWFNg(Map)ԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    public Map<String, Object> executeForMap(String sqlID, Object bindParams) {
        if (log.isDebugEnabled()) {
            log.debug("executeForMap Start.");
        }
        
        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        
        // \bhi[
        params.setMethodName("executeForMap");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        Map<String, Object> rObj = proessForObject(Map.class);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForMap End.");
        }
        return rObj;
    }

    /**
     * queryDAOResults̈ԖڂɊi[ꂽIuWFNg
     * clazž^ɃLXgĕԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param clazz ԋpl̃NX
     * @return LXgς݂̕ԋpl
     */
    @SuppressWarnings("unchecked")
    protected <E> E proessForObject(Class clazz) {
        
        // ԋpl̎擾
        Object obj = queryDAOResults.get(0);
        if (log.isDebugEnabled() && obj != null) {
            log.debug("Return type:" + obj.getClass().getName());
        }

//        E rObj = null;
//        try {
//            if (clazz != null && obj != null) {
//                rObj = (E) clazz.cast(obj);
//            }
//        } catch (ClassCastException e) {
//            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
//            throw new IllegalClassTypeException(e);
//        }

        // ԋpς݂ƂȂԋplXg폜
        queryDAOResults.remove(0);
        
        //OIuWFNg̏ꍇ̓X[B
        if (obj instanceof RuntimeException) {
        	throw (RuntimeException)obj;
        } 
        return (E) obj;
        
    }
    
    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgzɕϊĕԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param clazz ԋpl̃NX
     * @return SQL̎s
     */
    public <E> E[] executeForObjectArray(String sqlID, Object bindParams, Class clazz) {
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setClazz(clazz);
        
        // \bhi[
        params.setMethodName("executeForObjectArray");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        E[] retArray = proessForObjectArray(clazz);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray End.");
        }

        return retArray;
    }
    
    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgz(Map)ɕϊĕԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    public Map<String, Object>[] executeForMapArray(String sqlID, Object bindParams) {
        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        
        // \bhi[
        params.setMethodName("executeForMapArray");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        Map<String, Object>[] retArray = proessForObjectArray(Map.class);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray End.");
        }

        return retArray;
    }

    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgzɕϊĕԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param clazz ԋpl̃NX
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    public <E> E[] executeForObjectArray(String sqlID, Object bindParams, Class clazz, int beginIndex, int maxCount) {
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setClazz(clazz);
        params.setBeginIndex(String.valueOf(beginIndex));
        params.setMaxCount(String.valueOf(maxCount));

        // \bhi[
        params.setMethodName("executeForObjectArray");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);

        // ԋpl̎擾
        E[] retArray = proessForObjectArray(clazz);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray End.");
        }

        return retArray;
    }

    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgz(Map)ɕϊĕԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    public Map<String, Object>[] executeForMapArray(String sqlID, Object bindParams, int beginIndex, int maxCount) {
        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setBeginIndex(String.valueOf(beginIndex));
        params.setMaxCount(String.valueOf(maxCount));

        // \bhi[
        params.setMethodName("executeForMapArray");

        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        Map<String, Object>[] retArray = proessForObjectArray(Map.class);

        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray End.");
        }

        return retArray;
    }

    /**
     * queryDAOResults̈ԖڂɊi[ꂽXg̃IuWFNg
     * clazž^ɃLXgAzƂĕԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param clazz ԋpl̃NX
     * @return LXgς݂̕ԋpl
     */
    @SuppressWarnings("unchecked")
    protected <E> E[] proessForObjectArray(Class clazz) {
        
        if (clazz == null) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException();
        }

        // ԋpl̎擾
        Object obj = queryDAOResults.get(0);

        // ԋpς݂ƂȂԋplXg폜
        queryDAOResults.remove(0);
        
        //OIuWFNg̏ꍇ̓X[B
        if (obj instanceof RuntimeException) {
        	throw (RuntimeException)obj;
        } 
        return (E[]) obj;
//
//        //SQL̎sFl̎擾
//        List list = (List) obj;
//
//        //zɕϊ
//        E[] retArray = (E[]) Array.newInstance(clazz, list.size());
//
//        try {
//            list.toArray(retArray);
//        } catch (ArrayStoreException e) {
//            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
//            throw new IllegalClassTypeException(e);
//        }
//        
//        // ԋpς݂ƂȂԋplXg폜
//        queryDAOResults.remove(0);
//        
//        return retArray;
    }

    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlID, Object bindParams) {
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setClazz(this.getClass());
        
        // \bhi[
        params.setMethodName("executeForObjectList");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        List<Object> retArray = proessForObjectList(this.getClass());
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList End.");
        }

        return (List<E>) retArray;
    }

    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    public List<Map<String, Object>> executeForMapList(String sqlID, Object bindParams) {
        if (log.isDebugEnabled()) {
            log.debug("executeForMapList Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        
        // \bhi[
        params.setMethodName("executeForMapList");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        List<Map<String, Object>> retArray = proessForObjectList(Map.class);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForMapList End.");
        }

        return retArray;
    }

    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlID, Object bindParams, int beginIndex, int maxCount) {
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setClazz(this.getClass());
        params.setBeginIndex(String.valueOf(beginIndex));
        params.setMaxCount(String.valueOf(maxCount));

        // \bhi[
        params.setMethodName("executeForObjectList");
        
        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);

        // ԋpl̎擾
        List<Object> retArray = proessForObjectList(this.getClass());
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList End.");
        }

        return (List<E>) retArray;
    }

    /**
     * queryDAOParamsɊi[A
     * queryDAOResults̈ԖڂɊi[ꂽXgԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    public List<Map<String, Object>> executeForMapList(String sqlID, Object bindParams, int beginIndex, int maxCount) {
        if (log.isDebugEnabled()) {
            log.debug("executeForMapList Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        params.setBeginIndex(String.valueOf(beginIndex));
        params.setMaxCount(String.valueOf(maxCount));

        // \bhi[
        params.setMethodName("executeForMapList");

        // \bhs񃊃XgɊi[
        queryDAOParams.add(params);
        
        // ԋpl̎擾
        List<Map<String, Object>> retArray = proessForObjectList(Map.class);

        if (log.isDebugEnabled()) {
            log.debug("executeForMapList End.");
        }

        return retArray;
    }

    /**
     * queryDAOResults̈ԖڂɊi[ꂽXg̃IuWFNg
     * ԋpB
     * ԋplqueryDAOResults͍폜B
     * 
     * @param <E> ԋpľ^
     * @param clazz ԋpl̃NX
     * @return LXgς݂̕ԋpl
     */
    @SuppressWarnings("unchecked")
    protected <E> List<E> proessForObjectList(Class clazz) {
        
        if (clazz == null) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException();
        }

        // ԋpl̎擾
        Object obj = queryDAOResults.get(0);

        // ԋpς݂ƂȂԋplXg폜
        queryDAOResults.remove(0);
        
        //OIuWFNg̏ꍇ̓X[B
        if (obj instanceof RuntimeException) {
        	throw (RuntimeException)obj;
        }
        return (List<E>) obj;

    }

}