/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.DownloadString} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * String_E[hf[^Ƃ邽߂̃NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.DownloadString
 */
public class DownloadStringTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DownloadStringTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DownloadStringTest(String name) {
        super(name);
    }

    /**
     * testDownloadString01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *         () value:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.no.download.content"<br>
     *                    bvOF<br>
     *                    IllegalArgumentException<br>
     *         
     * <br>
     * valuenull̏ꍇAOX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadString01() throws Exception {
        // O

        // eXg{
        try {
            @SuppressWarnings("unused")
            DownloadString downloadString = new DownloadString(null, null);
            fail("SystemException܂łB");
        } catch (SystemException e) {
            // 
            assertEquals("errors.no.download.content", e.getErrorCode());
            assertEquals(IllegalArgumentException.class, e.getCause()
                    .getClass());
        }
    }

    /**
     * testDownloadString02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:null<br>
     *         () value:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) name:null<br>
     *         (ԕω) value:"abc"<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * contentType, charsetɃftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadString02() throws Exception {
        // O

        // eXg{
        DownloadString downloadString = new DownloadString(null, "abc");

        // 
        assertNull(downloadString.name);
        assertEquals("abc", downloadString.value);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadString.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadString.charset);
    }

    /**
     * testDownloadString03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *         () value:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"  "i󔒁j<br>
     *         (ԕω) value:"  "i󔒁j<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadString03() throws Exception {
        // O

        // eXg{
        DownloadString downloadString = new DownloadString("  ", "  ");

        // 
        assertEquals("  ", downloadString.name);
        assertEquals("  ", downloadString.value);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadString.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadString.charset);
    }

    /**
     * testDownloadString04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *         () value:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) name:""i󕶎j<br>
     *         (ԕω) value:""i󕶎j<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadString04() throws Exception {
        // O

        // eXg{
        DownloadString downloadString = new DownloadString("", "");

        // 
        assertEquals("", downloadString.name);
        assertEquals("", downloadString.value);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadString.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadString.charset);
    }

    /**
     * testDownloadString05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () value:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"abc"<br>
     *         (ԕω) value:"abc"<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadString05() throws Exception {
        // O

        // eXg{
        DownloadString downloadString = new DownloadString("abc", "abc");

        // 
        assertEquals("abc", downloadString.name);
        assertEquals("abc", downloadString.value);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadString.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadString.charset);
    }

    /**
     * testGetLengthOfData01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) int:"abc"#getBytes#length̒l<br>
     *         
     * <br>
     * valuẽTCYԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLengthOfData01() throws Exception {
        // O
        DownloadString downloadString = new DownloadString("", "");
        downloadString.value = "abc";

        // eXg{
        int size = downloadString.getLengthOfData();

        // 
        assertEquals("abc".getBytes().length, size);
    }

    /**
     * testGetContent01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () charset:"NOT-EXIST"<br>
     *         
     * <br>
     * ҒlF(߂l) byte[]:"abc"#getBytes̒l<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Charset is not valid."<br>
     *                    O:<br>
     *                    UnsupportedEncodingException<br>
     *         
     * <br>
     * charset݂ȂꍇɃOo͂邱ƂƁA<br>
     * valuebytez񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetContent01() throws Exception {
        // O
        DownloadString downloadString = new DownloadString("", "");
        downloadString.value = "abc";
        downloadString.charset = "NOT-EXIST";

        // eXg{
        byte[] byteBs = downloadString.getContent();

        // 
        assertEquals("abc".getBytes().length, byteBs.length);
        assertEquals("abc".getBytes()[0], byteBs[0]);
        assertEquals("abc".getBytes()[1], byteBs[1]);
        assertEquals("abc".getBytes()[2], byteBs[2]);

        assertTrue(LogUTUtil.checkWarn("Charset is not valid.",
                new UnsupportedEncodingException()));
    }

    /**
     * testGetContent02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () charset:"UTF-8"<br>
     *         
     * <br>
     * ҒlF(߂l) byte[]:"abc"#getBytes("UTF-8")̒l<br>
     *         
     * <br>
     * valuebytez񂪕ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetContent02() throws Exception {
        // O
        DownloadString downloadString = new DownloadString("", "");
        downloadString.value = "abc";
        downloadString.charset = "UTF-8";

        // eXg{
        byte[] byteBs = downloadString.getContent();

        // 
        assertEquals("abc".getBytes("UTF-8").length, byteBs.length);
        assertEquals("abc".getBytes("UTF-8")[0], byteBs[0]);
        assertEquals("abc".getBytes("UTF-8")[1], byteBs[1]);
        assertEquals("abc".getBytes("UTF-8")[2], byteBs[2]);
    }

    /**
     * testGetStreamInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) InputStream:ByteArrayInputStream<br>
     *         
     * <br>
     * valuebvꂽByteArrayInputStreamԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetStreamInternal01() throws Exception {
        // O
        DownloadString downloadString = new DownloadString("", "");
        downloadString.value = "abc";

        // eXg{
        InputStream stream = downloadString.getStreamInternal();

        // 
        assertNotNull(stream);
        assertEquals(ByteArrayInputStream.class, stream.getClass());

        assertEquals("abc".getBytes()[0], stream.read());
        assertEquals("abc".getBytes()[1], stream.read());
        assertEquals("abc".getBytes()[2], stream.read());
        assertEquals(-1, stream.read());
    }

}
