/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

import org.springframework.jdbc.object.MappingSqlQuery;

/**
 * f[^x[XR[hXg擾s RDBMSIy[VNXB
 *
 * f[^x[Xɐڑf[^\[XƎgpSQLRXgN^Ŏw肵āA
 * execute\bhs邱ƂŁAf[^x[XR[hXg擾邱Ƃ
 * łB
 * ̃NX
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListLoader}
 * ł̂ݗpB
 *
 *
 */
public class DBCodeListQuery extends MappingSqlQuery {

    /**
     * f[^\[XSQL̐ݒsRXgN^B
     *
     * @param dataSource f[^x[XڑɎgpf[^\[XB
     * @param sql R[hXg擾ɎgpSQLB
     */
    public DBCodeListQuery(DataSource dataSource, String sql) {
        super(dataSource, sql);
    }

    /**
     * 1s擾邲ƂɌĂ΂B
     *
     * <p>
     * 擾s1ڂid2ڂnameƂăf[^x[X擾l
     * CodeBeanCX^XтB
     * </p>
     *
     * @param rs ݂̍sResultSetB
     * @param rowNum ݎQƂĂsԍBiŏ0sځj
     * @throws SQLException SQLOB
     * @return 擾ʂi[ꂽCX^XB
     */
    @Override
    protected Object mapRow(ResultSet rs, int rowNum)
        throws SQLException {
        return createCodeBean(rs);
    }

    /**
     * ResultSetl擾ACodeBeanCX^X𐶐B
     *
     * @param rs lێResultSetB
     * @return li[ꂽCodeBeanCX^XB
     * @throws SQLException SQLOB
     */
    private LocaleCodeBean createCodeBean(ResultSet rs) throws SQLException {
        LocaleCodeBean cb = new LocaleCodeBean();
        int columnCount = rs.getMetaData().getColumnCount();
        if (columnCount > 0) {
            // 1ڂ݂ꍇB
            String id = rs.getString(1);
            if (id == null) {
                id = "";
            }
            cb.setId(id);
        }

        if (columnCount > 1) {
            // 2ڂ݂ꍇB
            String name = rs.getString(2);
            if (name == null) {
                name = "";
            }
            cb.setName(name);
        }

        if (columnCount > 2) {
            // 3ڂ݂ꍇB
            String language = rs.getString(3);
            if (language == null) {
                language = "";
            }
            cb.setLanguage(language);
        }

        if (columnCount > 3) {
            // 4ڂ݂ꍇB
            String country = rs.getString(4);
            if (country == null) {
                country = "";
            }
            cb.setCountry(country);
        }

        if (columnCount > 4) {
            // 5ڂ݂ꍇB
            String variant = rs.getString(5);
            if (variant == null) {
                variant = "";
            }
            cb.setVariant(variant);
        }
        return cb;
    }

}
