/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.fw.web.struts.actions.ActionEx;
import jp.terasoluna.fw.web.struts.actions.DispatchAction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;

/**
 * struts-config̐ݒActionɔfNX
 * <p>
 * ΉANVNX
 * <li>ActionEx 1</li>
 * <li>ForwardAction 1</li>
 * <li>DispatchAction 2</li>
 * <li>LogoffAction 1</li>
 * <li>MakeSessionDirectoryAction 1</li>
 * </p>
 * <p>
 * 1.ActionEx̃tB[hɂĂ̂ݑΉ
 * </p>
 * <p>
 * 2.eventtB[h̐ݒɑΉ
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.resolver.ConfigurationReflector
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.actions.ActionEx
 * @see jp.terasoluna.fw.web.struts.actions.ForwardAction
 * @see jp.terasoluna.fw.web.struts.actions.DispatchAction
 * @see jp.terasoluna.fw.web.struts.actions.LogoffAction
 * @see jp.terasoluna.fw.web.struts.actions.MakeSessionDirectoryAction
 */
public class GeneralConfigurationReflector implements ConfigurationReflector {

    /**
     * OB
     */
    private static Log log = LogFactory
            .getLog(GeneralConfigurationReflector.class);

    /*
     * (non-Javadoc)
     * @see
     * jp.terasoluna.fw.web.struts.action.resolver.ConfigurationTranslator#setConfiguration(org.apache.struts.action.Action,
     * java.lang.String, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.context.ApplicationContext)
     */
    public Action setConfiguration(Action action, String beanName,
            ActionMapping mapping, ActionServlet servlet,
            ApplicationContext applicationContext) {

        // ActionEx
        // ANV}bsOwg[N̐ݒx擾ActionExɐݒ肷
        if (action instanceof ActionEx) {
            ResolverActionMapping anMapping = (ResolverActionMapping) mapping;
            ActionEx actionEx = (ActionEx) action;

            actionEx.setSaveToken(anMapping.isSaveToken());
            actionEx.setTokenCheck(anMapping.isTokenCheck());

            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("beanName:");
                sb.append(beanName);
                sb.append(", ");
                sb.append("saveToken:");
                sb.append(anMapping.isSaveToken());
                sb.append(", ");
                sb.append("tokenCheck:");
                sb.append(anMapping.isTokenCheck());
                log.trace(sb.toString());
            }
        }

        // AbstractBLogicAction
        // ANV}bsOwbZ[WۑXR[vݒx擾AbstractBLogicActionɐݒ肷
        if (action instanceof AbstractBLogicAction) {
            AbstractBLogicAction<?> blogicAction = (AbstractBLogicAction<?>) action;
            ResolverActionMapping anMapping = (ResolverActionMapping) mapping;

            blogicAction.setSaveMessageScope(anMapping.getSaveMessageScope());

            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("beanName:");
                sb.append(beanName);
                sb.append(", ");
                sb.append("saveMessageScope:");
                sb.append(anMapping.getSaveMessageScope());
                log.trace(sb.toString());
            }
        }

        // DispatchAction
        // ANV}bsOwJڐ\vpeBx擾DispatchActionɐݒ肷
        if (action instanceof DispatchAction) {
            ((DispatchAction) action)
                    .setEvent(((ResolverActionMapping) mapping).getEvent());

            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("beanName:");
                sb.append(beanName);
                sb.append(", ");
                sb.append("event:");
                sb.append(((ResolverActionMapping) mapping).getEvent());
                log.trace(sb.toString());
            }
        }

        return action;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.ConfigurationTranslator#supports(org.apache.struts.action.Action,
     * java.lang.String, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.context.ApplicationContext)
     */
    public boolean supports(Action action, String beanName,
            ActionMapping mapping, ActionServlet servlet,
            ApplicationContext applicationContext) {
        if (action instanceof ActionEx
                && mapping instanceof ResolverActionMapping) {
            outputLog(action, mapping, true);
            return true;
        }

        outputLog(action, mapping, false);
        return false;
    }

    /**
     * Oo͗p\bh
     * @param action Action
     * @param mapping ActionMapping
     * @param bool supports
     */
    private void outputLog(Action action, ActionMapping mapping, boolean bool) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("supports( ");
            if (action != null) {
                sb.append("action : ");
                if (AopUtils.isAopProxy(action)) {
                    sb.append(AopUtils.getTargetClass(action).getSimpleName());
                } else {
                    sb.append(action.getClass().getSimpleName());
                }
            } else {
                sb.append("action : null");
            }
            sb.append(" , ");
            if (mapping != null) {
                sb.append("mapping : ");
                if (AopUtils.isAopProxy(mapping)) {
                    sb.append(AopUtils.getTargetClass(mapping).getSimpleName());
                } else {
                    sb.append(mapping.getClass().getSimpleName());
                }
            } else {
                sb.append("mapping : null");
            }
            sb.append(" ) : ");
            sb.append(bool);
            log.trace(sb.toString());
        }
    }
}
