/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.service.thin;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.web.struts.form.FormEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class BLogicMapper
extends AbstractBLogicMapper {
    private static Log log = LogFactory.getLog(BLogicMapper.class);
    private static final String ERROR_RESOURCES_FILE = "errors.resources.file";

    public BLogicMapper() {
    }

    public BLogicMapper(String resources) {
        if (resources == null || "".equals(resources)) {
            log.error((Object)"resources file location is not specified");
            throw new IllegalArgumentException(ERROR_RESOURCES_FILE);
        }
    }

    public Object getValueFromRequest(String propName, HttpServletRequest request, HttpServletResponse response) {
        if (propName == null || "".equals(propName)) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw new IllegalArgumentException();
        }
        Object value = request.getAttribute(propName);
        if (log.isDebugEnabled() && request.getAttribute(propName) == null) {
            log.debug((Object)("Request's attribute is null:key =[" + propName + "]"));
        }
        return value;
    }

    public Object getValueFromForm(String propName, HttpServletRequest request, HttpServletResponse response) throws PropertyAccessException {
        ActionForm form = this.getActionForm(request);
        Object value = null;
        try {
            value = BeanUtil.getBeanProperty((Object)form, (String)propName);
        }
        catch (PropertyAccessException e) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw e;
        }
        return value;
    }

    public Object getValueFromSession(String propName, HttpServletRequest request, HttpServletResponse response) {
        if (propName == null || "".equals(propName)) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw new IllegalArgumentException();
        }
        HttpSession session = request.getSession(true);
        Object value = session.getAttribute(propName);
        if (log.isDebugEnabled() && session.getAttribute(propName) == null) {
            log.debug((Object)("Session's attribute is null:key =[" + propName + "]"));
        }
        return value;
    }

    public void setValueToRequest(Object value, String propName, HttpServletRequest request, HttpServletResponse response) {
        if (propName == null || "".equals(propName)) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            Enumeration enumeration = request.getAttributeNames();
            boolean existFlag = false;
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.equals(propName)) continue;
                existFlag = true;
                break;
            }
            if (!existFlag) {
                log.debug((Object)("Request's key does not exist:key =[" + propName + "]"));
            }
        }
        request.setAttribute(propName, value);
    }

    public void setValueToForm(Object value, String propName, HttpServletRequest request, HttpServletResponse response) throws PropertyAccessException {
        ActionForm form = this.getActionForm(request);
        try {
            BeanUtil.setBeanProperty((Object)form, (String)propName, (Object)value);
            if (form instanceof FormEx) {
                FormEx formEx = (FormEx)form;
                formEx.setModified(true);
            }
        }
        catch (PropertyAccessException e) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw e;
        }
    }

    public void setValueToSession(Object value, String propName, HttpServletRequest request, HttpServletResponse response) {
        if (propName == null || "".equals(propName)) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw new IllegalArgumentException();
        }
        HttpSession session = request.getSession(true);
        if (log.isDebugEnabled()) {
            Enumeration enumeration = session.getAttributeNames();
            boolean existFlag = false;
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.equals(propName)) continue;
                existFlag = true;
                break;
            }
            if (!existFlag) {
                log.debug((Object)("Session's key does not exist:key =[" + propName + "]"));
            }
        }
        session.setAttribute(propName, value);
    }

    protected ActionForm getActionForm(HttpServletRequest request) {
        ActionMapping mapping = (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
        ActionForm form = null;
        if ("request".equals(mapping.getScope())) {
            form = (ActionForm)request.getAttribute(mapping.getAttribute());
        } else {
            HttpSession session = request.getSession();
            form = (ActionForm)session.getAttribute(mapping.getAttribute());
        }
        return form;
    }

    public Object getValueFromApplication(String propName, HttpServletRequest request, HttpServletResponse response) {
        if (propName == null || "".equals(propName)) {
            log.error((Object)("illegal argument:propName = [" + propName + "]"));
            throw new IllegalArgumentException();
        }
        HttpSession session = request.getSession(true);
        ServletContext context = session.getServletContext();
        Object value = context.getAttribute(propName);
        if (log.isDebugEnabled() && value == null) {
            log.debug((Object)("ServletContext's attribute is null:key =[" + propName + "]"));
        }
        return value;
    }
}

