/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimitedLock
extends ReentrantLock {
    private static final long serialVersionUID = 894432960610700290L;
    private static final Log log = LogFactory.getLog(LimitedLock.class);
    private transient Object lock = new Object();
    private int threshold;
    private transient LinkedList<Thread> waitingThreadList = new LinkedList();

    public LimitedLock(int threshold) {
        this.threshold = threshold > 0 ? threshold : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockInterruptibly() throws InterruptedException {
        Object object;
        boolean successToLock = false;
        if (this.getOwner() != Thread.currentThread()) {
            object = this.lock;
            synchronized (object) {
                int queueLength = this.getQueueLength();
                if (queueLength > this.threshold) {
                    HashSet oldWaitingThreadSet = null;
                    LinkedList<Thread> linkedList = this.waitingThreadList;
                    synchronized (linkedList) {
                        List oldWaitingThreadList = this.waitingThreadList.subList(0, queueLength - this.threshold);
                        oldWaitingThreadSet = new HashSet(oldWaitingThreadList);
                    }
                    for (Thread queuedThread : this.getQueuedThreads()) {
                        if (!oldWaitingThreadSet.contains(queuedThread)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("interrupt thread '" + queuedThread + "'."));
                        }
                        LinkedList<Thread> linkedList2 = this.waitingThreadList;
                        synchronized (linkedList2) {
                            this.waitingThreadList.remove(queuedThread);
                            queuedThread.interrupt();
                            while (this.getQueuedThreads().contains(queuedThread)) {
                                Thread.yield();
                            }
                        }
                    }
                }
            }
        }
        try {
            object = this.waitingThreadList;
            synchronized (object) {
                this.waitingThreadList.add(Thread.currentThread());
            }
            super.lockInterruptibly();
            successToLock = true;
        }
        finally {
            object = this.lock;
            synchronized (object) {
                LinkedList<Thread> linkedList = this.waitingThreadList;
                synchronized (linkedList) {
                    this.waitingThreadList.remove(Thread.currentThread());
                    if (!successToLock) {
                        Thread.interrupted();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (this.getOwner() != Thread.currentThread()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            super.unlock();
            while (this.getQueueLength() > 0 && this.getOwner() == null) {
                Thread.yield();
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.lock = new Object();
        this.waitingThreadList = new LinkedList();
    }
}

