/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.web.struts.reset.Resetter;
import jp.terasoluna.fw.web.struts.reset.ResetterImpl;
import jp.terasoluna.fw.web.struts.reset.ResetterResources;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.xml.sax.SAXException;

public class ResetterPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog(ResetterPlugIn.class);
    private static final String DIGESTER_RULES_PATH = "/WEB-INF/reset-rules.xml";
    private static Digester digester = null;
    private static final String DEFAULT_RESETTER = ResetterImpl.class.getName();
    private String publicIdentifier = "-//NTTDATA//DTD TERASOLUNA for Spring reset 1.0//JA";
    private String dtdUrl = "/jp/terasoluna/fw/web/struts/plugins/dtd/reset.dtd";
    private String resetter = null;
    private String resourcesPath = null;
    private String digesterRules = null;

    public void destroy() {
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"init() called.");
        }
        this.initResetter(servlet, config);
        this.initResources(servlet, config);
    }

    protected void initResetter(ActionServlet servlet, ModuleConfig config) throws ServletException {
        Resetter resetterObj = null;
        try {
            resetterObj = this.resetter == null || "".equals(this.resetter) ? (Resetter)ClassUtil.create((String)DEFAULT_RESETTER) : (Resetter)ClassUtil.create((String)this.resetter);
        }
        catch (ClassLoadException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        servlet.getServletContext().setAttribute("RESETTER" + config.getPrefix(), (Object)resetterObj);
    }

    protected void initResources(ActionServlet servlet, ModuleConfig config) throws ServletException {
        if (this.resourcesPath == null || "".equals(this.resourcesPath)) {
            log.error((Object)"resources file location is not specified");
            throw new ServletException("resources file location is not specified");
        }
        StringTokenizer st = new StringTokenizer(this.resourcesPath, ",");
        ArrayList<String> pathList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            path = path.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("reset file=" + path));
            }
            pathList.add(path);
        }
        if (digester == null) {
            if (this.digesterRules == null) {
                this.digesterRules = DIGESTER_RULES_PATH;
            }
            try {
                digester = DigesterLoader.createDigester((URL)servlet.getServletContext().getResource(this.digesterRules));
                digester.setValidating(true);
            }
            catch (MalformedURLException e) {
                log.error((Object)"", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (XmlLoadException e) {
                log.error((Object)"", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
        ResetterResources resetterResources = new ResetterResources();
        try {
            for (int i = 0; i < pathList.size(); ++i) {
                digester.push((Object)resetterResources);
                URL url = this.getClass().getResource(this.getDtdUrl());
                if (url != null) {
                    digester.register(this.getPublicIdentifier(), url.toString());
                }
                digester.parse(servlet.getServletContext().getResourceAsStream((String)pathList.get(i)));
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        servlet.getServletContext().setAttribute("RESETTER_RESOURCES" + config.getPrefix(), (Object)resetterResources);
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public String getDtdUrl() {
        return this.dtdUrl;
    }

    public void setResetter(String string) {
        this.resetter = string;
    }

    public void setResources(String string) {
        this.resourcesPath = string;
    }

    public void setDigesterRules(String digesterRules) {
        this.digesterRules = digesterRules;
    }

    public void setPublicIdentifier(String publicIdentifier) {
        this.publicIdentifier = publicIdentifier;
    }

    public void setDtdUrl(String dtdUrl) {
        this.dtdUrl = dtdUrl;
    }
}

