/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.aop.log;

import java.util.List;

import jp.terasoluna.fw.service.thin.BLogicResult;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * BLogicNXsÕfobOOo͂邽߂̃C^Zv^
 * 
 * @version 1.0.0
 */
public class BLogicLogInterceptor implements MethodInterceptor {

    /**
     * OCX^X
     */
    private static Log logger = LogFactory.getLog(BLogicLogInterceptor.class);

    /**
     * G[OƂďo͂ȂONXXgB 
     * ONX̓NX̊SCNXݒ肷
     */
    private List<Class> noErrorLogExceptionLists = null;

    /**
     * G[OƂďo͂ȂONXXgݒ肷
     * 
     * @param noErrorLogExceptionLists ONXXg
     */
    public void setNoErrorLogExceptionLists(
            List<Class> noErrorLogExceptionLists) {
        this.noErrorLogExceptionLists = noErrorLogExceptionLists;
    }

    /**
     * BLogicNX̊e\bh̎sOɁAfobOOo͂܂B 
     * ܂A\bhsɗOꍇAG[Oo͂܂B
     * 
     * @param invocation C^Zv^Ώۂ̃IuWFNg
     * @return C^Zv^Kp̃IuWFNg
     * @throws Throwable sO
     * 
     * @see org.aopalliance.intercept.MethodInterceptor#
     *       invoke(org.aopalliance.intercept.MethodInvocation)
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<? extends Object> blogicClass = null;
        if (logger.isDebugEnabled()) {
            blogicClass = invocation.getThis().getClass();
            logger.debug(blogicClass.getSimpleName().concat(
                    " is being executed..."));
            logger.debug(createParamsInfo(invocation.getArguments()));
        }
        Object result = null;
        try {
            result = invocation.proceed();
        } catch (Throwable e) {
            if (checkException(e)) {
                logger.error(e);
                throw e;
            } else {
                logger.debug(e);
                throw e;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(createResultInfo(result));
            logger.debug(blogicClass.getSimpleName().concat(
                    " was executed completely."));
        }
        return result;
    }

    /**
     * \bhp[^̕\ԂB
     * 
     * @param args \bhp[^
     * @return p[^̕\
     */
    private String createParamsInfo(Object[] args) {
        StringBuilder info = new StringBuilder("Params:");
        if (args == null) {
            info.append("null");
        } else {
            for (int i = 0; i < args.length; i++) {
                if (args[i] == null) {
                    info.append("null");
                } else {
                    info.append(args[i].toString());
                }
                if (i != args.length - 1) {
                    info.append(",");
                }
            }
        }
        return info.toString();
    }

    /**
     * ߂l̕\ԂB
     * 
     * @param result @\bh̖߂l
     * @return \bh߂l̕\
     */
    private String createResultInfo(Object result) {
        StringBuilder info = new StringBuilder("Result:");
        if (result == null) {
            info.append("null");
        } else if (result instanceof BLogicResult) {
            BLogicResult blogicResult = (BLogicResult) result;
            info.append("resultString=").append(blogicResult.getResultString());
            info.append(",resultObject=");
            if (blogicResult.getResultObject() == null) {
                info.append("null");
            } else {
                info.append(blogicResult.getResultObject().toString());
            }
        } else {
            info.append(result.toString());
        }
        return info.toString();
    }

    /**
     * Oo̓x̔sB<br>
     * ERRORxŃOo͂Ȍꍇtrue<br>
     * DEGUGxŃOo͂Ȍꍇfalse<br>
     * ԂB<br>
     * <br>
     * vpeBnoErrorLogExceptionListsɐݒ肳ꂽOA
     * ͂̃TuNX̗OłfalseԂB<br>
     * ȊOtrueԂB
     * 
     * @param target `FbNΏۂƂȂO
     * @return Oo̓xl
     */
    protected boolean checkException(Throwable target) {
        if ( noErrorLogExceptionLists != null ) {
            for (Class noCheckException : noErrorLogExceptionLists) {
    
                if (noCheckException.isAssignableFrom(target.getClass())) {
                    return false;
                }
            }
        }
        return true;
    }
}
