/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import jp.terasoluna.fw.web.RequestUtil;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

/**
 * ۗOnhNXłB 
 * 񋟂eOnhNXɋʂ鏈W񂵂Ă܂B
 * 
 * @version 1.0.0
 */
public abstract class AbstractExceptionHandler extends ExceptionHandler {

    /**
     * ȉ̗Os܂B<br>
     * <ol>
     * <li>Jڐ\ActionForwardCX^X擾܂B</li>
     * <li>\[XohG[bZ[Ẅꗗ擾A
     * w肳ꂽXR[vɓo^܂B</li>
     * <li>OOɏo͂܂B</li>
     * <li>ȌNGXgɓo^܂B</li>
     * </ol>
     * 
     * @param ex OIuWFNg
     * @param ae ExceptionConfig
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return Jڐ\ActionFowardCX^X
     */
    @Override
    public ActionForward execute(Exception ex, ExceptionConfig ae,
            ActionMapping mapping, ActionForm form, HttpServletRequest request,
            HttpServletResponse response) throws ServletException {
        ActionForward forward = getActionForward(ex, ae, mapping, request);
        setModule(forward, ex, ae, mapping);
        String bundleKey = getBundleKey(ae);
        MessageResources resources = getMessageResources(request, bundleKey);
        ActionMessages errors = getErrors(ex, ae, resources);
        storeException(request, errors, forward, ae.getScope());
        logException(ex);
        setRequestAttribute(request, ex, ae, mapping);
        return forward;
    }

    /**
     * Jڐ\ActionForwardCX^X擾܂B 
     * ȉ̏őJڐ肵܂B
     * <ol>
     * <li>exceptionvfpath</li>
     * <li>sactionvfinput</li>
     * <li>擾łȂꍇnull</li>
     * </ol>
     * 
     * @param ex OIuWFNg
     * @param ae ExceptionConfig
     * @param mapping ANV}bsO
     * @param request NGXg
     * @return Jڐ\ActionForwardCX^X<br>
     */
    protected ActionForward getActionForward(Exception ex, ExceptionConfig ae,
            ActionMapping mapping, HttpServletRequest request) {
        ActionForward forward = null;
        if (ae.getPath() != null) {
            forward = new ActionForward(ae.getPath());
        } else {
            forward = mapping.getInputForward();
        }
        return forward;
    }

    /**
     * \[Xoh̃L[擾܂B
     * 
     * @param ae ExceptionConfig
     * @return \[Xoh̃L[
     */
    protected String getBundleKey(ExceptionConfig ae) {
        if (ae.getBundle() != null) {
            return ae.getBundle();
        }
        return Globals.MESSAGES_KEY;
    }

    /**
     * bZ[W\[X擾܂B
     * 
     * @param request NGXg
     * @param bundleKey \[Xoh̃L[
     * @return bZ[W\[X
     */
    protected MessageResources getMessageResources(HttpServletRequest request,
            String bundleKey) {
        MessageResources messageResources = (MessageResources) request
                .getAttribute(bundleKey);
        if (messageResources != null) {
            return messageResources;
        }
        return (MessageResources) RequestUtil.getServletContext(request)
                .getAttribute(bundleKey);
    }

    /**
     * Globals.ERROR_KEYL[ɁAG[bZ[Ẅꗗ
     * w肳ꂽXR[vɓo^܂B
     * 
     * @param request NGXg
     * @param errors G[bZ[Wꗗ
     * @param forward ActionFowardCX^X
     * @param scope G[bZ[Ẅꗗo^XR[v
     */
    protected void storeException(HttpServletRequest request,
            ActionMessages errors, ActionForward forward, String scope) {
        if ("request".equals(scope)) {
            request.setAttribute(Globals.ERROR_KEY, errors);
        } else {
            request.getSession().setAttribute(Globals.ERROR_KEY, errors);
        }
    }

    /**
     * Globals.EXCEPTION_KEYAPageContext.EXCEPTIONL[ɁA
     * ONGXgɓo^܂B
     * 
     * @param request NGXg
     * @param ex O
     * @param ae ExceptionConfig
     * @param mapping ANV}bsO
     */
    protected void setRequestAttribute(HttpServletRequest request,
            Exception ex, ExceptionConfig ae, ActionMapping mapping) {
        request.setAttribute(Globals.EXCEPTION_KEY, ex);
        request.setAttribute(PageContext.EXCEPTION, ex);
    }

    /**
     * G[bZ[ẄꗗێActionMessages̃CX^X擾܂B
     * 
     * @param ex O
     * @param ae ExceptionConfig
     * @param resources bZ[W\[X
     * @return G[bZ[ẄꗗێActionMessagesCX^X
     */
    protected abstract ActionMessages getErrors(Exception ex,
            ExceptionConfig ae, MessageResources resources);

    /**
     * ActionForwardCX^XɁAJڐ惂W[ݒ肵܂B
     * 
     * @param forward ActionForwardCX^X
     * @param ex O
     * @param ae ExceptionConfig
     * @param mapping ANV}bsO
     */
    protected abstract void setModule(ActionForward forward, Exception ex,
            ExceptionConfig ae, ActionMapping mapping);
}
