/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import java.util.HashSet;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import jp.terasoluna.fw.web.struts.plugins.ValidatorPlugInEx;
import jp.terasoluna.utlib.MockServletContext;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ValidatorPlugInExTest {

    ValidatorPlugInEx target;
    ModuleConfig           config;

    @Before
    public void setUp() throws Exception {

        target = new ValidatorPlugInEx();
        config = new ModuleConfigImpl();
    }

    @After
    public void tearDown() throws Exception {
        target = null;
        config = null;
    }

    @Test
    public void testInitResources() throws ServletException {
        // initservlettB[hɃZbgȂƓȂߏȗ
    }

    @Test
    // *ňxɓǂݍޏꍇ
    public void testInit1() throws ServletException {
        ServletContext context = new TestServletContext();
        ActionServlet servlet = EasyMock.createMockBuilder(ActionServlet.class)
                .withConstructor().addMockedMethod("getServletContext")
                .createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context).times(3);
        EasyMock.replay(servlet);
        target.setPathnames("classpath*:/**/validation*.xml");
        target.init(servlet, config);
        EasyMock.verify(servlet);
    }

    @Test
    // ēǂޏꍇ
    public void testInit2() throws ServletException {
        ServletContext context = new TestServletContext();
        ActionServlet servlet = EasyMock.createMockBuilder(ActionServlet.class)
                .withConstructor().addMockedMethod("getServletContext")
                .createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context).times(4);
        EasyMock.replay(servlet);
        target.setPathnames("classpath*:/**/validation-MD01.xml, /**/validation-MD02.xml");
        target.init(servlet, config);
        EasyMock.verify(servlet);
    }

    @Test
    // pathnames̏ꍇ
    public void testInit3() throws ServletException {
        ServletContext context = new TestServletContext();
        ActionServlet servlet = EasyMock.createMockBuilder(ActionServlet.class)
                .withConstructor().addMockedMethod("getServletContext")
                .createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context).times(2);
        EasyMock.replay(servlet);
        target.setPathnames("");
        target.init(servlet, config);
        EasyMock.verify(servlet);
    }

    @Test
    // pathnamesnull̏ꍇ
    public void testInit4() throws ServletException {
        ServletContext context = new TestServletContext();
        ActionServlet servlet = EasyMock.createMockBuilder(ActionServlet.class)
                .withConstructor().addMockedMethod("getServletContext")
                .createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context).times(2);
        EasyMock.replay(servlet);
        target.init(servlet, config);
        EasyMock.verify(servlet);
    }

    class TestServletContext extends MockServletContext {
        @Override
        public Set<?> getResourcePaths(String s) {
            return new HashSet<String>();
        }
    }

}
