/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import static org.junit.Assert.*;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.action.annotation.BLogicComponent;
import jp.terasoluna.fw.web.struts.action.resolver.AnnotationTestBLogic;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.util.ClassUtils;

public class GenericBeanFactoryAccessorExTest {

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * getBeansWithAnnotation\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : "hoge"</li>
     * <li>bean : new AnnotationTestBLogic()</li>
     * <li>beanNames : { beanName }</li>
     * <li>applicationContext : MockWebApplicationContext( getBeanNamesForType(Object.class) : beanNames, <br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * getBean(beanName) : bean, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     */
    @Test
    public void testGetBeansWithAnnotationClassOfQextendsAnnotation001() {
        // p[^
        MockWebApplicationContext ac = new MockWebApplicationContext();
        String beanName = "hoge";
        Object bean = new AnnotationTestBLogic();
        String[] beanNames = { beanName };
        ac.addBeanNamesForType(Object.class, beanNames);
        ac.addContainsBeanMap(beanName, Boolean.TRUE);
        ac.addBeanMap(beanName, bean);

        // 
        GenericBeanFactoryAccessorEx ax = new GenericBeanFactoryAccessorEx(ac);

        // eXg
        Map<String, Object> result = ax
                .getBeansWithAnnotation(BLogicComponent.class);

        // 
        assertNotNull(result);
        assertNotNull(result.get(beanName));
        assertEquals(bean, result.get(beanName));
    }

    /**
     * findAnnotationOnBean\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : "hoge"</li>
     * <li>bean : new AnnotationTestBLogic()</li>
     * <li>beanNames : { beanName }</li>
     * <li>applicationContext : MockWebApplicationContext( getBeanNamesForType(Object.class) : beanNames, <br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * getBean(beanName) : bean, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     */
    @Test
    public void testFindAnnotationOnBeanStringClassOfA001() {
        // p[^
        MockWebApplicationContext ac = new MockWebApplicationContext();
        String beanName = "hoge";
        Object bean = new AnnotationTestBLogic();
        String[] beanNames = { beanName };
        ac.addBeanNamesForType(Object.class, beanNames);
        ac.addContainsBeanMap(beanName, Boolean.TRUE);
        ac.addBeanMap(beanName, bean);

        // 
        GenericBeanFactoryAccessorEx ax = new GenericBeanFactoryAccessorEx(ac);

        // eXg
        BLogicComponent result = ax.findAnnotationOnBean(beanName,
                BLogicComponent.class);

        // 
        assertNotNull(result);
    }

    /**
     * findAnnotationOnBean\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : "hoge"</li>
     * <li>bean : new AnnotationTestBLogic() AOPvLVŃbv</li>
     * <li>beanNames : { beanName }</li>
     * <li>applicationContext : MockWebApplicationContext( getBeanNamesForType(Object.class) : beanNames, <br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * getBean(beanName) : bean, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testFindAnnotationOnBeanStringClassOfA002() {
        // p[^
        MockWebApplicationContext ac = new MockWebApplicationContext();
        String beanName = "hoge";

        Object bean = null;
        AdvisedSupport advised = new AdvisedSupport();
        Class[] proxiedInterfaces = AopProxyUtils
                .completeProxiedInterfaces(advised);
        InvocationHandler handler = new InvocationHandler() {
            public Object invoke(Object proxy, Method method, Object[] args)
                                                                            throws Throwable {
                return AnnotationTestBLogic.class;
            }
        };
        // vLVIuWFNg
        bean = Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(),
                proxiedInterfaces, handler);

        String[] beanNames = { beanName };
        ac.addBeanNamesForType(Object.class, beanNames);
        ac.addContainsBeanMap(beanName, Boolean.TRUE);
        ac.addBeanMap(beanName, bean);

        // 
        GenericBeanFactoryAccessorEx ax = new GenericBeanFactoryAccessorEx(ac);

        // eXg
        BLogicComponent result = ax.findAnnotationOnBean(beanName,
                BLogicComponent.class);

        // 
        assertNotNull(result);
    }

    /**
     * findAnnotationOnBean\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : "hoge"</li>
     * <li>bean : new AnnotationTestBLogic()</li>
     * <li>beanNames : { beanName }</li>
     * <li>applicationContext : Kwꂽ MockWebApplicationContext( getBeanNamesForType(Object.class) : beanNames, <br>
     * containsBean(beanName) : Boolean.TRUE, <br>
     * getBean(beanName) : bean, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     */
    @Test
    public void testFindAnnotationOnBeanStringClassOfA003() {
        // p[^
        MockWebApplicationContext ac1 = new MockWebApplicationContext();
        MockWebApplicationContext ac = new MockWebApplicationContext();

        String beanName = "hoge";
        Object bean = new AnnotationTestBLogic();
        Object beanDummy = new Object();
        String[] beanNames = { beanName };

        ac1.addBeanNamesForType(Object.class, beanNames);
        ac1.addContainsBeanMap(beanName, Boolean.TRUE);
        ac1.addBeanMap(beanName, beanDummy);
        ac1.addContainsBeanDefinitionMap(beanName, Boolean.TRUE);
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(AnnotationTestBLogic.class);
        ac1.addRergedBeanDefinitionMap(beanName, bd);
        ac1.setParent(ac);

        ac.addBeanNamesForType(Object.class, beanNames);
        ac.addContainsBeanMap(beanName, Boolean.TRUE);
        ac.addBeanMap(beanName, bean);

        // 
        GenericBeanFactoryAccessorEx ax = new GenericBeanFactoryAccessorEx(ac1);

        // eXg
        BLogicComponent result = ax.findAnnotationOnBean(beanName,
                BLogicComponent.class);

        // 
        assertNotNull(result);
    }

}
