/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MockMessage
implements Message,
Cloneable,
Serializable {
    private String messageId = null;
    private long timestamp = System.currentTimeMillis();
    private String correlationId;
    private Destination replyTo;
    private Destination destination;
    private int deliveryMode = 2;
    private boolean redelivered = false;
    private String type;
    private long expiration = 0L;
    private int priority = 4;
    private boolean acknowledged = false;
    private Map properties = new HashMap();
    private boolean isInWriteMode = true;
    private boolean isInWriteModeProperties = true;

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public String getJMSMessageID() throws JMSException {
        return this.messageId;
    }

    public void setJMSMessageID(String string) throws JMSException {
        this.messageId = string;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        this.timestamp = l;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (null == this.correlationId) {
            return null;
        }
        try {
            return this.correlationId.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMSException(unsupportedEncodingException.getMessage());
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        try {
            this.correlationId = null == byArray ? null : new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMSException(unsupportedEncodingException.getMessage());
        }
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        this.correlationId = string;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationId;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.replyTo = destination;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        this.deliveryMode = n;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        this.redelivered = bl;
    }

    public String getJMSType() throws JMSException {
        return this.type;
    }

    public void setJMSType(String string) throws JMSException {
        this.type = string;
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.expiration = l;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int n) throws JMSException {
        this.priority = n;
    }

    public void clearProperties() throws JMSException {
        this.isInWriteModeProperties = true;
        this.properties.clear();
    }

    public boolean propertyExists(String string) throws JMSException {
        return this.properties.containsKey(string);
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Boolean.valueOf(null);
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to boolean");
    }

    public byte getByteProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Byte.valueOf(null);
        }
        if (object instanceof String) {
            return Byte.valueOf((String)object);
        }
        if (object instanceof Byte) {
            return ((Number)object).byteValue();
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to byte");
    }

    public short getShortProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Short.valueOf(null);
        }
        if (object instanceof String) {
            return Short.valueOf((String)object);
        }
        if (object instanceof Short || object instanceof Byte) {
            return ((Number)object).shortValue();
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to short");
    }

    public int getIntProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Integer.valueOf(null);
        }
        if (object instanceof String) {
            return Integer.valueOf((String)object);
        }
        if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return ((Number)object).intValue();
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to int");
    }

    public long getLongProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Long.valueOf(null);
        }
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return ((Number)object).longValue();
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to long");
    }

    public float getFloatProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Float.valueOf(null).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        if (object instanceof Float) {
            return ((Number)object).floatValue();
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to float");
    }

    public double getDoubleProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (object == null) {
            return Double.valueOf(null);
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        if (object instanceof Double || object instanceof Float) {
            return ((Number)object).doubleValue();
        }
        throw new MessageFormatException("Cannot convert property " + string + " of type " + object.getClass().getName() + " to double");
    }

    public String getStringProperty(String string) throws JMSException {
        Object object = this.getObjectProperty(string);
        if (null == object) {
            return null;
        }
        return object.toString();
    }

    public Object getObjectProperty(String string) throws JMSException {
        return this.properties.get(string);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return new Vector(this.properties.keySet()).elements();
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        this.setObjectProperty(string, new Boolean(bl));
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        this.setObjectProperty(string, new Byte(by));
    }

    public void setShortProperty(String string, short s) throws JMSException {
        this.setObjectProperty(string, new Short(s));
    }

    public void setIntProperty(String string, int n) throws JMSException {
        this.setObjectProperty(string, new Integer(n));
    }

    public void setLongProperty(String string, long l) throws JMSException {
        this.setObjectProperty(string, new Long(l));
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        this.setObjectProperty(string, new Float(f));
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        this.setObjectProperty(string, new Double(d));
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        this.setObjectProperty(string, string2);
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (!this.isInWriteModeProperties) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == string || string.length() <= 0) {
            throw new IllegalArgumentException("Property names must not be null or empty strings");
        }
        if (null == object) {
            return;
        }
        if (object instanceof String || object instanceof Number || object instanceof Boolean) {
            this.properties.put(string, object);
            return;
        }
        throw new MessageFormatException(object.getClass().getName() + " not a valid type");
    }

    public void acknowledge() throws JMSException {
        this.acknowledged = true;
    }

    public void clearBody() throws JMSException {
        this.isInWriteMode = true;
    }

    public void setReadOnly(boolean bl) {
        this.isInWriteMode = !bl;
    }

    public void setReadOnlyProperties(boolean bl) {
        this.isInWriteModeProperties = !bl;
    }

    public Object clone() {
        try {
            MockMessage mockMessage = (MockMessage)super.clone();
            mockMessage.properties = new HashMap(this.properties);
            return mockMessage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }

    protected boolean isInWriteMode() {
        return this.isInWriteMode;
    }
}

