/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueueConnection;
import com.mockrunner.mock.jms.MockTopicConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

public class MockConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory,
Serializable {
    private DestinationManager destinationManager;
    private ConfigurationManager configurationManager;
    private List connections = new ArrayList();
    private JMSException exception;

    public MockConnectionFactory(DestinationManager destinationManager, ConfigurationManager configurationManager) {
        this.destinationManager = destinationManager;
        this.configurationManager = configurationManager;
        this.exception = null;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        MockConnection mockConnection = new MockConnection(this.destinationManager, this.configurationManager, string, string2);
        mockConnection.setJMSException(this.exception);
        this.connections.add(mockConnection);
        return mockConnection;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        MockQueueConnection mockQueueConnection = new MockQueueConnection(this.destinationManager(), this.configurationManager(), string, string2);
        mockQueueConnection.setJMSException(this.exception());
        this.connections().add(mockQueueConnection);
        return mockQueueConnection;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        MockTopicConnection mockTopicConnection = new MockTopicConnection(this.destinationManager(), this.configurationManager(), string, string2);
        mockTopicConnection.setJMSException(this.exception());
        this.connections().add(mockTopicConnection);
        return mockTopicConnection;
    }

    public void setJMSException(JMSException jMSException) {
        this.exception = jMSException;
    }

    public void clearConnections() {
        this.connections.clear();
    }

    public MockConnection getConnection(int n) {
        if (this.connections.size() <= n) {
            return null;
        }
        return (MockConnection)this.connections.get(n);
    }

    public MockConnection getLatestConnection() {
        if (this.connections.size() == 0) {
            return null;
        }
        return (MockConnection)this.connections.get(this.connections.size() - 1);
    }

    protected DestinationManager destinationManager() {
        return this.destinationManager;
    }

    protected ConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    protected List connections() {
        return this.connections;
    }

    protected JMSException exception() {
        return this.exception;
    }
}

