/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.CollectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MockBlob
implements Blob,
Cloneable {
    private List blobData;
    private boolean wasFreeCalled;

    public MockBlob(byte[] byArray) {
        this.blobData = ArrayUtil.getListFromByteArray(byArray);
        this.wasFreeCalled = false;
    }

    public long length() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.blobData.size();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        n = this.verifyAndFixLength(l, n);
        return ArrayUtil.getByteArrayFromList(this.blobData, (int)(l - 1L), n);
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new ByteArrayInputStream(ArrayUtil.getByteArrayFromList(this.blobData));
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        l2 = this.verifyAndFixLength(l, (int)l2);
        return new ByteArrayInputStream(ArrayUtil.getByteArrayFromList(this.blobData, (int)(l - 1L), (int)l2));
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        byte[] byArray2 = ArrayUtil.getByteArrayFromList(this.blobData);
        int n = ArrayUtil.indexOf(byArray2, byArray, (int)(l - 1L));
        if (-1 != n) {
            ++n;
        }
        return n;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        ArrayUtil.addBytesToList(byArray, this.blobData, (int)(l - 1L));
        return byArray.length;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        ArrayUtil.addBytesToList(byArray, n, n2, this.blobData, (int)(l - 1L));
        return n2;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new BlobOutputStream((int)(l - 1L));
    }

    public void truncate(long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        this.blobData = CollectionUtil.truncateList(this.blobData, (int)l);
    }

    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MockBlob mockBlob = (MockBlob)object;
        if (this.wasFreeCalled != mockBlob.wasFreeCalled()) {
            return false;
        }
        return ((Object)this.blobData).equals(mockBlob.blobData);
    }

    public int hashCode() {
        int n = ((Object)this.blobData).hashCode();
        n = 31 * n + (this.wasFreeCalled ? 31 : 62);
        return n;
    }

    public String toString() {
        return "Blob data: " + this.blobData.toString();
    }

    public Object clone() {
        try {
            MockBlob mockBlob = (MockBlob)super.clone();
            mockBlob.blobData = new ArrayList(this.blobData);
            return mockBlob;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }

    private int verifyAndFixLength(long l, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be greater or equals 0");
        }
        if ((long)n + (l - 1L) > (long)this.blobData.size()) {
            return this.blobData.size() - (int)(l - 1L);
        }
        return n;
    }

    private class BlobOutputStream
    extends OutputStream {
        private int index;

        public BlobOutputStream(int n) {
            this.index = n;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            ArrayUtil.addBytesToList(byArray, MockBlob.this.blobData, this.index);
            ++this.index;
        }
    }
}

