/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.MessageFormatCacheMapFactory;
import jp.terasoluna.fw.web.struts.action.GlobalMessageResources;
import jp.terasoluna.fw.web.struts.action.MessageResourcesDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

public class DBMessageResources
extends MessageResources {
    private static final long serialVersionUID = 8244415315747028752L;
    public static final String MESSAGES_DAO = "messages.dao";
    public static final String MESSAGES_SQL = "messages.sql";
    private static final String DB_MESSAGE_RESOURCES_ERROR = "errors.db.message.resources";
    private static final String DB_MESSAGE_RESOURCES_ERROR_INIT = "errors.db.message.resources.init";
    private static Log log = LogFactory.getLog(DBMessageResources.class);
    private static Map dbMessages = null;
    private Map<String, String> messages = new HashMap<String, String>();

    public DBMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        if (log.isDebugEnabled()) {
            log.debug((Object)"call DBMessageResources()");
        }
        this.replaceMessageFormatCache();
        if (dbMessages == null) {
            DBMessageResources.dbInit();
        }
        this.propertyInit(config);
    }

    public DBMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        if (log.isDebugEnabled()) {
            log.debug((Object)"call DBMessageResources()");
        }
        this.replaceMessageFormatCache();
        if (dbMessages == null) {
            DBMessageResources.dbInit();
        }
        this.propertyInit(config);
    }

    private void replaceMessageFormatCache() {
        HashMap<String, MessageFormat> map = MessageFormatCacheMapFactory.getInstance();
        if (map != null) {
            this.formats = map;
        }
    }

    protected static void dbInit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"call dbInit()");
        }
        dbMessages = new HashMap();
        String daoName = PropertyUtil.getProperty((String)MESSAGES_DAO);
        String sql = PropertyUtil.getProperty((String)MESSAGES_SQL);
        if (daoName == null && sql == null) {
            return;
        }
        if (daoName == null || sql == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"defined only one of the pair - messages.dao and messages.sql.");
            }
            return;
        }
        MessageResourcesDAO dao = null;
        try {
            dao = (MessageResourcesDAO)ClassUtil.create((String)daoName);
        }
        catch (ClassLoadException e) {
            log.error((Object)("\"" + daoName + "\" cannot loaded."), (Throwable)e);
            throw new SystemException((Throwable)e, DB_MESSAGE_RESOURCES_ERROR_INIT);
        }
        catch (ClassCastException e) {
            log.error((Object)("\"" + daoName + "\" not implemented" + " MessageResourcesDAO"), (Throwable)e);
            throw new SystemException((Throwable)e, DB_MESSAGE_RESOURCES_ERROR_INIT);
        }
        dbMessages = dao.queryMessageMap(sql);
    }

    protected void propertyInit(String propertyFile) {
        Properties props = null;
        Iterator<Object> names = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"call propertyInit()");
        }
        if ((props = PropertyUtil.loadProperties((String)propertyFile)) == null) {
            log.error((Object)("Message resources file \"" + propertyFile + "\" is illegal."));
            return;
        }
        for (String string : props.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving property message key [" + string + "]" + "value [" + props.getProperty(string) + "]"));
            }
            this.messages.put(string, props.getProperty(string));
        }
    }

    public String getMessage(Locale locale, String key) {
        String retMessage;
        GlobalMessageResources globalMessageResources = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"call getMessage(Locale, String)");
        }
        if (key == null || "".equals(key)) {
            log.error((Object)"Message key 'null' or empty not allowed.");
            throw new SystemException(null, DB_MESSAGE_RESOURCES_ERROR);
        }
        if (this.messages != null && (retMessage = this.messages.get(key)) != null) {
            return retMessage;
        }
        if (dbMessages != null && (retMessage = (String)dbMessages.get(key)) != null) {
            return retMessage;
        }
        globalMessageResources = GlobalMessageResources.getInstance();
        retMessage = globalMessageResources.getMessage(locale, key);
        if (retMessage != null) {
            return retMessage;
        }
        if (!this.returnNull) {
            return "???" + this.messageKey(locale, key) + "???";
        }
        return null;
    }

    public String getMessage(String key) {
        Locale locale = null;
        return this.getMessage(locale, key);
    }
}

