/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;


import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * GrfXOo͏sB
 * 
 * <p>
 * GrfXOo͂Ƃ́ANGXgp^Oo͂邱ƂłB
 * </p>
 * <h5>gp@</h5>
 * ̋@\gpɂ̓fvCgfBXNv^iweb.xmljɈȉ̂悤
 * ݒ肷B<br>
 * <br>
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;evidenceLogFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;
 *     jp.terasoluna.fw.web.thin.EvidenceLogFilter
 *   &lt;/filter-class&gt;
 * &lt;/filter&gt;
 *
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;evidenceLogFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * </pre></code>
 * 
 *
 */
public class EvidenceLogFilter implements Filter {
    
    /**
     * NGXgtB^[ʉ߂ƂNGXg̃L[B
     */
    public static final String EVIDENCELOG_THRU_KEY = "EVIDENCELOG_THRU_KEY";
    
    /**
     * ONX
     */
    private static Log log
        = LogFactory.getLog(EvidenceLogFilter.class);

    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB
     *  
     * ReíAFilterCX^XɁAinit \bh
     * 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A
     * init \bh IĂȂ΂ȂȂB
     * init\bh ̂ꂩ̏Ԃ̏ꍇARei
     * FilterT[rXԂɂłȂB<br>
     * <ul>
     *  <li>ServletException X[B </li>
     *  <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     * </ul>
     * <br>
     * ̃NXł͏͍sȂB
     * 
     * @param config FilterConfigCX^XB
     * 
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     *             
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) throws ServletException {
        //ɂȂ
    }
    
    /**
     * GrfXOo͂B
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     * 
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     * 
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest req,
                         ServletResponse res,
                         FilterChain chain)
            throws IOException, ServletException {

        //NGXgtB^ʉ߂ǂ𔻒B
        if (req.getAttribute(EVIDENCELOG_THRU_KEY) == null) {

            req.setAttribute(EVIDENCELOG_THRU_KEY, "true");

            evidenceLog("--------------------------------------------");

            // NGXgURIo
            evidenceLog(
                "RequestURI = " + ((HttpServletRequest) req).getRequestURI());

            // p[^ꗗo
            evidenceLog("Parameters = {");
            Map paramMap = ((HttpServletRequest) req).getParameterMap();
            Iterator iter = paramMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String) iter.next();
                Object value = paramMap.get(key);
                if (value == null) {
                    evidenceLog("  " + key + " = null");
                } else if (value.getClass().isArray()) {
                    Object[] values = (Object[]) value;
                    for (int i = 0; i < values.length; i++) {
                        String valueView = "null";
                        if (values[i] != null) {
                            valueView = values[i].toString();
                        }
                        evidenceLog("  " + key + "[" + i + "] = " + valueView);
                    }
                } else {
                    evidenceLog("  " + key + " = " + value.toString());
                }
            }
            evidenceLog("}");

            evidenceLog("--------------------------------------------");

        }

        // ̃tB^܂̓T[ubg
        chain.doFilter(req, res);
    }


    /**
     * GrfXOo͂B
     *
     * @param s Oɏo͂镶
     */
    private void evidenceLog(String s) {
        if (log.isDebugEnabled()) {
            log.debug("**** EVIDENCE ***: " + s);
        }
    }
    
    /**
     * tB^ɌĂяoB<br>
     * ̃NXł͏͍sȂB
     * 
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
        // ɂȂ
    }

}
