/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.taglib;
/**
 * {@link jp.terasoluna.framework.ex.web.struts.taglib.PageLinksTagEx} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * y[WPʂɃy[WJڂ@\B
 * getInt()̃eXg̈ꕔdoStartTag()ɕ܂B
 * <p>
 * 
 * @see jp.terasoluna.framework.web.struts.taglib.PageLinksTag
 */
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockPageContext;

import jp.terasoluna.fw.ex.web.struts.taglib.PageLinksTagEx;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;

public class PageLinksTagExTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * ANVtH[
     */
    private PageLinksTagEx_TestForm testForm = null;
    /**
     * ̃eXgP[Xsׂ
     * ANVtH[
     */
    private PageLinksTagEx pageLinksTagEx = null;

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔQ
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUpData() throws Exception {
        //super.setUp();
        pageLinksTagEx = (PageLinksTagEx) TagUTUtil.create(PageLinksTagEx.class);
        clearProperty();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    protected void cleanUpData() throws Exception {
        //super.tearDown();
        testForm = null;
        pageLinksTagEx = null;
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public PageLinksTagExTest(String name){
        super(name);
    }

    /**
     * testGetUrl01()
     * <br><br>
     * 
     * inj<br>
     * <br>
     * ͒lF(߂l) String:""<br>
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetUrl01() throws Exception{
        
        String param = "abc";
        UTUtil.setPrivateField(pageLinksTagEx, "url", param);

        //eXg{
        String value = pageLinksTagEx.getUrl();

        //
        assertEquals(param, value);
    }

    /**
     * testSetUrl01()
     * <br><br>
     * 
     * inj<br>
     * <br>
     * ͒lF() url:"abc"<br>
     *         () url:null<br>
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔQ
     */
    public void testSetUrl01() throws Exception {

        String param = "abc";
        UTUtil.setPrivateField(pageLinksTagEx, "url", null);

        //eXg{
        pageLinksTagEx.setUrl(param);

        //
        assertEquals(param,UTUtil.getPrivateField(pageLinksTagEx, "url"));
    }

    /**
     * testGetFormName01()
     * <br><br>
     * 
     * inj<br>
     * <br>
     * ͒lF(߂l) String:""<br>
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetFormName01() throws Exception{
        
        String param = "abc";
        UTUtil.setPrivateField(pageLinksTagEx, "formName", param);

        //eXg{
        String value = pageLinksTagEx.getFormName();

        //
        assertEquals(param, value);
    }

    /**
     * testSetFormName01()
     * <br><br>
     * 
     * inj<br>
     * <br>
     * ͒lF() formName:"abc"<br>
     *         () formName:null<br>
     * <br>
     * nꌏ̂݃eXg@
     * <br>
     * 
     * @throws Exception ̃\bhŔQ
     */
    public void testSetFormName01() throws Exception {

        String param = "abc";
        UTUtil.setPrivateField(pageLinksTagEx, "formName", null);

        //eXg{
        pageLinksTagEx.setFormName(param);

        //
        assertEquals(param,UTUtil.getPrivateField(pageLinksTagEx, "formName"));
    }

    /**
     * testGetPageJump01()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() pageJump:true<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetPageJump01() throws Exception {
        // O
        Boolean param = new Boolean(true);
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", param);

        // eXg{
        boolean value = pageLinksTagEx.getPageJump();

        // 
        assertTrue(value);
    }

    /**
     * testSetPageJump01()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() pageJump:true<br>
     *         () pageJump:false<br>
     *         
     * <br>
     * ҒlF(ԕω) pageJump:true<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetPageJump01() throws Exception {
        // O
        boolean param = true;
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(false));

        // eXg{
        pageLinksTagEx.setPageJump(param);

        // 
        boolean result = ((Boolean) UTUtil.getPrivateField(
                pageLinksTagEx, "pageJump")).booleanValue();
        assertTrue(result);
    }


    /**
     * testDoStartTag01()
     * <br><br>
     * (ُn)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WFuAction attribute is required when submit 
     *                    attribute is gfalseh.v<br>
     * <br>
     * submitfalseŁAactionnull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag01() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", null);

        // eXg{
        try {
            pageLinksTagEx.doStartTag();
            fail();
        } catch (JspException e) {
            // 
            assertEquals(
                    UTUtil.getPrivateField(pageLinksTagEx, "ERROR_MESSAGE_ACTION_REQUIRED"), e.getMessage());
        }
    }

    /**
     * testDoStartTag02()
     * <br><br>
     * (ُn)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WFuAction attribute is required when submit 
     *                    attribute is gfalseh.v<br>
     * <br>
     * submitfalseŁAaction󔒂̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag02() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "");

        // eXg{
        try {
            pageLinksTagEx.doStartTag();
            fail();
        } catch (JspException e) {
            // 
            assertEquals(
                    UTUtil.getPrivateField(pageLinksTagEx, "ERROR_MESSAGE_ACTION_REQUIRED"), e.getMessage());
        }
    }

    /**
     * testDoStartTag03()
     * <br><br>
     * (ُn)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="a", startIndex="0", totalCount="100"}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOFNumberFormatException<br>
     * <br>
     * 擾\slɕϊłȂꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag03() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("a");
        testForm.setStartIndex("0");
        testForm.setTotalCount("100");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        try {
            pageLinksTagEx.doStartTag();
            fail();
        } catch (JspException e) {
            // 
            assertEquals(NumberFormatException.class.getName(),
                    e.getRootCause().getClass().getName());
        }
    }

    /**
     * testDoStartTag04()
     * <br><br>
     * (ُn)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="10", startIndex="a", totalCount="100"}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOFNumberFormatException<br>
     * <br>
     * 擾\JnCfbNXlɕϊłȂꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag04() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("10");
        testForm.setStartIndex("a");
        testForm.setTotalCount("100");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        try {
            pageLinksTagEx.doStartTag();
            fail();
        } catch (JspException e) {
            // 
            assertEquals(NumberFormatException.class.getName(),
                    e.getRootCause().getClass().getName());
        }
    }

    /**
     * testDoStartTag05()
     * <br><br>
     * (ُn)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="10", startIndex="0", totalCount="a"}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOFNumberFormatException<br>
     * <br>
     * 擾SlɕϊłȂꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag05() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("10");
        testForm.setStartIndex("0");
        testForm.setTotalCount("a");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        try {
            pageLinksTagEx.doStartTag();
            fail();
        } catch (JspException e) {
            // 
            assertEquals(NumberFormatException.class.getName(),
                    e.getRootCause().getClass().getName());
        }
    }

    /**
     * testDoStartTag06()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="10", startIndex=null, totalCount=null}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     *         
     * <br>
     * w肳ꂽBeañvpeB̒lׂnull̏ꍇA
     * ftHgKpăNo͂ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag06() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("10");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
    }

    /**
     * testDoStartTag07()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_TestForm(){<br>
     *                row="10", startIndex="", totalCount=""}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     *         
     * <br>
     * w肳ꂽBeañvpeB̒lׂċ󔒂̏ꍇA
     * ftHgKpăNo͂ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag07() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("10");
        testForm.setStartIndex("");
        testForm.setTotalCount("");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
    }

    /**
     * testDoStartTag08()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() submit:true<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_TestForm(){<br>
     *                row="10", startIndex="0", totalCount="100"}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     *         
     * <br>
     * lɎ擾ϊłATu~bg郊No͂ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag08() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(true));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("10");
        testForm.setStartIndex("0");
        testForm.setTotalCount("100");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
    }

    /**
     * testDoStartTag09()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row=null, startIndex=null, totalCount=null}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     *         
     * <br>
     * w肳ꂽBeanrowvpeB̒lnull̏ꍇA
     * xOo͂ďI邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag09() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());
    }

    /**
     * testDoStartTag10()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="", startIndex="", totalCount=""}]<br>
     *         () name:"bean"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"satartIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     * w肳ꂽBeañvpeB̒lׂnull̏ꍇA
     * ftHgKpăNo͂ꍇ
     * 
     * <br>
     * w肳ꂽBeanrowvpeB̒l󔒂̏ꍇA
     * xOo͂ďI邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag10() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("");
        testForm.setStartIndex("");
        testForm.setTotalCount("");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());
    }

    /**
     * testDoStartTag11()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() id:"listPageLinks"<br>
     *         () submit:true<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="10", startIndex="0", totalCount="100"}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         () currentPageIndex:null<br>
     *         () totalPageCount:null<br>
     * 
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     *         (ԕω) JspWriter:o͂ȂƁB<br>
     *         
     * <br>
     * idw肳Ăꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag11() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "id", "listPageLinks");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(true));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("1");
        testForm.setStartIndex("0");
        testForm.setTotalCount("1");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "startIndex", true);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
        String resultValue = (String) pageContext.getAttribute("listPageLinks");
        assertEquals("1", resultValue);
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());
    }

    /**
     * testDoStartTag12()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() id:""<br>
     *         () submit:true<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="10", startIndex="0", totalCount="100"}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.start.tag=<ul><br>
     *                pageLinks.end.tag=</ul><br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     *         (ԕω) JspWriter:1<br>
     * <br>
     * id󔒂̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag12() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "id", "");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(true));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");

        addProperty("pageLinks.start.tag", "<ul>");
        addProperty("pageLinks.end.tag", "</ul>");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("1");
        testForm.setStartIndex("0");
        testForm.setTotalCount("1");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "startIndex", true);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
        String resultValue = (String) pageContext.getAttribute("listPageLinks");
        assertEquals(null, resultValue);
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("<ul>1</ul>",reader.readLine());
        assertNull(reader.readLine());
    }

    /**
     * testDoStartTag13()
     * <br><br>
     * (ُn)<br>
     * <br>
     * ͒lF() row:1<br>
     *         () startIndex:0<br>
     *         () totalCount:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"satartIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         () forward:true<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () JspWriter#println():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspTagException<br>
     *                    bZ[WF-<br>
     *                    bvOF-<br>
     *         
     * <br>
     * JspWriterIOExceptionꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag13() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", true);
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("1");
        testForm.setStartIndex("0");
        testForm.setTotalCount("1");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + (String)UTUtil.getPrivateField(pageLinksTagEx, "FORWARD_NAME"), true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +"row", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +"index", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", true);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        // eXgpJspWriter̐
        Exception_JspWriterImpl out =
            new Exception_JspWriterImpl();
        out.setTrue();
    
        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pageContext, "jspWriter", out);
    
        // eXg{
        try {
            pageLinksTagEx.doStartTag();
            fail();
        } catch (JspTagException e) {
            // 
            if (e.getMessage().indexOf("IOException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testDoStartTag14()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() submit:false<br>
     *         () action:"/list"<br>
     *         () pageContext:not null<br>
     *                ["testForm"= <br>
     *                new PageLinksTagEx_testForm(){<br>
     *                row="1", startIndex="0", totalCount=null}]<br>
     *         () name:"testForm"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () totalProperty:"totalCount"<br>
     *         () pageJump:true<br>
     *         () pageContextPAGEJUMP_JAVASCRIPT_KEY̒l:true<br>
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_INCLUDE<br>
     * <br>
     * pageJumpw肳Ăꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag14() throws Exception {
        UTUtil.setPrivateField(pageLinksTagEx, "submit", new Boolean(false));
        UTUtil.setPrivateField(pageLinksTagEx, "action", "/list");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "testForm");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalCount");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));

        testForm = new PageLinksTagEx_TestForm();
        testForm.setRow("1");

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        ((MockHttpServletRequest)pageContext.getRequest()).setContextPath("/terasoluna-pagelinks-tag");
        pageContext.setAttribute("testForm", testForm, PageContext.PAGE_SCOPE);
        pageContext.setAttribute(PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY, true);

        // eXg{
        int value = pageLinksTagEx.doStartTag();

        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, value);
    }

    /**
     * testDefineHtml01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"index"<br>
     *         () forward:true<br>
     *         () event:"abs"<br>
     *         () resetIndex:false<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:<input type=\"hidden\" name=\"row\" value=\"10\"/><br>
     *                    <input type=\"hidden\" name=\"index\" value=\"0\"/><br>
     *                    <input type=\"hidden\" name=\"abs\" value=\"\"/><br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:false<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * y[WReLXg̃tOׂfalsȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml01() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "index");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", true);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", false);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "abs", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "index", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", false);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 0, 0);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("<input type=\"hidden\" name=\"row\" value=\"10\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"index\" value=\"0\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"abs\"" +
                " value=\"\"/>",reader.readLine());
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "abs");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "index");
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertFalse(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertFalse(bol);
    }

    /**
     * testDefineHtml02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () forward:true<br>
     *         () event:"abs"<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:o͂ȂƂmFB<br>
     *         
     * <br>
     * y[WReLXg̃tOׂtruȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml02() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "index");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", true);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "abs", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "index", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", true);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 0, 0);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "abs");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "index");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertTrue(bol);
    }

    /**
     * testDefineHtml03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () forward:false<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:o͂ȂƂmFB<br>
     *         
     * <br>
     * y[WReLXg̃tOׂtruȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml03() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "index");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", false);
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + (String)UTUtil.getPrivateField(pageLinksTagEx, "FORWARD_NAME"), true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +"row", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +"index", true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", true);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 0, 0);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + (String)UTUtil.getPrivateField(pageLinksTagEx, "FORWARD_NAME"));
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") +"row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") +"index");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertTrue(bol);
    }

    /**
     * testDefineHtml04()
     * <br><br>
     * 
     * (ُn)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"index"<br>
     *         () forward:true<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () JspWriter#println():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOF-<br>
     *         
     * <br>
     * JspWriterIOExceptionꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml04() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "index");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", true);
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +(String)UTUtil.getPrivateField(pageLinksTagEx, "FORWARD_NAME"), true);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +"row", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                +"index", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", true);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXgpJspWriter̐
        Exception_JspWriterImpl out =
            new Exception_JspWriterImpl();
        out.setTrue();
    
        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pageContext, "jspWriter", out);
    
        // eXg{
        try {
            pageLinksTagEx.defineHtml(10, 0, 0);
            fail();
        } catch (JspException e) {
            // 
            if (e.getMessage().indexOf("IOException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testDefineHtml05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"index"<br>
     *         () forward:false<br>
     *         () event:"abs"<br>
     *         () resetIndex:false<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         () fromName:"pageLinks"<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:<input type=\"hidden\" name=\"row\" value=\"10\"/><br>
     *                    <input type=\"hidden\" name=\"index\" value=\"0\"/><br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * y[WReLXg̃tOׂfalseŁAforwardfalsȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml05() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "index");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", false);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", false);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "abs", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "index", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", false);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 0, 0);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("<input type=\"hidden\" name=\"row\" value=\"10\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"index\" value=\"0\"/>"
                ,reader.readLine());
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "abs");
        assertFalse(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "index");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertFalse(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertFalse(bol);
    }

    /**
     * testDefineHtml06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:9<br>
     *         () totalCount:15<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"index"<br>
     *         () forward:false<br>
     *         () event:"abs"<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         () fromName:"pageLinks"<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:<input type=\"hidden\" name=\"row\" value=\"10\"/><br>
     *                    <input type=\"hidden\" name=\"index\" value=\"9\"/><br>
     *                    <input type=\"hidden\" name=\"startIndex\" value=\"9\"/><br>
     *                    <input type=\"hidden\" name=\"endIndex\" value=\"14\"/><br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * y[WReLXg̃tOׂfalseŁAresetIndextrueŁAJnCfbNXA"startIndex"ł͂Ȃꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml06() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "index");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", false);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "abs", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "index", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", false);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 9, 15);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("<input type=\"hidden\" name=\"row\" value=\"10\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"index\" value=\"9\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"startIndex\" value=\"9\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"endIndex\" value=\"14\"/>"
                ,reader.readLine());
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "abs");
        assertFalse(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "index");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertFalse(bol);
    }

    /**
     * testDefineHtml07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:9<br>
     *         () totalCount:50<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () forward:false<br>
     *         () event:"abs"<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         () fromName:"pageLinks"<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:<input type=\"hidden\" name=\"row\" value=\"10\"/><br>
     *                    <input type=\"hidden\" name=\"startIndex\" value=\"9\"/><br>
     *                    <input type=\"hidden\" name=\"endIndex\" value=\"18\"/><br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * y[WReLXg̃tOׂfalseŁAresetIndextrueŁAJnCfbNXA"startIndex"̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml07() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", false);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "abs", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "index", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", false);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 9, 50);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("<input type=\"hidden\" name=\"row\" value=\"10\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"startIndex\" value=\"9\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"endIndex\" value=\"18\"/>"
                ,reader.readLine());
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "abs");
        assertFalse(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "startIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertFalse(bol);
    }

    /**
     * testDefineHtml08()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:41<br>
     *         () totalCount:50<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () forward:false<br>
     *         () event:"abs"<br>
     *         () resetIndex:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         () fromName:"pageLinks"<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:<input type=\"hidden\" name=\"row\" value=\"10\"/><br>
     *                    <input type=\"hidden\" name=\"startIndex\" value=\"41\"/><br>
     *                    <input type=\"hidden\" name=\"endIndex\" value=\"49\"/><br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * y[WReLXg̃tOׂfalseŁAresetIndextrueŁAJnCfbNXA"startIndex"̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDefineHtml08() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", false);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "abs", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "row", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "index", false);
        pageContext.setAttribute(UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY")
                + "resetIndex", false);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        ActionMapping mapping = new ActionMapping();
        mapping.setName("pageLinks");
        pageContext.getRequest().setAttribute(Globals.MAPPING_KEY, mapping);
    
        // eXg{
        pageLinksTagEx.defineHtml(10, 41, 50);
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("<input type=\"hidden\" name=\"row\" value=\"10\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"startIndex\" value=\"41\"/>"
                ,reader.readLine());
        assertEquals("<input type=\"hidden\" name=\"endIndex\" value=\"49\"/>"
                ,reader.readLine());
        assertNull(reader.readLine());
    
        Boolean bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "abs");
        assertFalse(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "row");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "startIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY") + "resetIndex");
        assertTrue(bol);
        bol = (Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertFalse(bol);
    }

    /**
     * testAddSubmitJS01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:
     *                    <br>
     *                    <script type="text/javascript"><br>
     *                    <!--<br>
     *                      if(typeof(teralib) === "undefined"){<br>
     *                        teralib = {};<br>
     *                      }<br>
     *                      teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){<br>
     *                        var submitForm = document.getElementById('pageLinks_pageLinks');<br>
     *                        submitForm[rowProperty].value = row;<br>
     *                        submitForm[indexProperty].value = startIndex;<br>
     *                        submitForm.submit();<br>
     *                      }<br>
     *                    // --><br>
     *                    </script><br>
     *                    <br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * y[WReLXg̃tOfalsȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddSubmitJS01() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.addSubmitJS();
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("  if(typeof(teralib) === \"undefined\"){", reader.readLine());
        assertEquals("    teralib = {};", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("  teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){", reader.readLine());
        assertEquals("    var submitForm = document.getElementById('pageLinks_pageLinks');", reader.readLine());
        assertEquals("    submitForm[rowProperty].value = row;", reader.readLine());
        assertEquals("    submitForm[indexProperty].value = startIndex;", reader.readLine());
        assertEquals("    submitForm.submit();", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("// -->", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertNull(reader.readLine());
    
        Boolean bol =(Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertTrue(bol);
    }

    /**
     * testAddSubmitJS02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:o͂Ȃ<br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * y[WReLXg̃tOtruȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddSubmitJS02() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        // eXg{
        pageLinksTagEx.addSubmitJS();
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());
    
        Boolean bol =(Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertTrue(bol);
    }

    /**
     * testAddSubmitJS03()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () forward:true<br>
     *         () event:event<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:
     *                    <br>
     *                    <script type="text/javascript"><br>
     *                    <!--<br>
     *                      if(typeof(teralib) === "undefined"){<br>
     *                        teralib = {};<br>
     *                      }<br>
     *                      teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){<br>
     *                        var submitForm = document.getElementById('pageLinks_pageLinks');<br>
     *                        submitForm[rowProperty].value = row;<br>
     *                        submitForm[indexProperty].value = startIndex;<br>
     *                        submitForm.submit();<br>
     *                      }<br>
     *                    // --><br>
     *                    </script><br>
     *                    <br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * y[WReLXg̃tOfalseAforwardtruȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddSubmitJS03() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.addSubmitJS();
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("  if(typeof(teralib) === \"undefined\"){", reader.readLine());
        assertEquals("    teralib = {};", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("  teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){", reader.readLine());
        assertEquals("    var submitForm = document.getElementById('pageLinks_pageLinks');", reader.readLine());
        assertEquals("    submitForm[rowProperty].value = row;", reader.readLine());
        assertEquals("    submitForm[indexProperty].value = startIndex;", reader.readLine());
        assertEquals("    submitForm.event.value = \"forward_pageLinks\";", reader.readLine());
        assertEquals("    submitForm.submit();", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("// -->", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertNull(reader.readLine());
        Boolean bol =(Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertTrue(bol);
    }

    /**
     * testAddSubmitJS04()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () forward:true<br>
     *         () event:abs<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:
     *                    <br>
     *                    <script type="text/javascript"><br>
     *                    <!--<br>
     *                      if(typeof(teralib) === "undefined"){<br>
     *                        teralib = {};<br>
     *                      }<br>
     *                      teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){<br>
     *                        var submitForm = document.getElementById('pageLinks_pageLinks');<br>
     *                        submitForm[rowProperty].value = row;<br>
     *                        submitForm[indexProperty].value = startIndex;<br>
     *                        submitForm.submit();<br>
     *                      }<br>
     *                    // --><br>
     *                    </script><br>
     *                    <br>
     *         (ԕω) pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * y[WReLXg̃tOfalseAforwardtrueAeventabs̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddSubmitJS04() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "forward", true);
        UTUtil.setPrivateField(pageLinksTagEx, "event", "abs");
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        // eXg{
        pageLinksTagEx.addSubmitJS();
    
        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("  if(typeof(teralib) === \"undefined\"){", reader.readLine());
        assertEquals("    teralib = {};", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("  teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){", reader.readLine());
        assertEquals("    var submitForm = document.getElementById('pageLinks_pageLinks');", reader.readLine());
        assertEquals("    submitForm[rowProperty].value = row;", reader.readLine());
        assertEquals("    submitForm[indexProperty].value = startIndex;", reader.readLine());
        assertEquals("    submitForm.abs.value = \"forward_pageLinks\";", reader.readLine());
        assertEquals("    submitForm.submit();", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("// -->", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertNull(reader.readLine());
        Boolean bol =(Boolean) pageContext.getAttribute(
                (String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"));
        assertTrue(bol);
    }

    /**
     * testAddSubmitJS05()
     * <br><br>
     * 
     * (ُn)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () submit:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:false<br>
     *         () JspWriter#println():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOF-<br>
     *         
     * <br>
     * JspWriterIOExceptionꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddSubmitJS05() throws Exception {
        // O
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), false);
    
        ActionMapping mapping = new ActionMapping();
        mapping.setName("pageLinks");
        pageContext.getRequest().setAttribute(Globals.MAPPING_KEY, mapping);
    
        // eXgpJspWriter̐
        Exception_JspWriterImpl out =
            new Exception_JspWriterImpl();
        out.setTrue();
    
        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pageContext, "jspWriter", out);
    
        // eXg{
        try {
            pageLinksTagEx.addSubmitJS();
            fail();
        } catch (JspException e) {
            // 
            if (e.getMessage().indexOf("IOException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testAddFirstSubmit01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () name:"pageLinks"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disable.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="disable">First</li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstSubmit01() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
    
        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;
    
        // eXg{
        pageLinksTagEx.addFirstSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"disable\">First</li>";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstSubmit02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:10<br>>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.first.tag=<li class="first"><br>
     *                pageLinks.end.first.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="first">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex'10,0)">
     * First</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstSubmit02() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
    
        addProperty("pageLinks.start.first.tag", "<li class=\"first\">");
        addProperty("pageLinks.end.first.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addFirstSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"first\">" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,0)\">" +
          "First" +
          "</a></li>";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstSubmit03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:10<br>>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="prev">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex'10,0)">
     * First</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstSubmit03() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addFirstSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"prev\">" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,0)\">" +
          "First" +
          "</a></li>";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstSubmit04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:10<br>>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="first">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex'10,0)">
     * First</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstSubmit04() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addFirstSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li>" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,0)\">" +
          "First" +
          "</a></li>";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstSubmit05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=""<br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:""<br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstSubmit05() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
    
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addFirstSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = "";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstSubmit06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () name:"pageLinks"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:Ȃ
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstSubmit06() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount =100;
    
        // eXg{
        pageLinksTagEx.addFirstSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = new String();
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     *         <li class="prev">
     *         <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,10)">
     *         Prev
     *         </a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit01() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"prev\">" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,10)\">" +
          "Prev" +
          "</a></li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     *         <li class="prev">
     *         <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',0,0)">
     *         Prev
     *         </a></li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit02() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"prev\">" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',0,0)\">" +
          "Prev" +
          "</a></li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:-1<br>
     *         () startIndex:-1<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="prev">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',-1,0)">
     * Prev
     * </a></li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit03() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = -1;
        int startIndex = -1;
        int totalCount = -1;

        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li class=\"prev\">" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',-1,0)\">" +
          "Prev" +
          "</a></li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="prev">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,10)">
     * Prev
     * </a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit04() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(1));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"prev\">" +
          "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,10)\">" +
          "Prev" +
          "</a></li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=""<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:Ȃ
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit05() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = new String();
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:0<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disable.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="disable">First</li>
     * <li class="disable">Prev</li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit06() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(1));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");;

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 0;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li class=\"disable\">Prev</li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,10)">
     * Prev
     * </a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit07() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(1));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,10)\">" +
          "Prev" +
          "</a></li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit08()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:0<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li>First</li>
     * <li>Prev</li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount100̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevSubmit08() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(1));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute((String)UTUtil.getPrivateField(pageLinksTagEx, "PAGELINKS_JAVASCRIPT_KEY"), true);
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 0;
        int totalCount = 100;
    
        // eXg{
        pageLinksTagEx.addPrevSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = "<li>Prev</li>" ;
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:100<br>
     *         () totalCount:130<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,30)">4</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,40)">5</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,50)">6</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,60)">7</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,70)">8</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,80)">9</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,90)">10</a></li>
     * <li class="active">11</li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,110)">12</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,120)">13</a></li>
     * <br>
     *         
     * <br>
     * row10AstartIndex100AtotalCount130ŁA
     * directLinkNo"10"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit01() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "10");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
    
        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 100;
        int totalCount = 130;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,30)\">" +
          "4</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,40)\">" +
          "5</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,50)\">" +
          "6</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,60)\">" +
          "7</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,70)\">" +
          "8</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,80)\">" +
          "9</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,90)\">" +
          "10</a></li>" +
          "<li class=\"active\">11</li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,110)\">" +
          "12</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,120)\">" +
          "13</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:100<br>
     *         () totalCount:200<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"a"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,50)">6</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,60)">7</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,70)">8</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,80)">9</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,90)">10</a></li>
     * <li class="active">11</li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,110)">12</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,120)">13</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,130)">14</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,140)">15</a></li>
     * <br>
     *         
     * <br>
     * row10AstartIndex100AtotalCount200ŁA
     * directLinkNo"a"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit02() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "a");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 100;
        int totalCount = 200;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,50)\">" +
          "6</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,60)\">" +
          "7</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,70)\">" +
          "8</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,80)\">" +
          "9</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,90)\">" +
          "10</a></li>" +
          "<li class=\"active\">11</li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,110)\">" +
          "12</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,120)\">" +
          "13</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,130)\">" +
          "14</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,140)\">" +
          "15</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:2<br>
     *         () totalCount:200<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,0)">1</a></li>
     * <li class="active">2</li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,20)">3</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,30)">4</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,40)">5</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,50)">6</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,60)">7</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,70)">8</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,80)">9</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,90)">10</a></li>
     * <br>
     *         
     * <br>
     * row10AstartIndex2AtotalCount200ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit03() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 2;
        int totalCount = 200;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,0)\">" +
          "1</a></li>" +
          "<li class=\"active\">2</li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,20)\">" +
          "3</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,30)\">" +
          "4</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,40)\">" +
          "5</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,50)\">" +
          "6</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,60)\">" +
          "7</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,70)\">" +
          "8</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,80)\">" +
          "9</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,90)\">" +
          "10</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:2<br>
     *         () totalCount:50<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,0)">1</a></li>
     * <li class="active">2</li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,20)">3</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,30)">4</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,40)">5</a></li>
     * <br>
     *         
     * <br>
     * row10AstartIndex2AtotalCount200ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit04() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");

        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 2;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,0)\">" +
          "1</a></li>" +
          "<li class=\"active\">2</li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,20)\">" +
          "3</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,30)\">" +
          "4</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,40)\">" +
          "5</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',0,0)">1</a></li>
     * <br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit05() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',0,0)\">" +
          "1</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:-1<br>
     *         () startIndex:-1<br>
     *         () totalCount:-1<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',-1,0)">1</a></li>
     * <br>
     *         
     * <br>
     * row-1AstartIndex-1AtotalCount-1ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit06() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = -1;
        int startIndex = -1;
        int totalCount = -1;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',-1,0)\">" +
          "1</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectSubmit07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:100<br>
     *         () totalCount:130<br>
     *         () submit:true<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,30)">4</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,40)">5</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,50)">6</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,60)">7</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,70)">8</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,80)">9</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,90)">10</a></li>
     * <li>11</li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,110)">12</a></li>
     * <li><a href="#" onclick="return teralib.pageLinkSubmit(
     *        'row','startIndex',10,120)">13</a></li>
     * <br>
     *         
     * <br>
     * row10AstartIndex100AtotalCount130ŁA
     * directLinkNo"10"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectSubmit07() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "submit", true);
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "10");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 100;
        int totalCount = 130;
    
        // eXg{
        pageLinksTagEx.addDirectSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,30)\">" +
          "4</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,40)\">" +
          "5</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,50)\">" +
          "6</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,60)\">" +
          "7</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,70)\">" +
          "8</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,80)\">" +
          "9</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,90)\">" +
          "10</a></li>" +
          "<li>11</li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,110)\">" +
          "12</a></li>" +
          "<li><a href=\"#\" onclick=\"return teralib.pageLinkSubmit" +
          "('row','startIndex',10,120)\">" +
          "13</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,30)">
     * Next
     * </a></li>
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit01() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"next\">" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,30)\">" +
            "Next" +
            "</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disable.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="disable">Next</li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit02() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"disable\">Next</li>" ;
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:-1<br>
     *         () startIndex:-1<br>
     *         () totalCount:-1<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',-1,-2)">
     * Next</a></li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit03() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = -1;
        int startIndex = -1;
        int totalCount = -1;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"next\">" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',-1,-2)\">" +
            "Next</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>

     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,30)">
     * Next
     * </a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50AmaxLinksNo1̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit04() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"next\">" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,30)\">" +
            "Next" +
            "</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:55<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=""<br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,30)">
     * Next
     * </a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit05() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 55;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = new String();
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:50<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disable.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="disable">Next</li><br>
     *         
     * <br>
     * row10AstartIndex50AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit06() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 40;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"disable\">Next</li>" ;
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li>
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,30)">
     * Next
     * </a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit07() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li>" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,30)\">" +
            "Next" +
            "</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextSubmit08()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:50<br>
     *         () totalCount:50<br>
     *         () pageJump:true<br>
     *         () name:"pageLinks"<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li>Next</li><br>
     *         
     * <br>
     * row10AstartIndex50AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextSubmit08() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "pageLinks");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 40;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addNextSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
          "<li>Next</li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastSubmit01()
        * <br><br>
        * 
        * (n)<br>
        * <br>
        * ͒lF() sb:""<br>
        *         () row:0<br>
        *         () startIndex:0<br>
        *         () totalCount:0<br>
        *         () maxLinkNo:10<br>
        *         () rowProperty:"row"<br>
        *         () indexProperty:"startIndex"<br>
        *         () vpeB̐ݒ:<br>
        *                pageLinks.last.char=Last<br>
        *                pageLinks.start.disable.tag=<li class="disable"><br>
        *                pageLinks.end.disabe.tag=</li><br><br>
        *         
        * <br>
        * ҒlF(ԕω) sb:
        * <li class="disable">Last</li></ul><br>
        *         
        * <br>
        * row0AstartIndex0AtotalCount0̏ꍇ
        * <br>
        * 
        * @throws Exception ̃\bhŔO
        */
       public void testAddLastSubmit01() throws Exception {
    
           UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
           UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
           UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
           Map<String, String> links = new HashMap<String, String>();
           links.put("last.char", "Last");
           UTUtil.setPrivateField(pageLinksTagEx, "links", links);

           addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
           addProperty("pageLinks.end.disable.tag", "</li>");
           UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
           StringBuilder sb = new StringBuilder();
           int row = 0;
           int startIndex = 0;
           int totalCount = 0;
    
           // eXg{
           pageLinksTagEx.addLastSubmit(sb, row, startIndex, totalCount);
    
           // 
           String result =  
               "<li class=\"disable\">Last</li>" ;
    
           assertEquals(result, sb.toString());
    }

    /**
     * testAddLastSubmit02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () formName:pageLinks<br>
     *         () vpeB̐ݒ:<br>
        *                pageLinks.last.char=Last<br>
        *                pageLinks.start.last.tag=<li class="last"><br>
        *                pageLinks.end.last.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="last">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,40)">
     * Last</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastSubmit02() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "formName", "pageLinks");
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.last.tag", "<li class=\"last\">");
        addProperty("pageLinks.end.last.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addLastSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"last\">" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,40)\">" +
            "Last" +
            "</a></li>" ;
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastSubmit03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.last.char=Last<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next">
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,40)">
     * Last</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastSubmit03() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addLastSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li class=\"next\">" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,40)\">" +
            "Last" +
            "</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastSubmit04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.last.char=Last<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li>
     * <a href="#" onclick="return teralib.pageLinkSubmit('row','startIndex',10,40)">
     * Last</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastSubmit04() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addLastSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = 
            "<li>" +
            "<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('row','startIndex',10,40)\">" +
            "Last" +
            "</a></li>";
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastSubmit05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.last.char=""<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:Ȃ<br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastSubmit05() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addLastSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = new String();
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastSubmit06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:Ȃ
     *         
     * <br>
     * ҒlF(ԕω) sb:Ȃ<br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastSubmit06() throws Exception {
    
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
    
        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
    
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;
    
        // eXg{
        pageLinksTagEx.addLastSubmit(sb, row, startIndex, totalCount);
    
        // 
        String result = new String();
    
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstLink01()
     * <br><br>
     * 
     * (n) <br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disabe.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <ul><br>
     *            <li class="disable">First</li><br>
     *            <li class="disable">Prev</li>
     * <br>
     * row10AstartIndex0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstLink01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 0;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addFirstLink(sb, row, startIndex, totalCount);

        // 
        String result =
          "<li class=\"disable\">First</li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstLink02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.first.tag=<li class="first"><br>
     *                pageLinks.end.first.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="first">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">
     *            First</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstLink02() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.first.tag", "<li class=\"first\">");
        addProperty("pageLinks.end.first.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addFirstLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li class=\"first\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0\">" +
          "First" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstLink03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="prev">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0">
     *            First</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstLink03() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");

        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addFirstLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li class=\"prev\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0\">" +
          "First" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstLink04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.first.char=First<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li>
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0">
     *            First</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstLink04() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");

        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "First");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addFirstLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0\">" +
          "First" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstLink05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:
     *                pageLinks.first.char=""<br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: ""<br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstLink05() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");

        Map<String, String> links = new HashMap<String, String>();
        links.put("first.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addFirstLink(sb, row, startIndex, totalCount);

        // 
        String result = "";

        assertEquals(result, sb.toString());
    }

    /**
     * testAddFirstLink06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: ""<br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddFirstLink06() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");
        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addFirstLink(sb, row, startIndex, totalCount);

        // 
        String result = "";

        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevLink01()
     * <br><br>
     * 
     * (n) <br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb:
     *            <li class="disable">Prev</li>
     * <br>
     * row10AstartIndex0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 0;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result =
          "<li class=\"disable\">Prev</li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevLink02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="first">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">
     *            First</a></li><br>
     *            <li class="prev">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">
     *            Prev</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink02() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li class=\"prev\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0\">" +
          "Prev" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevLink03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:-1<br>
     *         () startIndex:-1<br>
     *         () totalCount:-1<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="disable">First</li>
     *            <li class="prev">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=0">
     *            Prev</a></li>
     * <br>
     * row-1AstartIndex-1̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink03() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = -1;
        int startIndex = -1;
        int totalCount = -1;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result =
          "<li class=\"prev\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=0\">" +
          "Prev"+
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.prev.tag=<li class="prev"><br>
     *                pageLinks.end.prev.tag=</li><br><br>
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="prev">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">
     *            Prev</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink04() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(1));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result =
          "<li class=\"prev\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=10\">" +
          "Prev" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevLink05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:30<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=""<br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb:Ȃ<br>
     * <br>
     * row10AstartIndex10AtotalCount30̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink05() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(1));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 30;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result = new String();
        
        assertEquals(result, sb.toString());

    }

    /**
     * testAddPrevLink06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:30<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0">
     *            Prev
     *            </a><br>
     * <br>
     * row10AstartIndex10AtotalCount30̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink06() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.prev.tag", "<li class=\"prev\">");
        addProperty("pageLinks.end.prev.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 30;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li class=\"prev\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0\">" +
          "Prev" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevLink07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:30<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li>
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">
     *            Prev</a></li><br>
     * <br>
     * row10AstartIndex10AtotalCount30̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink07() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 30;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0\">" +
          "Prev" +
          "</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddPrevSubmit08()
     * <br><br>
     * 
     * (n) <br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:100<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.prev1.char=Prev<br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li>Prev</li><br>
     * <br>
     * row10AstartIndex0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddPrevLink08() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");

        Map<String, String> links = new HashMap<String, String>();
        links.put("prev1.char", "Prev");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 0;
        int totalCount = 100;

        // eXg{
        pageLinksTagEx.addPrevLink(sb, row, startIndex, totalCount);

        // 
        String result = "Prev";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:100<br>
     *         () totalCount:130<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30">4</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">5</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50">6</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60">7</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70">8</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80">9</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90">10</a></li>
     * <li class="active">11</li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=110">12</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=120">13</a></li>
     * <br>
     * row10AstartIndex100AtotalCount130ŁA
     * directLinkNo"10"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "10");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 100;
        int totalCount = 130;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">4</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40\">5</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50\">6</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60\">7</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70\">8</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80\">9</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90\">10</a></li>" +
          "<li class=\"active\">11</li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=110\">12</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=120\">13</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink02()
     * <br><br>
     * 
     * (n) <br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:100<br>
     *         () totalCount:200<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"a"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50">6</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60">7</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70">8</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80">9</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90">10</a></li>
     * <li class="active">11</li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=110">12</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=120">13</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=130">14</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=140">15</a></li>
     * <br>
     * row10AstartIndex100AtotalCount200ŁA
     * directLinkNo"a"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink02() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "a");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 100;
        int totalCount = 200;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50\">6</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60\">7</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70\">8</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80\">9</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90\">10</a></li>" +
          "<li class=\"active\">11</li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=110\">12</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=120\">13</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=130\">14</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=140\">15</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:2<br>
     *         () totalCount:200<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"a"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">1</a></li>
     * <li class="active">2</li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=20">3</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30">4</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">5</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50">6</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60">7</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70">8</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80">9</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90">10</a></li>
     * <br>
     * row10AstartIndex2AtotalCount200ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink03() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 2;
        int totalCount = 200;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0\">1</a></li>" +
          "<li class=\"active\">2</li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=20\">3</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">4</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40\">5</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50\">6</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60\">7</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70\">8</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80\">9</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90\">10</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:2<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):10<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0">1</a></li>
     * <li class="active">2</li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=20">3</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30">4</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">5</a></li>
     * <br>
     * row10AstartIndex2AtotalCount50ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink04() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.active.tag", "<li class=\"active\">");
        addProperty("pageLinks.end.active.tag", "</li>");
        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 2;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result =
            "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=0\">1</a></li>" +
            "<li class=\"active\">2</li>" +
            "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=20\">3</a></li>" +
            "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">4</a></li>" +
            "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40\">5</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):10<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=0&startIndex=0">1</a></li>
     * <br>
     * row0AstartIndex0AtotalCount0ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink05() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result =
            "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=0&startIndex=0\">1</a></li>";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:-1<br>
     *         () startIndex:-1<br>
     *         () totalCount:-1<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):10<br>
     *                ivpeBmaxDirectLinkCount̒l
     *                l擾łAftHg̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=0">1</a></li>
     * <br>
     * row-1AstartIndex-1AtotalCount-1ŁAdirectLinkNonull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink06() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = -1;
        int startIndex = -1;
        int totalCount = -1;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result =
            "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=0\">1</a></li>";
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:10<br>
     *         () totalCount:30<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1&"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0">1</a>
     * 2
     * <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=20">3</a>
     * <br>
     * row10AstartIndex10AtotalCount30ŁA
     * directLinkNo"10"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink07() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "10");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 10;
        int totalCount = 30;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=0\">1</a>" +
          "2" +
          "<a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=20\">3</a>"; 
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddDirectLink08()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:100<br>
     *         () totalCount:130<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () directLinkNo<br>
     *                (maxPageCount):"10"<br>
     *                ivpeB擾maxDirectLinkCount̒lj<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30">4</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">5</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50">6</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60">7</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70">8</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80">9</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90">10</a></li>
     * <li>11</li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=110">12</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=120">13</a></li>
     * <br>
     * row10AstartIndex100AtotalCount130ŁA
     * directLinkNo"10"w肳ꂽꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddDirectLink08() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");

        Map<String, String> links = new HashMap<String, String>();
        links.put(String.valueOf(UTUtil.getPrivateField(pageLinksTagEx, "MAX_DSP_SIZE")), "10");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 100;
        int totalCount = 130;

        // eXg{
        pageLinksTagEx.addDirectLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">4</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40\">5</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=50\">6</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=60\">7</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=70\">8</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=80\">9</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=90\">10</a></li>" +
          "<li>11</li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=110\">12</a></li>" +
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=120\">13</a></li>";
        
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next"><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30">Next</a></li>
     * <li class="last"><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">Last</a></li><br>
     * </ul>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);

        // 
        String result = 
          "<li class=\"next\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">" +
          "Next"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disabe.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="disable">Next</li>
     * <li class="disable">Last</li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink02() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li class=\"disable\">Next</li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:-1<br>
     *         () startIndex:-1<br>
     *         () totalCount:-1<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next"><a href="/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=-2">Next</a></li><br>
     *         
     * <br>
     * row-1AstartIndex-1AtotalCount-1̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink03() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = -1;
        int startIndex = -1;
        int totalCount = -1;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li class=\"next\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=-2\">" +
          "Next"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:1<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.next.tag=<li class="next"><br>
     *                pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="next"><a href="/terasoluna-pagelinks-tag/testAction.do?row=-1&startIndex=-2">Next</a></li>
     *         
     * <br>
     * row-1AstartIndex-1AtotalCount-1̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink04() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li class=\"next\"><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">" +
          "Next"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=""<br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:Ȃ<br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink05() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = new String();
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=30">Next</a><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink06() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=30\">" +
          "Next" +
          "</a>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink07()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30">Next</a></li>
     * <li><a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">Last</a></li><br>
     *         
     * <br>
     * row10AstartIndex20AtotalCount50̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink07() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");


        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=30\">" +
          "Next"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddNextLink08()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.next1.char=Next<br>
     *                pageLinks.start.page.tag=<li><br>
     *                pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li>Next</li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddNextLink08() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("next1.char", "Next");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;

        // eXg{
        pageLinksTagEx.addNextLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li>Next</li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastLink01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:0<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () maxLinkNo:10<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.last.char=Last<br>
     *                pageLinks.start.disable.tag=<li class="disable"><br>
     *                pageLinks.end.disabe.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     * <li class="disable">Last</li><br>
     *         
     * <br>
     * row0AstartIndex0AtotalCount0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastLink01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.disable.tag", "<li class=\"disable\">");
        addProperty("pageLinks.end.disable.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 0;
        int startIndex = 0;
        int totalCount = 0;

        // eXg{
        pageLinksTagEx.addLastLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li class=\"disable\">Last</li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastLink02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                pageLinks.last.char=Last<br>
     *                pageLinks.start.last.tag=<li class="last"><br>
     *                pageLinks.end.last.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="last">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40">
     *            Last</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastLink02() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.last.tag", "<li class=\"last\">");
        addProperty("pageLinks.end.last.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addLastLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li class=\"last\">" +
          "<a href=\"/terasoluna-pagelinks-tag/testAction.do?row=10&startIndex=40\">" +
          "Last"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastLink03()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                :pageLinks.last.char=Last<br>
     *                 pageLinks.start.next.tag=<li class="next"><br>
     *                 pageLinks.end.next.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li class="next">
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=40">
     *            Last</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastLink03() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.next.tag", "<li class=\"next\">");
        addProperty("pageLinks.end.next.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addLastLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li class=\"next\">" +
          "<a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=40\">" +
          "Last"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastLink04()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                :pageLinks.last.char=Last<br>
     *                 pageLinks.start.page.tag=<li><br>
     *                 pageLinks.end.page.tag=</li><br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: <li>
     *            <a href="/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=40">
     *            Last</a></li><br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastLink04() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "Last");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        addProperty("pageLinks.start.page.tag", "<li>");
        addProperty("pageLinks.end.page.tag", "</li>");
        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addLastLink(sb, row, startIndex, totalCount);
        
        // 
        String result = 
          "<li><a href=\"/terasoluna-pagelinks-tag/testAction.do?no=1&row=10&startIndex=40\">" +
          "Last"+
          "</a></li>";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastLink05()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:<br>
     *                :pageLinks.last.char=""<br><br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: ""<br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastLink05() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        Map<String, String> links = new HashMap<String, String>();
        links.put("last.char", "");
        UTUtil.setPrivateField(pageLinksTagEx, "links", links);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addLastLink(sb, row, startIndex, totalCount);
        
        // 
        String result = "";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddLastLink06()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:20<br>
     *         () totalCount:50<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do?no=1"<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () vpeB̐ݒ:Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω)<br>
     *        sb: ""<br>
     * <br>
     * row10AstartIndex10̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddLastLink06() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do?no=1");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "maxLinkNo", new Integer(10));
        TagUTUtil.setContextPath(pageLinksTagEx, "");

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();
        int row = 10;
        int startIndex = 20;
        int totalCount = 50;

        // eXg{
        pageLinksTagEx.addLastLink(sb, row, startIndex, totalCount);
        
        // 
        String result = "";
          
        assertEquals(result, sb.toString());
    }

    /**
     * testAddJumpFormJS01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () pageJump:true<br>
     *         () pageContextPAGEJUMP_JAVASCRIPT_KEY̒l:false<br>
     *         
     * <br>
     * ҒlF(ԕω) writer:
     *                    <bt>
     *                    <script type=\"text/javascript\"><br>
     *                    <!--<br>
     *                      if(typeof(teralib) === \"undefined\"){<br>
     *                        teralib = {};<br>
     *                      }<br>
     *                      teralib.pageLinkJump = function(form, row, indexProperty){<br>
     *                        var jump = form.elements['jumpIndex'];<br>
     *                        var index = form.elements[indexProperty];<br>
     *                        var idx;<br>
     *                        var jumpValue = parseInt(jump.value,10);<br>
     *                        if( jumpValue == " + pageIndex + " ){<br>
     *                          return false;<br>
     *                        } else if( 0 < jumpValue ){<br>
     *                          idx = (jumpValue -1) * " + row + ";<br>
     *                          index.value = idx;<br>
     *                          return true;<br>
     *                        } else {<br>
     *                          return false;<br>
     *                        }<br>
     *                      }<br>
     *                    // --><br>
     *                    </script><br>
     *                   <br>
     *         (ԕω) pageContextPAGEJUMP_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * y[WReLXg̃tOfalsȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddJumpFormJS01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY, false);

        int row = 10;
        int startIndex = 0;
        int totalCount = 0;

        // eXg{
        pageLinksTagEx.addJumpFormJS(row, startIndex, totalCount);

        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertEquals("", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("  if(typeof(teralib) === \"undefined\"){", reader.readLine());
        assertEquals("    teralib = {};", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("  teralib.pageLinkJump = function(form, row, indexProperty){", reader.readLine());
        assertEquals("    var jump = form.elements['jumpIndex'];", reader.readLine());
        assertEquals("    var index = form.elements[indexProperty];", reader.readLine());
        assertEquals("    var idx;", reader.readLine());
        assertEquals("    var jumpValue = parseInt(jump.value,10);", reader.readLine());
        assertEquals("    if( jumpValue == 0 ){", reader.readLine());
        assertEquals("      return false;", reader.readLine());
        assertEquals("    } else if( 0 < jumpValue ){", reader.readLine());
        assertEquals("      idx = (jumpValue -1) * " + row + ";", reader.readLine());
        assertEquals("      index.value = idx;", reader.readLine());
        assertEquals("      return true;", reader.readLine());
        assertEquals("    } else {", reader.readLine());
        assertEquals("      return false;", reader.readLine());
        assertEquals("    }", reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("// -->", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertNull(reader.readLine());
        Boolean bol =(Boolean) pageContext.getAttribute(
                PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY);
        assertTrue(bol);
    }

    /**
     * testAddJumpFormJS02()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () pageJump:true<br>
     *         () pageContextPAGEJUMP_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * ҒlF(ԕω) JspWriter:o͂Ȃ<br>
     *         (ԕω) pageContextPAGEJUMP_JAVASCRIPT_KEY̒l:true<br>
     *         
     * <br>
     * y[WReLXg̃tOtruȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddJumpFormJS02() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY, true);

        int row = 10;
        int startIndex = 0;
        int totalCount = 0;

        // eXg{
        pageLinksTagEx.addJumpFormJS(row, startIndex, totalCount);

        // 
        BufferedReader reader = TagUTUtil.getOutputReader(pageLinksTagEx);
        assertNull(reader.readLine());

        Boolean bol =(Boolean) pageContext.getAttribute(
                PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY);
        assertTrue(bol);
    }

    /**
     * testAddJumpFormJS03()
     * <br><br>
     * 
     * (ُn)<br>
     * <br>
     * ͒lF() row:10<br>
     *         () startIndex:0<br>
     *         () totalCount:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"index"<br>
     *         () forward:true<br>
     *         () resetIndex:true<br>
     *         () pageJump:true<br>
     *         () formName:pageLinks<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {event̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {rowProperty̒l:false<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {indexProperty̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY {"resetIndex"̒l:true<br>
     *         () pageContextPAGELINKS_JAVASCRIPT_KEY̒l:true<br>
     *         () JspWriter#println():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOF-<br>
     *         
     * <br>
     * JspWriterIOExceptionꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddJumpFormJS03() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY, false);

        ActionMapping mapping = new ActionMapping();
        mapping.setName("pageLinks");
        pageContext.getRequest().setAttribute(Globals.MAPPING_KEY, mapping);

        int row = 10;
        int startIndex = 0;
        int totalCount = 0;

        // eXgpJspWriter̐
        Exception_JspWriterImpl out =
            new Exception_JspWriterImpl();
        out.setTrue();

        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pageContext, "jspWriter", out);

        // eXg{
        try {
            pageLinksTagEx.addJumpFormJS(row, startIndex, totalCount);
            fail();
        } catch (JspException e) {
            // 
            if (e.getMessage().indexOf("IOException") == -1) {
                //ʊmF
                fail();
            }
        }
    }
    /**
     * testAddJumpForm01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() sb:""<br>
     *         () row:10<br>
     *         () startIndex:0<br>
     *         () rowProperty:"row"<br>
     *         () indexProperty:"startIndex"<br>
     *         () pageJump:true<br>
     *         () url:"/terasoluna-pagelinks-tag/testAction.do"<br>
     *         () name:"pageLinks"<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:
     *                    <form name="pageLinks" method="post"<br>
     *                     action="/terasoluna-pagelinks-tag/testAction.do" onsubmit=<br>
     *                    "return teralib.pageJumpForm(this, 10,,'startIndex')"/><br>
     *                    <input type="hidden" name="row" value="10"/><br>
     *                    <input type="hidden" name="startIndex"/><br>
     *                    <input type="text" name="jumpIndex"/><br>
     *                    <input type="submit" value="submit"/><br>
     *                    </form><br>
     *         
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testAddJumpForm01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "row");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "startIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "url", "/terasoluna-pagelinks-tag/testAction.do");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "pageLinks");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));

        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(pageLinksTagEx);
        pageContext.setAttribute(PageLinksTagEx.PAGEJUMP_JAVASCRIPT_KEY, false);

        UTUtil.invokePrivate(pageLinksTagEx, "initTagProperty");

        StringBuilder sb = new StringBuilder();

        // eXg{
        pageLinksTagEx.addJumpForm(sb, 10, 0);

        // 
        String result = 
            "<form name=\"pageLinks\" method=\"post\"" +
            " action=\"/terasoluna-pagelinks-tag/testAction.do\" onsubmit=" +
            "\"return teralib.pageLinkJump(this, 10,'startIndex')\"/>" +
            "<input type=\"hidden\" name=\"row\" value=\"10\"/>" +
            "<input type=\"hidden\" name=\"startIndex\"/>" +
            "<input type=\"text\" name=\"jumpIndex\" />" +
            "<input type=\"submit\" value=\"submit\" />" +
            "</form>";
   
        assertEquals(result, sb.toString());
        
    }

    /**
     * testAppendIfNotEmpty01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () value:""<br>
     *         () defaultValue:null<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:""<br>
     *         
     * <br>
     * value""AdefaultValluenull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAppendIfNotEmpty01() throws Exception {

        StringBuilder sb = new StringBuilder();
        String value = "";
        String defaultValue = null;

        // eXg{
        UTUtil.invokePrivate(pageLinksTagEx,
                             "appendIfNotEmpty",
                             new Class[] { StringBuilder.class, String.class, String.class},
                             new Object[] { sb, value, defaultValue});

        // 
        String result = "" ;
   
        assertEquals(result, sb.toString());
    }

    /**
     * testAppendIfNotEmpty02()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() sb:""<br>
     *         () value1:""<br>
     *         () value2:""<br>
     *         () defaultValue:null<br>
     *         
     * <br>
     * ҒlF(ԕω) sb:""<br>
     *         
     * <br>
     * value1""Avalue2""AdefaultValluenull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAppendIfNotEmpty02() throws Exception {

        StringBuilder sb = new StringBuilder();
        String value1 = "";
        String value2 = "";
        String defaultValue = null;

        // eXg{
        UTUtil.invokePrivate(pageLinksTagEx,
                             "appendIfNotEmpty",
                             new Class[] { StringBuilder.class, String.class,
                                           String.class, String.class},
                             new Object[] { sb, value1, value2, defaultValue});

        // 
        String result = "" ;
   
        assertEquals(result, sb.toString());
    }

    /**
     * testGetLinkProperty01()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:L[Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:0<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[݂ȂꍇA
     * links֒lݒ肳ĂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty01() throws Exception {
        //eXgf[^ݒ
        deleteProperty("pageLinks.");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(0, links2.size());
        assertEquals(1, maxLinkNo2.intValue());
    }

    /**
     * testGetLinkProperty02()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:0<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L["pageLinks."̏ꍇA
     * links֒lݒ肳ĂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty02() throws Exception {
        //eXgf[^ݒ
        addProperty("pageLinks.","&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(0, links2.size());
        assertEquals(1, maxLinkNo2.intValue());
    }

    /**
     * testGetLinkProperty03()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.prev1.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    prev1.char=&lt;<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂ꍇA
     * links֒l1ݒ肳A"maxLinkNo"Ɂu1vݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty03() throws Exception {
        //eXgf[^ݒ
        addProperty("pageLinks.prev1.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
        assertEquals("&lt;", (String) links2.get("prev1.char"));
    }

    /**
     * testGetLinkProperty04()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.prev2.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    prev2.char=&lt;<br>
     *         (ԕω) maxLinkNo:2<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂ꍇA
     * links֒l1ݒ肳A"maxLinkNo"Ɂu2vݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty04() throws Exception {
        addProperty("pageLinks.prev2.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(2, maxLinkNo2.intValue());
        assertEquals("&lt;", (String) links2.get("prev2.char"));
    }

    /**
     * testGetLinkProperty05()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.prev-2.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    prev-2.char=&lt;<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂ꍇA
     * links֒l1ݒ肳A"maxLinkNo"Ɂu1vݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty05() throws Exception {
        addProperty("pageLinks.prev-2.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
        assertEquals("&lt;", (String) links2.get("prev-2.char"));
    }

    /**
     * testGetLinkProperty06()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.next1.char=&gt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    next1.char=&gt;<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂ꍇA
     * links֒l1ݒ肳A"maxLinkNo"Ɂu1vݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty06() throws Exception {
        addProperty("pageLinks.next1.char", "&gt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
        assertEquals("&gt;", (String) links2.get("next1.char"));
    }

    /**
     * testGetLinkProperty07()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.test.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:0<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂邪L[
     * wȌꍇAlinks֒lݒ肳ĂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty07() throws Exception {
        addProperty("pageLinks.test.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(0, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
    }

    /**
     * testGetLinkProperty08()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.nexttest.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:0<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂邪L[
     * y[WWv̎w肪̏ꍇA
     * links֒lݒ肳ĂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty08() throws Exception {
        addProperty("pageLinks.nexttest.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(0, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
    }

    /**
     * testGetLinkProperty09()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.prev1.char=&lt;<br>
     *                pageLinks.prev2.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:2<br>
     *                    prev1.char=&lt;<br>
     *                    prev2.char=&lt;<br>
     *         (ԕω) maxLinkNo:2<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[2݂ꍇA
     * links֒l2ݒ肳A"maxLinkNo"Ɂu2vݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty09() throws Exception {
        addProperty("pageLinks.prev1.char", "&lt;");
        addProperty("pageLinks.prev2.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(2, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(2, maxLinkNo2.intValue());
        assertEquals("&lt;", (String) links2.get("prev1.char"));
        assertEquals("&lt;", (String) links2.get("prev2.char"));
    }

    /**
     * testGetLinkProperty10()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.maxDirectLinkCount=3<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    maxDirectLinkCount=3<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CpageLinks.maxDirectLinkCount=3w肳ꂽ
     * ꍇ̃eXgP[XB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty10() throws Exception {
        addProperty("pageLinks.maxDirectLinkCount", "3");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
        assertEquals("3", (String) links2.get("maxDirectLinkCount"));
    }

    /**
     * testGetLinkProperty11()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.maxDirectLinkCount=0<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    maxDirectLinkCount=0<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CpageLinks.maxDirectLinkCount=0
     * w肳ꂽꍇ̃eXgP[XB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty11() throws Exception {
        addProperty("pageLinks.maxDirectLinkCount", "0");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
        assertEquals("0", (String) links2.get("maxDirectLinkCount"));
    }

    /**
     * testGetLinkProperty12()
     * <br><br>
     * (n)<br>
     * <br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.maxDirectLinkCount=-1<br>
     *         
     * <br>
     * ҒlF(ԕω) links:size:1<br>
     *                    maxDirectLinkCount=-1<br>
     *         (ԕω) maxLinkNo:1<br>
     *         
     * <br>
     * propertyt@CpageLinks.maxDirectLinkCount=-1
     * w肳ꂽꍇ̃eXgP[XB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty12() throws Exception {
        addProperty("pageLinks.maxDirectLinkCount", "-1");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals(1, links2.size());
        Integer maxLinkNo2 =
            (Integer) UTUtil.getPrivateField(pageLinksTagEx, "maxLinkNo");
        assertEquals(1, maxLinkNo2.intValue());
        assertEquals("-1", (String) links2.get("maxDirectLinkCount"));
    }

    /**
     * testGetLinkProperty13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.first.char=&lt;<br>
     *         
     * <br>
     * ҒlF(ԕω) first.char=&lt;<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂ꍇA
     * links֒l1ݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty13() throws Exception {
        //eXgf[^ݒ
        addProperty("pageLinks.first.char", "&lt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals("&lt;", (String) links2.get("first.char"));
    }

    /**
     * testGetLinkProperty14()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propertyt@Cɐݒ肷PAGE_LINKS_PREFIX:
     * pageLinks.last.char=&gt;<br>
     *         
     * <br>
     * ҒlF(ԕω) last.char=&gt;<br>
     *         
     * <br>
     * propertyt@CPAGE_LINKS_PREFIX̃L[1݂ꍇA
     * links֒l1ݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLinkProperty14() throws Exception {
        //eXgf[^ݒ
        addProperty("pageLinks.last.char", "&gt;");

        //eXgs
        UTUtil.invokePrivate(pageLinksTagEx, "getLinkProperty");

        //eXgʊmF
        Map<String, String> links2 = (Map) UTUtil.getPrivateField(pageLinksTagEx, "links");
        assertEquals("&gt;", (String) links2.get("last.char"));
    }

    /**
     * testRelease01()
     * <br><br>
     * 
     * (n)<br>
     * <br>
     * ͒lF() super.parent:new TagSupport()<br>
     *         () action:"action"<br>
     *         () name:"name"<br>
     *         () rowProperty:"rowProperty"<br>
     *         () indexProperty:"indexProperty"<br>
     *         () totalProperty:"totalProperty"<br>
     *         () scope:"scope"<br>
     *         () submit:true<br>
     *         () forward:true<br>
     *         () event:"abc"<br>
     *         () resetIndex:true<br>
     * <br>
     *         () startPageLinksTag:"startPageLinksTag"<br>
     *         () endPageLinksTag:"endPageLinksTag"<br>
     *         () startPageTag:"startPageTag"<br>
     *         () endPageTag:"endPageTag"<br>
     *         () startPrevTag:"startPrevTag"<br>
     *         () endPrevTag:"endPrevTag"<br>
     *         () startNextTag:"startNextTag"<br>
     *         () endNextTag:"endNextTag"<br>
     *         () startFirstTag:"startFirstTag"<br>
     *         () endFirstTag:"endFirstTag"<br>
     *         () startLastTag:"startLastTag"<br>
     *         () endLastTag:"endLastTag"<br>
     *         () startActiveTag:"startActiveTag"<br>
     *         () endActiveTag:"endActiveTag"<br>
     *         () startDisableTag:"startDisableTag"<br>
     *         () endDisableTag:"endDisableTag"<br>
     *         () startJumpFormTag:"startJumpFormTag"<br>
     *         () endJumpFormTag:"endJumpFormTag"<br>
     *         () jumpFormTextAttributes:"jumpFormTextAttributes"<br>
     *         () jumpFormSubmitAttributes:"jumpFormSubmitAttributes"<br>
     *         () jumpFormSubmitValue:"jumpFormSubmitValue"<br>
     *         () url:"url"<br>
     *         () pageJump:true<br>
     *         
     * <br>
     * ҒlF(ԕω) super.parent:null<br>
     *         (ԕω) action:null<br>
     *         (ԕω) name:null<br>
     *         (ԕω) rowProperty:null<br>
     *         (ԕω) indexProperty:null<br>
     *         (ԕω) totalProperty:null<br>
     *         (ԕω) scope:null<br>
     *         (ԕω) submit:false<br>
     *         (ԕω) forward:false<br>
     *         (ԕω) event:PageLinksTag.DEFAULT_EVENT<br>
     *         (ԕω) resetIndex:false<br>
     * <br>
     *         (ԕω) startPageLinksTag:null<br>
     *         (ԕω) endPageLinksTag:null<br>
     *         (ԕω) startPageTag:null<br>
     *         (ԕω) endPageTag:null<br>
     *         (ԕω) startPrevTag:null<br>
     *         (ԕω) endPrevTag:null<br>
     *         (ԕω) startNextTag:null<br>
     *         (ԕω) endNextTag:null<br>
     *         (ԕω) startFirstTag:null<br>
     *         (ԕω) endFirstTag:null<br>
     *         (ԕω) startLastTag:null<br>
     *         (ԕω) endLastTag:null<br>
     *         (ԕω) startActiveTag:null<br>
     *         (ԕω) endActiveTag:null<br>
     *         (ԕω) startDisableTag:null<br>
     *         (ԕω) endDisableTag:null<br>
     *         (ԕω) startJumpFormTag:null<br>
     *         (ԕω) endJumpFormTag:null<br>
     *         (ԕω) jumpFormTextAttributes:null<br>
     *         (ԕω) jumpFormSubmitAttributes:null<br>
     *         (ԕω) jumpFormSubmitValue:PageLinksTagEx.JUMPFORM_SUBMIT_DEFAULT<br>
     *         (ԕω) url:null<br>
     *         (ԕω) pageJump:false<br>
     * <br>
     * n̂݁B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRelease01() throws Exception {

        UTUtil.setPrivateField(pageLinksTagEx, "parent", new TagSupport());
        UTUtil.setPrivateField(pageLinksTagEx, "id", "id");
        UTUtil.setPrivateField(pageLinksTagEx, "action", "action");
        UTUtil.setPrivateField(pageLinksTagEx, "name", "name");
        UTUtil.setPrivateField(pageLinksTagEx, "rowProperty", "rowProperty");
        UTUtil.setPrivateField(pageLinksTagEx, "indexProperty", "indexProperty");
        UTUtil.setPrivateField(pageLinksTagEx, "totalProperty", "totalProperty");
        UTUtil.setPrivateField(pageLinksTagEx, "scope", "scope");
        UTUtil.setPrivateField(pageLinksTagEx, "submit",  new Boolean(true));
        UTUtil.setPrivateField(pageLinksTagEx, "forward",  new Boolean(true));
        UTUtil.setPrivateField(pageLinksTagEx, "event", "event");
        UTUtil.setPrivateField(pageLinksTagEx, "resetIndex",  new Boolean(true));
        UTUtil.setPrivateField(pageLinksTagEx, "currentPageIndex", "currentPageIndex");
        UTUtil.setPrivateField(pageLinksTagEx, "totalPageCount", "totallPageCount");

        UTUtil.setPrivateField(pageLinksTagEx, "startPageLinksTag", "startPageLinksTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endPageLinksTag", "endPageLinksTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startPageTag", "startPageTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endPageTag", "endPageTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startPrevTag", "startPrevTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endPrevTag", "endPrevTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startNextTag", "startNextTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endNextTag", "endNextTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startFirstTag", "startFirstTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endFirstTag", "endFirstTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startLastTag", "startLastTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endLastTag", "endLastTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startActiveTag", "startActiveTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endActiveTag", "endActiveTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startDisableTag", "startDisableTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endDisableTag", "endDisableTag");
        UTUtil.setPrivateField(pageLinksTagEx, "startJumpFormTag", "startJumpFormTag");
        UTUtil.setPrivateField(pageLinksTagEx, "endJumpFormTag", "endJumpFormTag");
        UTUtil.setPrivateField(pageLinksTagEx, "jumpFormTextAttributes", "jumpFormTextAttributes");
        UTUtil.setPrivateField(pageLinksTagEx, "jumpFormSubmitAttributes", "jumpFormSubmitAttributes");
        UTUtil.setPrivateField(pageLinksTagEx, "jumpFormSubmitValue", "jumpFormSubmitValue");
        UTUtil.setPrivateField(pageLinksTagEx, "url", "url");
        UTUtil.setPrivateField(pageLinksTagEx, "pageJump", new Boolean(true));

        // eXg{
        pageLinksTagEx.release();

        // 
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "parent"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "id"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "action"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "name"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "rowProperty"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "indexProperty"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "totalProperty"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "scope"));
        assertFalse(((Boolean)UTUtil.getPrivateField(
                pageLinksTagEx, "submit")).booleanValue());
        assertFalse(((Boolean)UTUtil.getPrivateField(
                pageLinksTagEx, "forward")).booleanValue());
        assertEquals(UTUtil.getPrivateField(pageLinksTagEx, "DEFAULT_EVENT"), 
                UTUtil.getPrivateField(pageLinksTagEx, "event"));
        assertFalse(((Boolean)UTUtil.getPrivateField(
                pageLinksTagEx, "resetIndex")).booleanValue());
        assertEquals(UTUtil.getPrivateField(pageLinksTagEx, "CURRENT_PAGE_INDEX"), 
                UTUtil.getPrivateField(pageLinksTagEx, "currentPageIndex"));
        assertEquals(UTUtil.getPrivateField(pageLinksTagEx, "TOTAL_PAGE_COUNT"), 
                UTUtil.getPrivateField(pageLinksTagEx, "totalPageCount"));

        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startPageLinksTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endPageLinksTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startPageTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endPageTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startPrevTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endPrevTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startNextTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endNextTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startFirstTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endFirstTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startLastTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endLastTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startActiveTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endActiveTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startDisableTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endDisableTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "startJumpFormTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "endJumpFormTag"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "jumpFormTextAttributes"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "jumpFormSubmitAttributes"));
        assertNull(UTUtil.getPrivateField(pageLinksTagEx, "url"));
        assertFalse(((Boolean)UTUtil.getPrivateField(
                pageLinksTagEx, "pageJump")).booleanValue());
        assertEquals(UTUtil.getPrivateField(pageLinksTagEx, "JUMPFORM_SUBMIT_DEFAULT"), 
                UTUtil.getPrivateField(pageLinksTagEx, "jumpFormSubmitValue"));
    }

}
