/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import jp.terasoluna.utlib.spring.SpringTestCase;

import com.mockrunner.mock.web.MockPageContext;
import com.mockrunner.mock.web.MockServletConfig;

/**
 * {@link jp.terasoluna.fw.web.taglib.WriteCodeCountTag}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * writeCodeCount ^O̎NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.taglib.WriteCodeCountTag
 */
@SuppressWarnings("unused")
public class WriteCodeCountTagTest extends SpringTestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     *
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
    }

    @Override
    protected void doOnSetUp() throws Exception {

    }

    @Override
    protected String[] getConfigLocations() {
        return new String[] { "jp/terasoluna/fw/web/taglib/WriteCodeCountTagTest.xml" };
    }

    /**
     * testDoStartTag01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() id:""<br>
     *         () out.print:s<br>
     *
     * <br>
     * ҒlF(ԕω) O:JspTagException<br>
     *                    bvOFnull<br>
     *                    bZ[WFid is required<br>
     *         (ԕω) O:OxFerror<br>
     *                    bZ[WFid is required<br>
     *
     * <br>
     * CX^Xϐid󕶎̏ꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag01() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        // id=""
        UTUtil.setPrivateField(tag, "id", "");

        try {
            // eXgs
            int result = tag.doStartTag();
            // 
            fail();

        } catch (JspTagException ex) {
            // 
            // bZ[W`FbN
            assertEquals("id is required.", ex.getMessage());
            // bvO`FbN
            assertNull(ex.getCause());
            // O`FbN
            assertTrue(LogUTUtil.checkError("id is required."));
        }

    }

    /**
     * testDoStartTag02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader02<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans=null<br>
     *         () out.print:s<br>
     *
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) o͓e:"0"<br>
     *         (ԕω) O:OxFwarn<br>
     *                    bZ[WF"Codebean is null. CodeListLoader(bean id:testLoader)"<br>
     *
     * <br>
     * DIRei擾CodeListLoadergetCodeBeansnullԋpꍇAy[W0o͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag02() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        MockPageContext pageContext =
            (MockPageContext) TagUTUtil.getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

        // getCodeBeans=null
        UTUtil.setPrivateField(tag, "id", "testLoader02");

        // eXgs
        int result = tag.doStartTag();
        // 
        // ߂l
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);
        // O`FbN
        assertTrue(LogUTUtil
                .checkWarn("Codebean is null. CodeListLoader(bean id:testLoader02)"));
        // o͓e`FbN
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals("0", reader);
    }

    /**
     * testDoStartTag03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader03<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={}i̔zj<br>
     *         () out.print:s<br>
     *
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) o͓e:"0"<br>
     *
     * <br>
     * DIRei擾CodeListLoadergetCodeBeans̔zԋpꍇAy[W0o͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag03() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        MockPageContext pageContext = (MockPageContext) TagUTUtil
                .getPageContext(tag);

        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);
        // getCodeBeans={}i̔zj
        UTUtil.setPrivateField(tag, "id", "testLoader03");

        // eXgs
        int result = tag.doStartTag();
        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);
        // o͓e`FbN
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals("0", reader);
    }

    /**
     * testDoStartTag04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader04<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={<br>
     *                CodeBean("id","name")<br>
     *                }<br>
     *         () out.print:s<br>
     *
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) o͓e:"1"<br>
     *
     * <br>
     * DIRei擾CodeListLoadergetCodeBeansvf1̔zԋpꍇAy[W1o͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag04() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        MockPageContext pageContext = (MockPageContext) TagUTUtil
                .getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

        // getCodeBeans={CodeBean("id","name")}
        UTUtil.setPrivateField(tag, "id", "testLoader04");

        // eXgs
        int result = tag.doStartTag();
        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);
        // o͓e`FbN
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals("1", reader);
    }

    /**
     * testDoStartTag05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader05<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={<br>
     *                CodeBean("id1","name1"),<br>
     *                CodeBean("id2","name2"),<br>
     *                CodeBean("id3","name3"),<br>
     *                }<br>
     *         () out.print:s<br>
     *
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) o͓e:"3"<br>
     *
     * <br>
     * DIRei擾CodeListLoadergetCodeBeans̗vf̔zԋpꍇAy[Wɗvfo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag05() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        MockPageContext pageContext = (MockPageContext) TagUTUtil
                .getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

        // getCodeBeans={
        //     CodeBean("id1","name1"),
        //     CodeBean("id2","name2"),
        //     CodeBean("id3","name3"),
        // }
        UTUtil.setPrivateField(tag, "id", "testLoader05");

        // eXgs
        int result = tag.doStartTag();
        // 
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);
        // o͓e`FbN
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals("3", reader);
    }

    /**
     * testDoStartTag06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() id:testLoader06<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                CodeListLoaderȂNX̃CX^XB<br>
     *         () out.print:s<br>
     *
     * <br>
     * ҒlF(ԕω) O:JspTagException<br>
     *                    bvOFClassCastException<br>
     *                    bZ[WFbean id:testLoader is not instance of CodeListLoader<br>
     *         (ԕω) O:OxFerror<br>
     *                    bZ[WFbean id:testLoader is not instance of CodeListLoader<br>
     *
     * <br>
     * DIRei擾CX^XCodeListLoaderNX̃CX^Xł͂ȂꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag06() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        MockPageContext pageContext = (MockPageContext) TagUTUtil
                .getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

        // s
        int result = -1;
        // CodeListLoaderȂNX̃CX^XB
        UTUtil.setPrivateField(tag, "id", "testLoader06");
        try {
            // eXgs
            result = tag.doStartTag();
            fail();
        } catch (JspTagException ex) {
            // 
            // bvO`FbN
            assertEquals(ClassCastException.class.getName(),
                    ex.getRootCause().getClass().getName());

            // bZ[WL[`FbN
            assertEquals(
                    "bean id:testLoader06 is not instance of CodeListLoader.",
                    ex.getMessage());
            // O`FbN
            assertTrue(LogUTUtil
                    .checkError("bean id:testLoader06 is not instance of CodeListLoader."));
        }

    }

    /**
     * testDoStartTag07()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() id:testLoader07<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={<br>
     *                CodeBean("id","name")<br>
     *                }<br>
     *         () out.print:IOException<br>
     *
     * <br>
     * ҒlF(ԕω) O:JspTagException<br>
     *                    bvOFnull<br>
     *         (ԕω) O:OxFerror<br>
     *                    bZ[WFIOException caused.<br>
     *
     * <br>
     * JspWriterIOExceptionꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag07() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);
        MockPageContext pageContext = (MockPageContext) TagUTUtil
                .getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pageContext, "jspWriter", out);


        // s
        int result = -1;
        // CodeListLoaderȂNX̃CX^XB
        UTUtil.setPrivateField(tag, "id", "testLoader07");

        try {
            // eXgs
            result = tag.doStartTag();
            fail();
        } catch (JspTagException ex) {
            // 
            // bvO`FbN
            assertNull(ex.getRootCause());
            // O`FbN
            assertTrue(LogUTUtil
                    .checkError("IOException caused."));
        }
    }

    /**
     * testDoEndTag01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_PAGE<br>
     *
     * <br>
     * TagSupport.EVAL_PAGEԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoEndTag01() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);

        // eXg{
        int result = tag.doEndTag();
        // eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
    }

    /**
     * testRelease01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:"id"<br>
     *
     * <br>
     * ҒlF(ԕω) id:null<br>
     *
     * <br>
     * idnullɂȂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRelease01() throws Exception {
        // O
        WriteCodeCountTag tag = null;
        tag = (WriteCodeCountTag) TagUTUtil.create(WriteCodeCountTag.class);

        UTUtil.setPrivateField(tag, "id", "id");

        // eXg{
        tag.release();
        // eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "id"));
    }
}
