/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.Iterator;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.PropertyMessageResources;
import org.apache.struts.util.PropertyMessageResourcesFactory;

/**
 * {@link jp.terasoluna.fw.web.struts.action.SystemExceptionHandler} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * SystemExceptionONXB<br>
 * VXeÕOo͂ G[ʂւ̑JڂsB<br>
 * ANVsɃVXeOƂ́AG[Oo͂ŁAYANV}bsOɒ`ĂVXeG[ʂɑJڂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.SystemExceptionHandler
 */
public class SystemExceptionHandlerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SystemExceptionHandlerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public SystemExceptionHandlerTest(String name) {
        super(name);
    }

    /**
     * testExecute01()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONFnull<br>
     *         
     * <br>
     * ̗OSystemExceptionł͂ȂApathw肳ꂽApathŎw肳ꂽpXANVtH[hɐݒ肳A΃ReLXg[gtrueɐݒ肳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecute01() throws Exception {
        // O
        
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeOł͂ȂO
        Exception e = new Exception();
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");
        
        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();
       
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward  
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        // NGXg̏ԕω̊mF
        assertNull(req.getAttribute(PageContext.EXCEPTION));

    }

    /**
     * testExecute02()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:Exception<br>
     *         () eConfig:not null<br>
     *         () mapping:not null<br>
     *               yinputtB[h"/errorInput.do"ݒ肳Ăz
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorInput.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    Oo^ĂȂƁB<br>
     *         
     * <br>
     * ̗OSystemExceptionł͂ȂAANV}bsOinputw肳ꂽAinputŎw肳ꂽpXANVtH[hɐݒ肳ꑊ΃ReLXg[gtrueɐݒ肳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecute02() throws Exception {
        // O
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeOł͂ȂO
        Exception e = new Exception();
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setKey("action.message.key");
        
        // ANV}bsOInputݒ
        ActionMapping mapping = new ActionMapping();
        mapping.setInput("/errorInput.do");
        
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward  
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorInput.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertNull(req.getAttribute(PageContext.EXCEPTION));
    }

    /**
     * testExecute03()
     * <br><br>
     * 
     * ُn
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:not null<br>
     *               yinputtB[h"/errorInput.do"ݒ肳Ăz
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 SystemExceptionHandlerTest.error.message="ObZ[W"<br>
     *                }<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONFSystemException<br>
     *         (ԕω) se:G[bZ[WF"ObZ[W"<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * OݒpathƁAANV}bsOinputw肳Ă鎞ApathD悳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute03() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message");
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");
        
        // ANV}bsOInputݒ
        ActionMapping mapping = new ActionMapping();
        mapping.setInput("/errorInput.do");
        
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();
        
        // MessageResources̐ݒ
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // NGXgMessageResourceso^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward 
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));
        
        // Ȍԕω̊mF
        assertEquals("ObZ[W", UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }

    /**
     * testExecute04()
     * <br><br>
     * 
     * ُn
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:not null<br>
     *         () mapping:not null<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 SystemExceptionHandlerTest.error.message="ObZ[W"<br>
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hFnull<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF"ObZ[W"<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * OݒpathƁAANV}bsOinputnull̎AANVtH[h̑Jڐ悪nullł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute04() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message");
        
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setKey("action.message.key");
        
        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();
        
        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // NGXgMessageResourcesݒ
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward  
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertNull(forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));

        // VXeȌԕω̊mFB
        assertEquals("ObZ[W", UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }

    /**
     * testExecute05()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:MockActionMapping<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:Globals.MESSAGE_KEY<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 SystemExceptionHandlerTest.error.message ="ObZ[W"<br>
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF"ObZ[W"<br>
     *                    ݒ肳Ă邱ƁB<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * OݒbundleGlobals.MESSAGE_KEY̎AL[Globals.MESSAGE_KEYłMessageResourcesp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute05() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message");
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        // ANVbZ[W̃L[w
        eConfig.setKey("action.message.key");
        // bZ[W\[Xւ̃ohL[w
        eConfig.setBundle(Globals.MESSAGES_KEY);

        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // NGXgMessageResourceso^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));

        // VXeȌԕω̊mF
        assertEquals("ObZ[W", UTUtil.getPrivateField(e, "message"));
        
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }

    /**
     * testExecute06()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:MockActionMapping<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:anotherKey<br>
     *         () resources:yNGXgz<br>
     *               Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *               MessageResourceso<br>
     *                SystemExceptionHandlerTest.error.message ="ObZ[W"<br>
     *               p<br>
     *               anotherKeyŎ擾ĂnullԂĂ<br>
     *               yT[ubgReLXgz<br>
     *               anotherKeyŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *               MessageResourceso<br>
     *                SystemExceptionHandlerTest.error.message ="T[ubgObZ[W"<br>
     *               p<br>
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTION:<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF"T[ubgObZ[W"<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * OݒbundleAT[ubgReLXg̃L[łƂAT[ubgReLXgɊi[ꂽbZ[W\[X<br>
     * p邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute06() throws Exception {
        // O
        
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message");
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        // bZ[W\[Xւ̃ohL[w
        eConfig.setBundle("anotherKey");
        // ANVbZ[W̃L[
        eConfig.setKey("action.message.key");

        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");
        PropertyMessageResources servletResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources02");

        // T[ubgReLXgMessageResourceso^
        context.setAttribute("anotherKey", servletResources);

        // NGXgɃbZ[W\[Xo^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // VXeȌԕω̊mF
        assertEquals("T[ubgObZ[W", 
            UTUtil.getPrivateField(e, "message"));
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
        
    }

    /**
     * testExecute07()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:MockActionMapping<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *               Globals.MESSAGES_KEYŎ擾ĂnullԂĂ<br>
     *               yT[ubgReLXgz<br>
     *               Globals.MESSAGES_KEYŎ擾ĂnullԂĂ<br>
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF"SystemExceptionHandlerTest.error.message"<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    resourcetB[hfalseł
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * bZ[W\[X擾łȂAG[R[hbZ[W̑ɐݒ肳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecute07() throws Exception {
        // O
        
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message");
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");
        
        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();

        // bZ[W\[X͐ݒ肵Ȃ
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward  
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));

        // VXeȌԕω̊mF
        assertEquals("SystemExceptionHandlerTest.error.message",
            UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertFalse(actionMessage.isResource());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }

    /**
     * testExecute08()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:MockActionMapping<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 "aaaaa"ƂbZ[WL[œo^ĂȂ<br>
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF(nullł邱)<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * bZ[W擾łȂAnullݒ肳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute08() throws Exception {
        // O
        
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "aaaaa");
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");

        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();

        // MessageResources. returnNulltrueɂĂ̂ɒ
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01",
                true); 
        
        // NGXgMessageResourceso^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);

        // eXg{
        ActionForward forward
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));

        // VXeȌԕω̊mF
        // getMessage()͒PȂgetterł͂ȂAnull̂Ƃ̓G[R[hԋp̂Œ
        assertNull(UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }

    /**
     * testExecute09()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfigEx<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:MockActionMapping<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 SystemExceptionHandlerTest.error.message.null = null<br>
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *                  Oݒ̃W[FANVpX̃W[<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF"error.msg"<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * OݒExceptionConfigEx̏ꍇAOݒ̃W[ANVpX̃W[ɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute09() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message");
        
        // Oݒ
        ExceptionConfigEx eConfig = new ExceptionConfigEx();
        eConfig.setModule("error");
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");
        
        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
        = new PropertyMessageResources(factory,
            SystemExceptionHandler.class
            .getPackage().getName().replace('.', '/')
            + "/SystemExceptionHandler_MessageResources01");
        
        // NGXgMessageResourceso^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);

        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        assertEquals("error", forward.getModule());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));

        // VXeȌԕω̊mF
        assertEquals("ObZ[W",UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }
    
    
    
    /**
     * testExecute10()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() ex:SystemException optionString=null<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:MockActionMapping<br>
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 SystemExceptionHandlerTest.error.message.empty
     *                p<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONŁA<br>
     *                    SystemExceptiono^Ă邱ƁB<br>
     *         (ԕω) se:G[bZ[WF""<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    valuesnullł
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * bZ[W󕶎̎A󕶎񂪐ݒ肳邱ƁB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute10() throws Exception {
        // O
        
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message.empty");
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");

        ActionMapping mapping = new ActionMapping();
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");
        
        // NGXgMessageResourceso^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     

        // eXg{
        ActionForward forward  
            = handler.execute(e, eConfig, mapping, form, req, res);

        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));

        // VXeȌԕω̊mF
        assertEquals("", UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNull(actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }
    

    /**
     * testExecute11()
     * <br><br>
     * 
     * ُn
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ex:SystemException optionString={"1","22","333","4444","5555"}<br>
     *         () eConfig:ExceptionConfig<br>
     *               ypathtB[h"/errorPath.do"ݒ肳Ăz<br>
     *         () mapping:not null<br>
     *               yinputtB[h"/errorInput.do"ݒ肳Ăz
     *         () formInstance:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () bundle:null<br>
     *         () resources:yNGXgz<br>
     *                Globals.MESSAGES_KEYŎ擾ƈȉMessageResource܂MessageResourcesԂ<br>
     *                MessageResourceso<br>
     *                 SystemExceptionHandlerTest.error.message="ObZ[W"<br>
     *                }<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:tH[hF"/errorPath.do"<br>
     *         (ԕω) request:NGXgF<br>
     *                    PageContext.EXCEPTIONFSystemException<br>
     *         (ԕω) se:G[bZ[WF"ObZ[W"<br>
     *         (ԕω) ActionMessagesF"action.message.key"œo^Ă
     *                                    values{"1","22","333","4444","5555"}
     *                                    ł邱
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "sessionHash = " + sessionHash<br>
     *                    ExceptionUtil.getStackTrace(se)<br>
     *         
     * <br>
     * OݒpathƁAANV}bsOinputw肳Ă鎞ApathD悳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testExecute11() throws Exception {
        // O
    
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();
    
        String[] options = {"1","22","333","4444","5555"};
        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.error.message", options );
        
        // Oݒ
        ExceptionConfig eConfig = new ExceptionConfig();
        eConfig.setPath("/errorPath.do");
        eConfig.setKey("action.message.key");
        
        // ANV}bsOInputݒ
        ActionMapping mapping = new ActionMapping();
        mapping.setInput("/errorInput.do");
        
        DynaActionForm form = new DynaActionForm();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        MockServletContext context = new MockServletContext();
        
        // MessageResources̐ݒ
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");
    
        // NGXgMessageResourceso^
        req.setAttribute(Globals.MESSAGES_KEY, requestResources);
        
        // T[ubgReLXgNGXgQƂB
        session.setServletContext(context);
        req.setSession(session);     
    
        // eXg{
        ActionForward forward 
            = handler.execute(e, eConfig, mapping, form, req, res);
    
        // 
        
        // ߂l̊mF
        assertEquals("/errorPath.do", forward.getPath());
        
        // NGXg̏ԕω̊mF
        assertSame(e, req.getAttribute(PageContext.EXCEPTION));
        
        // Ȍԕω̊mF
        assertEquals("ObZ[W", UTUtil.getPrivateField(e, "message"));
        
        // ActionMessages̏ԕω̊mF
        ActionMessages messages
            = (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        assertEquals(1, messages.size());
        Iterator it = messages.get();
        while (it.hasNext()) {
            ActionMessage actionMessage = (ActionMessage) it.next();
            assertEquals("action.message.key", actionMessage.getKey());
            assertNotNull(actionMessage.getValues());
            assertEquals(options, actionMessage.getValues());
        }
        
        // Oo͂̊mF
        String sessionHash = RequestUtil.getSessionHash(req);
        assertTrue(LogUTUtil
            .checkError("sessionHash = " + sessionHash));
        assertTrue(LogUTUtil
            .checkError(ExceptionUtil.getStackTrace(e)));
    }

    /**
     * testGetErrorMessage01()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () se:not null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * G[R[hnull̎AbZ[Wnullŕԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testGetErrorMessage01() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO(G[R[hnull)
        SystemException e 
            = new SystemException(new Exception(), null);

        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // Ăяo
        Class[] clazz = {HttpServletRequest.class,
                         SystemException.class,
                         MessageResources.class};
        Object[] args = {req, e, requestResources};

        // eXg{
        Object result 
            = UTUtil.invokePrivate(handler, "getErrorMessage", clazz, args);

        // 
        assertNull(result);
    }

    /**
     * testGetErrorMessage02()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () se:not null<br>
     *         () resource:key="{0}ftHgbZ[W"<br>
     *                en_US.key="{0}message"<br>
     *         () locale:null<br>
     *         () errorCode:"key"<br>
     *         () option:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:"{0}ftHgbZ[W"<br>
     *         
     * <br>
     * P[Aunullł鎞AftHgP[̃bZ[Wuꂸɏo͂邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testGetErrorMessage02() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO(G[R[hnull)
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.key");
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // Ăяo
        Class[] clazz = {HttpServletRequest.class,
                         SystemException.class,
                         MessageResources.class};
        Object[] args = {req, e, requestResources};

        // eXg{
        // private\bhs
        Object result = UTUtil.invokePrivate(handler,
            "getErrorMessage", clazz, args);

        // 
        assertEquals("{0}ftHgbZ[W", (String)result);
    }

    /**
     * testGetErrorMessage03()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () se:not null<br>
     *         () resource:key="{0}ftHgbZ[W"<br>
     *                en_US.key="{0}message"<br>
     *         () locale:"en_US"<br>
     *         () errorCode:"key"<br>
     *         () option:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:"{0}message"<br>
     *         
     * <br>
     * P[w肳ꂽAw肳ꂽP[̃bZ[Wo͂邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testGetErrorMessage03() throws Exception {
        // O
        
        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.key");

        MockHttpServletRequest req = new MockHttpServletRequest();
        Locale locale = new Locale("en_US");
        req.setLocale(locale);

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // Ăяo
        Class[] clazz = {HttpServletRequest.class,
                         SystemException.class,
                         MessageResources.class};
        Object[] args = {req, e, requestResources};

        // eXg{
        Object result 
            = UTUtil.invokePrivate(handler, "getErrorMessage", clazz, args);

        // 
        assertEquals("{0}message", (String)result);
    }

    /**
     * testGetErrorMessage04()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () se:not null<br>
     *         () resource:key="{0}ftHgbZ[W"<br>
     *                en_US.key="{0}message"<br>
     *         () locale:null<br>
     *         () errorCode:"key"<br>
     *         () option:{"option1"}<br>
     *         
     * <br>
     * ҒlF(߂l) String:"option1ftHgbZ[W"<br>
     *         
     * <br>
     * u񂪎w肳ĂƂAbZ[W̒usȂ邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testGetErrorMessage04() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // G[bZ[Wu郁bZ[W
        String[] options = {"option1"};

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.key", options);

        MockHttpServletRequest req = new MockHttpServletRequest();

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // Ăяo
        Class[] clazz = {HttpServletRequest.class,
                         SystemException.class,
                         MessageResources.class};
        Object[] args = {req, e, requestResources};

        // eXg{
        Object result 
            = UTUtil.invokePrivate(handler, "getErrorMessage", clazz, args);

        // 
        assertEquals("option1ftHgbZ[W", (String)result);
    }

    /**
     * testGetErrorMessage05()
     * <br><br>
     * 
     * n
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () se:not null<br>
     *         () resource:key="{0}ftHgbZ[W"<br>
     *                en_US.key="{0}message"<br>
     *         () locale:"en_US"<br>
     *         () errorCode:"key"<br>
     *         () option:{"option1"}<br>
     *         
     * <br>
     * ҒlF(߂l) String:"option1message"<br>
     *         
     * <br>
     * P[Au񂪎w肳ꂽAw肳ꂽP[̃bZ[Wuďo͂邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("static-access")
    public void testGetErrorMessage05() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // G[bZ[Wu郁bZ[W
        String[] options = {"option1"};

        // VXeO
        SystemException e = new SystemException(new Exception(),
             "SystemExceptionHandlerTest.key", options);

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // P[ݒ
        Locale locale = new Locale("en_US");
        req.setLocale(locale);

        // MessageResources
        MessageResourcesFactory factory
            = PropertyMessageResourcesFactory.createFactory();
        PropertyMessageResources requestResources 
            = new PropertyMessageResources(factory,
                SystemExceptionHandler.class
                .getPackage().getName().replace('.', '/')
                + "/SystemExceptionHandler_MessageResources01");

        // Ăяo
        Class[] clazz = {HttpServletRequest.class,
                         SystemException.class,
                         MessageResources.class};
        Object[] args = {req, e, requestResources};

        // eXg{
        Object result 
            = UTUtil.invokePrivate(handler, "getErrorMessage", clazz, args);

        // 
        assertEquals("option1message", (String)result);
    }

    /**
     * testGetLogger01()
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF(O) log:-<br>
     * <br>
     * ҒlF(߂l) LogFactory.getLog(SystemExceptionHandler.class)Ɠ̃CX^X<br>
     * <br>
     * n1݂̂̃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetLogger01() throws Exception {
        // O

        // VXeOnh
        SystemExceptionHandler handler = new SystemExceptionHandler();

        // eXg{
        Log logger = handler.getLogger();

        // 
        assertSame(LogFactory.getLog(SystemExceptionHandler.class), logger);
    }
}
