/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.web.struts.ModuleUtil;
import jp.terasoluna.fw.web.struts.reset.Resetter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.ValidatorActionForm;

/**
 * Validatort[[NΉANVtH[NXB
 *
 * <p>
 * Struts ValidatorActionForm p
 * ANVtH[NXłB<br>
 * ĹAStrutsݒt@C(struts-config.xml) ŁÃNXp
 * ANVtH[̐ݒłB
 * <p>
 * <strong> Strutsݒt@C(struts-config.xml) ̃ANVtH[ݒ</strong>
 * </p>
 * <code><pre>
 * &lt;form-beans&gt;
 *  <b>&lt;form-bean
 *    name="_validateSampleForm"
 *    type="jp.terasoluna.sample.xxxx.SampleValidatorActionFormEx"
 *  &gt;</b>
 *  &lt;/form-bean&gt;
 * &lt;/form-beans&gt;
 * </pre></code>
 * &lt;form-bean&gt;^O name 
 * tH[_w肵Atype ɃNXw肷B<br>
 * tH[_̐擪 &quot;_&quot tARg[
 * RequestProcessorExw肷邱ƂɂA
 * ZbṼtH[̗BꐫۏႳB<br>
 * tH[͉̎L̂悤ɂȂB<br>
 * <p>
 * <strong>tH[</strong>
 * </p>
 * <code><pre>
 * public class SampleValidatorActionForm extends ValidatorActionFormEx {
 *
 *    // ID
 *    private String companyId = null;
 *    // [UID
 *    private String userId = null;
 *    // pX[h
 *    private String password = null;
 *    EEE
 *    // IDsetter
 *    public void setCompanyId(String companyId) {
 *        this.companyId = companyId;
 *    }
 *
 *    // IDgetter
 *    public String getCompanyId() {
 *        return companyId;
 *    }
 *    EEE
 * }
 * </pre></code>
 * tH[ŕێׂ̃tB[h쐬ÃtB[h
 * getter/setter LqB
 *
 * <p>
 * <strong>g_Œ񋟂@\</strong>
 * </p>
 * <ul>
 * <li>Zbg@\B<br>
 * T[ubgReLXgɐݒ肳Ă ResetterImpl NX
 *  reset() \bhNB<br></li>
 * <li>CfbNXtvpeB擾@\B<br>
 *  getIndexCount(String fieldName) ɂAΏۂ̃tB[h
 * 擾łB<br></li>
 * <li>CfbNXtvpeBݒ@\B<br>
 * zA List ̃CfbNX͈͊ÕZb^[\bhĂ΂ꂽ
 * ƂɓIɃCfbNX̗vf𑝉B<br></li>
 * <li>CfbNXtvpeB擾@\B<br>
 * zA List ̃CfbNX͈͊ÕQb^[\bhĂ΂ꂽ
 * Ƃ null ԋpB<br></li>
 * <li>tB[hlύXtOB<br>
 * BLogicMapperɂăANVtH[̃tB[hlύX̍ۂ
 * modifiedtrueɐݒ肵AύXsꂽǂmłB
 * <br></li>
 * </ul>
 *
 * @\̏ڍׂƂĎQlɂׂ
 * <ul>
 *  <li> Strutsݒt@C(struts-config.xml) ɋLq邱ƂɂA
 *   IɃtH[쐬ꍇ̐ݒɂẮA
 *    DynaValidatorActionFormEx QƁB</li>
 *  <li>tH[̗BꐫAtB[hlύXtȌڍׂɂẮA
 *     RequestProcessorEx QƁB</li>
 *  <li>ZbgEtB[hlNA@\ɂĂ̏ڍׂ́A ResetterImpl A
 *     ResetterPlugIn QƁB</li>
 *  <li>gof[V@\ɂĂ  FieldChecksEx Q</li>
 * </ul>
 * </p>
 *
 * @see
 *  jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx
 * @see jp.terasoluna.fw.web.struts.action.RequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.reset.Resetter
 * @see jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 *
 */
public class ValidatorActionFormEx
    extends ValidatorActionForm
    implements FormEx {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -744848917166154997L;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(ValidatorActionFormEx.class);

    /**
     * lύXtOB
     */
    private boolean modified = false;

    /**
     * w肵CfbNX̃vpeBl擾B
     *
     * @param name 擾Ώۂ̃vpeB
     * @param index 擾Ώۂ̃CfbNX
     * @return vpeBl
     */
    public Object getIndexedValue(String name, int index) {
        Object field = null;
        try {
            field = BeanUtil.getBeanProperty(this, name);
        } catch (PropertyAccessException e) {
            // DynaValidatorActionFormExƂ̎dlׁ̈A
            // Ȍ͍sȂȂB
        }
        if (field == null) {
            throw new NullPointerException(
                "No indexed value for '" + name + "[" + index + "]'");
        } else if (field.getClass().isArray()) {
            try {
                return (Array.get(field, index));
            } catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        } else if (field instanceof List) {
            try {
                return ((List) field).get(index);
            } catch (IndexOutOfBoundsException e) {
                return null;
            }
        } else {
            throw new IllegalArgumentException(
                "Non-indexed property for '" + name + "[" + index + "]'");
        }
    }

    /**
     * w肳ꂽtB[ȟ擾B
     *
     * @param fieldName 擾Ώۂ̃tB[hB
     * @return tB[hľB
     * <p>vpeB擾łȂꍇ0ԂB</p>
     */
    public int getIndexCount(String fieldName) {
        if (log.isDebugEnabled()) {
            log.debug("getIndexCount(" + fieldName + ") called.");
        }
        int count = 0;
        Object value = null;
        try {
            value = BeanUtil.getBeanProperty(this, fieldName);
        } catch (PropertyAccessException e) {
            // DynaValidatorActionFormExƂ̎dlׁ̈A
            // Ȍ͍sȂȂB
        }
        if (value == null) {
            count = 0;
        } else if (value.getClass().isArray()) {
            count = ((Object[]) value).length;
        } else if (value instanceof List) {
            count = ((List) value).size();
        } else if (value instanceof Map) {
            count = ((Map) value).size();
        } else {
            count = 1;
        }
        if (log.isDebugEnabled()) {
            log.debug("size = [" + count + "]");
        }
        return count;
    }

    /**
     * w肵CfbNẌʒuɃvpeBlݒ肷B
     *
     * @param name ݒΏۂ̃CfbNXtvpeB
     * @param index ݒΏۂ̃CfbNXʒu
     * @param value ݒ肷vpeBl
     */
    @SuppressWarnings("unchecked")
    public void setIndexedValue(String name, int index, Object value) {
        if (log.isDebugEnabled()) {
            log.debug(
                "set(" + name + ", " + index + ", " + value + ") called.");
        }

        Object prop = null;
        try {
            prop = BeanUtil.getBeanProperty(this, name);
        } catch (PropertyAccessException e) {
            // DynaValidatorActionFormExƂ̎dlׁ̈A
            // Ȍ͍sȂȂB
        }
        if (prop == null) {
            throw new NullPointerException(
                "No indexed value for '" + name + "[" + index + "]'");
        } else if (prop.getClass().isArray()) {
            if (index < Array.getLength(prop)) {
                Array.set(prop, index, value);
            } else {
                // CfbNX`FbN
                ActionFormUtil.checkIndexLength(index);
                // VK̔z𐶐
                Object newArray =
                    Array.newInstance(prop.getClass().getComponentType(),
                                                                    index + 1);
                // z̃R|[lgRs[
                System.arraycopy(prop, 0, newArray, 0, Array.getLength(prop));
                // ǉ̃R|[lgZbg
                Array.set(newArray, index, value);
                // QƂ̃Rs[
                prop = newArray;
            }
            try {
                BeanUtil.setBeanProperty(this, name, prop);
            } catch (PropertyAccessException e) {
                throw new IllegalArgumentException(
                    "Cannot set property for '" + name + "[" + index + "]'");
            }
        } else if (prop instanceof List) {
            if (index < ((List) prop).size()) {
                ((List) prop).set(index, value);
            } else {
                // CfbNX`FbN
                ActionFormUtil.checkIndexLength(index);
                Object[] oldValues = ((List) prop).toArray();
                Object[] newValues =
                    (Object[]) Array.newInstance(
                        oldValues.getClass().getComponentType(),
                        index + 1);
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[index] = value;
                ((List) prop).clear();
                ((List) prop).addAll(Arrays.asList(newValues));
            }
            try {
                BeanUtil.setBeanProperty(this, name, prop);
            } catch (PropertyAccessException e) {
                throw new IllegalArgumentException(
                    "Cannot set property for '" + name + "[" + index + "]'");
            }
        } else {
            throw new IllegalArgumentException(
                "Non-indexed property for '" + name + "[" + index + "]'");
        }

    }

    /**
     * lύXtO擾B
     *
     * @return lύXtO
     */
    public boolean isModified() {
        return this.modified;
    }

    /**
     * lύXtOݒ肷B
     *
     * @param modified lύXtO
     */
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    /**
     * ANVtH[̃tB[hlZbgsB
     *
     * @param mapping }bsO
     * @param request NGXg
     */
    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("reset() called.");
        }

        //Prefix擾
        String prefix = ModuleUtil.getPrefix(request);

        try {
            Resetter resetter =
                (Resetter) getServlet().getServletContext().getAttribute(
                    Resetter.RESETTER_KEY + prefix);
            if (resetter == null) {
                if (log.isDebugEnabled()) {
                    log.debug("resetter class is not specified.");
                }
                return;
            }
            resetter.reset(this, mapping, request);
        } catch (ClassCastException e) {
            log.error("", e);
            return;
        }
    }

}
