/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.terasoluna.fw.web.codelist.AbstractMultilingualCodeListLoader;
import jp.terasoluna.fw.web.codelist.CodeBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedCodeListLoader
extends AbstractMultilingualCodeListLoader {
    private Map<String, ?> codeListMap = null;

    public Map getCodeListMap() {
        return this.codeListMap;
    }

    public void setCodeListMap(Map<String, ?> codeListMap) {
        this.codeListMap = codeListMap;
    }

    @Override
    public void load() {
        if (this.localeMap != null) {
            return;
        }
        HashMap<Locale, List<CodeBean>> localeCodeListMap = new HashMap<Locale, List<CodeBean>>();
        if (this.codeListMap != null) {
            for (String key : this.codeListMap.keySet()) {
                List<CodeBean> list;
                Object value = this.codeListMap.get(key);
                if (value instanceof Map) {
                    Map clMap = (Map)value;
                    if (clMap == null) continue;
                    list = new ArrayList();
                    for (String id : clMap.keySet()) {
                        CodeBean cb = new CodeBean();
                        cb.setId(id);
                        cb.setName((String)clMap.get(id));
                        list.add(cb);
                    }
                    localeCodeListMap.put(this.createLocale(key), list);
                    continue;
                }
                if (!(value instanceof String)) continue;
                Locale locale = this.defaultLocale;
                list = (List)localeCodeListMap.get(locale);
                if (list == null) {
                    list = new ArrayList();
                }
                CodeBean cb = new CodeBean();
                cb.setId(key);
                cb.setName((String)value);
                list.add(cb);
                localeCodeListMap.put(locale, list);
            }
            for (Map.Entry entry : localeCodeListMap.entrySet()) {
                localeCodeListMap.put((Locale)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
        }
        this.localeMap = Collections.unmodifiableMap(localeCodeListMap);
    }

    Locale createLocale(String locale) {
        Locale result;
        if (locale == null || locale.length() == 0) {
            return this.defaultLocale;
        }
        String[] localeElements = locale.split("_", 3);
        switch (localeElements.length) {
            case 1: {
                result = this.createLocale(localeElements[0], "", "");
                break;
            }
            case 2: {
                result = this.createLocale(localeElements[0], localeElements[1], "");
                break;
            }
            case 3: {
                result = this.createLocale(localeElements[0], localeElements[1], localeElements[2]);
                break;
            }
            default: {
                result = Locale.getDefault();
            }
        }
        return result;
    }
}

