/*
 * Copyright (c) 2014 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.common.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Content-TypẽTCYsB
 * <p>
 * commons-fileupload̐Ǝ㐫CVE-2014-0050([vBcommons-fileupload-1.3.1ŏC)˂DoSUA
 * сA̗ގiɂDoSU(𒘂ቺBcommons-fileupload-1.3.1łC)A
 * VXe邽߂̃tB^B<br>
 * Content-TypẽoCg̃`FbNsA
 * TCY𒴂ĂꍇServletExceptionX[邱ƂŁA
 * commons-fileupload̓d͏DoSUpd͂Ȃ悤ɂB<br>
 * StrutsSpring̃t[[Ncommons-fileuploadɉ͂Ϗ̂́A
 * uNGXgɂĎsƖAPt@CAbv[h@\gpƂvł͂ȂA
 * uNGXg}`p[g`̂Ƃvł邽߁AtB^}bsÓA
 * t@CAbv[h@\𗘗ppXł͂ȂAt[[NServlet}bsOĂpXS(u*.dov)Ƀ}bsOKvB
 * </p>
 * <p>
 * ̃NX́A
 * 𒘂ቺDoSUA
 * commons-fileupload̋@\Ŗhł悤ɂȂ܂ł̊ԁA
 * ꎞIɉ񋟂邽߂̂̂łB<br>
 * commons-fileupload̃o[WAbvÃNXContent-TypẽTCY𐧌ɁA
 * commons-fileuploadg̋@\Ő邱ƂlA
 * Content-TypẽTCYI[o[́AŗL̃G[ʂł͂ȂA
 * ėp̃G[ʂɑJڂ悤ݒ肷邱Ƃ𐄏B
 * (̂߂ɁÃtB^X[Oɂ́AŗL̗Oł͂ȂAServletExceptiongpĂB)
 * </p>
 * <h5>gp@</h5> ̋@\gpɂ̓fvCgfBXNv^iweb.xmljɈȉ̂悤ɐݒ肷B<br>
 * <br>
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;contentTypeLengthLimitFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;jp.terasoluna.fw.web.common.filter.ContentTypeLengthLimitFilter&lt;/filter-class&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;limitBytes&lt;/param-name&gt;
 *     &lt;param-value&gt;2048&lt;/param-value&gt;
 *   &lt;/init-param&gt;
 * &lt;/filter&gt;
 * 
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;contentTypeLengthLimitFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;*.do&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * 
 * &lt;error-page&gt;
 *   &lt;exception-type&gt;javax.servlet.ServletException&lt;/exception-type&gt;
 *   &lt;location&gt;/error.jsp&lt;/location&gt;
 * &lt;/error-page&gt;
 * </pre></code> <br>
 * ȂAp[^ɂāAftHgl(limitBytes=2048)𗘗pꍇ́A fvCgfBXNv^
 * iweb.xmlj&lt;filter&gt;vf&lt;init-param&gt;vfȗ邱ƂłB<br>
 * ܂AG[y[W̐ݒɊւẮA
 * javax.servlet.ServletException܂java.lang.Exception̐ݒ肪݂A
 * ėp̃G[ʂɑJڂ悤ɂȂĂ΁A
 * ̃tB^ׂ̈ɒǉ&lt;error-page&gt;vfݒ肷Kv͂ȂB
 */
public class ContentTypeLengthLimitFilter implements Filter {

    /**
     * ONXB
     */
    private static final Log log =
            LogFactory.getLog(ContentTypeLengthLimitFilter.class);

    /**
     * p[^limitBytes̃ftHgl(2048)B
     */
    private static final int DEFAULT_LIMIT_BYTES = 2048;

    /**
     * p[^limitBytesB
     * <p>
     * NGXgwb_Content-TypẽoCg̏lB
     * </p>
     */
    private int limitBytes = DEFAULT_LIMIT_BYTES;

    /**
     * Content-TypẽTCY`FbNsB
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest req, ServletResponse res,
            FilterChain chain) throws IOException, ServletException {
        String contentType = req.getContentType();
        if (log.isDebugEnabled()) {
            log.debug("Content-Type : " + contentType);
        }

        if (contentType != null) {
            byte[] contentTypeBytes = null;
            try {
                contentTypeBytes = contentType.getBytes("ISO-8859-1");
            } catch (UnsupportedEncodingException e) {
                // Java̎dlςȂA
                // ISO-8859-1͂ǂJavavbgtH[łT|[ĝł邽߁A
                // 炪s邱Ƃ͂܂ȂB
                // commons-fileuploadboundarybytezɂƂ̏ɍ킹ĎĂB
                contentTypeBytes = contentType.getBytes();
            }
            if (contentTypeBytes.length > limitBytes) {
                log.error("Content-Type header is too long. Limit size is "
                        + limitBytes + " byte. Actual size is "
                        + contentTypeBytes.length + " byte.");
                throw new ServletException("Content-Type header is too long.");
            }
        }

        chain.doFilter(req, res);
    }

    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB ReíAFilterCX^XɁAinit\bh 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A init \bh IĂȂ΂ȂȂB init\bh ̂ꂩ̏Ԃ̏ꍇARei FilterT[rXԂɂłȂB<br>
     * <ul>
     * <li>ServletException X[B</li>
     * <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     * <li>ݒُ펞B</li>
     * </ul>
     * @param config FilterConfigCX^XB
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) throws ServletException {
        String limitBytesStr = config.getInitParameter("limitBytes");
        if (limitBytesStr != null) {
            limitBytes = Integer.parseInt(limitBytesStr);
        }

        if (log.isDebugEnabled()) {
            log.debug("limitBytes = " + limitBytes);
        }
    }

    /**
     * T[rXԂItB^ɓ`邽߂ɁAReiĂяoB<br>
     * ̃NXł͏͍sȂȂB
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
    }

}
