/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopic;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MockTopicSubscriber
extends MockMessageConsumer
implements TopicSubscriber {
    private MockSession session;
    private MockTopic topic;
    private boolean noLocal;
    private String name;
    private boolean isDurable;

    public MockTopicSubscriber(MockConnection mockConnection, MockSession mockSession, MockTopic mockTopic) {
        this(mockConnection, mockSession, mockTopic, null, false);
    }

    public MockTopicSubscriber(MockConnection mockConnection, MockSession mockSession, MockTopic mockTopic, String string, boolean bl) {
        super(mockConnection, string);
        this.session = mockSession;
        this.topic = mockTopic;
        this.noLocal = bl;
        this.name = null;
        this.isDurable = false;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public void setDurable(boolean bl) {
        this.isDurable = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Topic getTopic() throws JMSException {
        this.getConnection().throwJMSException();
        return this.topic;
    }

    public boolean getNoLocal() throws JMSException {
        this.getConnection().throwJMSException();
        return this.noLocal;
    }

    public Message receive() throws JMSException {
        this.getConnection().throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Subscriber is closed");
        }
        if (this.topic.isEmpty()) {
            return null;
        }
        Message message = !this.getConnection().getConfigurationManager().getUseMessageSelectors() || null == this.getMessageFilter() ? this.topic.getMessage() : this.topic.getMatchingMessage(this.getMessageFilter());
        if (null == message) {
            return null;
        }
        if (this.session.isAutoAcknowledge()) {
            message.acknowledge();
        }
        return message;
    }
}

