/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.common.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentTypeLengthLimitFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ContentTypeLengthLimitFilter.class);
    private static final int DEFAULT_LIMIT_BYTES = 2048;
    private int limitBytes = 2048;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String contentType = req.getContentType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Content-Type : " + contentType));
        }
        if (contentType != null) {
            byte[] contentTypeBytes = null;
            try {
                contentTypeBytes = contentType.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                contentTypeBytes = contentType.getBytes();
            }
            if (contentTypeBytes.length > this.limitBytes) {
                log.error((Object)("Content-Type header is too long. Limit size is " + this.limitBytes + " byte. Actual size is " + contentTypeBytes.length + " byte."));
                throw new ServletException("Content-Type header is too long.");
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig config) throws ServletException {
        String limitBytesStr = config.getInitParameter("limitBytes");
        if (limitBytesStr != null) {
            this.limitBytes = Integer.parseInt(limitBytesStr);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("limitBytes = " + this.limitBytes));
        }
    }

    public void destroy() {
    }
}

