/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.apache.commons.lang.StringUtils;

/**
 * {@link BLogicIO}IuWFNg\z邽߂̃[eBeBNXłB <br>
 * rWlXWbNo̓NXɕt^ꂽ{@link BLogicParamField}Ame[VA{@link BLogicResultField} Ame[VA{@link BLogicIOField}Ame[V͂A
 * {@link BLogicIO} IuWFNg\z܂B
 * <p>
 * <li>rWlXWbN͏NX̃tB[hɕt^ꂽAme[V</li><br>
 * <ol>
 * <li>{@link BLogicParamField}Ame[VD悵ĎQƂ܂B</li>
 * <li>{@link BLogicParamField}Ame[V݂Ȃꍇ{@link BLogicIOField}Ame[VQƂ܂B</li>
 * </ol>
 * </p>
 * <p>
 * <li>rWlXWbNo͏NX̃tB[hɕt^ꂽAme[V</li><br>
 * <ol>
 * <li>{@link BLogicResultField}Ame[VD悵ĎQƂ܂B</li>
 * <li>{@link BLogicResultField}Ame[V݂Ȃꍇ{@link BLogicIOField}Ame[VQƂ܂B</li>
 * </ol>
 * </p>
 */
public class BLogicIOUtil {

    // rWlXWbN͏
    private static final int BLOGIC_IO_PARAMS = 0;

    // rWlXWbNo͏
    private static final int BLOGIC_IO_RESULT = 1;

    /** BLogicIOLbViBLogic̓IuWFNgj */
    protected static ConcurrentMap<Class<?>, BLogicIO> blogicParamMap = new ConcurrentHashMap<Class<?>, BLogicIO>();

    /** BLogicIOLbViBLogico̓IuWFNgj */
    protected static ConcurrentMap<Class<?>, BLogicIO> blogicResultMap = new ConcurrentHashMap<Class<?>, BLogicIO>();

    /** BLogic̓̓NX̃LbV */
    protected static ConcurrentMap<Class<?>, Class<?>> inputClassMap = new ConcurrentHashMap<Class<?>, Class<?>>();

    /**
     * BLogicIOUtilRXgN^
     */
    private BLogicIOUtil() {
    }

    /**
     * rWlXWbN͏NX̌^w肵āA{@link BLogicIO}IuWFNg\z܂B
     * @param inputBeanClass rWlXWbN͏NX̌^
     * @return BLogicIOIuWFNg
     */
    public static BLogicIO createBLogicIOForBLogicParams(Class<?> inputBeanClass) {
        BLogicIO io = null;

        if (inputBeanClass != null) {
            // LbV擾
            io = getBlogicParamCache(inputBeanClass);
        }

        if (io == null) {
            io = new BLogicIO();

            if (inputBeanClass != null) {
                io.setInputBeanName(inputBeanClass.getName());

                Collection<BLogicProperty> logicPropertyCollectionForBLogicParams = createBLogicPropertyCollection(
                        inputBeanClass, BLOGIC_IO_PARAMS);

                for (BLogicProperty logicProperty : logicPropertyCollectionForBLogicParams) {
                    io.setBLogicParam(logicProperty);
                }
                // LbVɊi[
                setBlogicParamCache(inputBeanClass, io);
            }
        }
        return io;
    }

    /**
     * rWlXWbNo͏IuWFNg{@link BLogicIO}IuWFNg\z܂B
     * @param resultBeanClass rWlXWbN̏o͏NX̌^
     * @return BLogicIOIuWFNg
     */
    public static BLogicIO createBLogicIOForBLogicResult(
            Class<?> resultBeanClass) {
        BLogicIO logicIO = new BLogicIO();
        if (resultBeanClass != null) {
            Collection<BLogicProperty> logicPropertyCollectionForBLogicResult = createBLogicPropertyCollection(
                    resultBeanClass, BLOGIC_IO_RESULT);
            for (BLogicProperty logicProperty : logicPropertyCollectionForBLogicResult) {
                logicIO.setBLogicResult(logicProperty);
            }
        }
        return logicIO;
    }

    /**
     * @param beanClass rWlXWbN͏NX̌^
     * @param target 0:rWlXWbN͏NX 1:rWlXWbNo͏NX
     * @return rWlXWbNo̓vpeB̃RNV
     */
    private static Collection<BLogicProperty> createBLogicPropertyCollection(
            Class<?> beanClass, int target) {
        return createBLogicPropertyMap(beanClass, target).values();
    }

    /**
     * @param beanClass rWlXWbN͏NX̌^
     * @param target 0:rWlXWbN͏NX 1:rWlXWbNo͏NX
     * @return rWlXWbNo̓vpeB̃}bv
     */
    private static Map<String, BLogicProperty> createBLogicPropertyMap(
            Class<?> beanClass, int target) {
        Map<String, BLogicProperty> logicPropertyMap = new LinkedHashMap<String, BLogicProperty>();
        Class<?> superClass = beanClass.getSuperclass();
        if (superClass != null) {
            logicPropertyMap
                    .putAll(createBLogicPropertyMap(superClass, target));
        }
        for (Field field : beanClass.getDeclaredFields()) {
            BLogicIOFieldBean blogicIOFieldBean = null;

            if (target == BLOGIC_IO_PARAMS
                    && field.isAnnotationPresent(BLogicParamField.class)) {
                blogicIOFieldBean = new BLogicIOFieldBean(field
                        .getAnnotation(BLogicParamField.class));
            } else if (target == BLOGIC_IO_RESULT
                    && field.isAnnotationPresent(BLogicResultField.class)) {
                blogicIOFieldBean = new BLogicIOFieldBean(field
                        .getAnnotation(BLogicResultField.class));
            } else if (field.isAnnotationPresent(BLogicIOField.class)) {
                blogicIOFieldBean = new BLogicIOFieldBean(field
                        .getAnnotation(BLogicIOField.class));
            }

            if (blogicIOFieldBean != null) {
                BLogicProperty logicProperty = createBLogicProperty(field,
                        blogicIOFieldBean);
                if (target == BLOGIC_IO_PARAMS) {
                    logicProperty.setSource(blogicIOFieldBean.getTarget()
                            .getValue());
                } else if (target == BLOGIC_IO_RESULT) {
                    logicProperty.setDest(blogicIOFieldBean.getTarget()
                            .getValue());
                }
                logicPropertyMap.put(logicProperty.getBLogicProperty(),
                        logicProperty);
            }
        }
        return logicPropertyMap;
    }

    /**
     * @param field tB[h
     * @param blogicIOFieldBean BLogicIOFieldBeaniAme[V̒lj
     * @return rWlXWbNo̓vpeB
     */
    private static BLogicProperty createBLogicProperty(Field field,
            BLogicIOFieldBean blogicIOFieldBean) {
        BLogicProperty logicProperty = new BLogicProperty();
        logicProperty.setBLogicProperty(field.getName());
        String property = blogicIOFieldBean.getProperty();
        if (StringUtils.isEmpty(property)) {
            property = field.getName();
        }
        logicProperty.setProperty(property);
        return logicProperty;
    }

    /**
     * BLogicIOLbViBLogic̓IuWFNgjNXɑΉBLogicIOCX^X擾
     * @param targetClass
     * @return
     */
    public static BLogicIO getBlogicParamCache(Class<?> targetClass) {
        return blogicParamMap.get(targetClass);
    }

    /**
     * BLogicIOLbViBLogic̓IuWFNgjNXɑΉBLogicIOCX^Xݒ肷
     * @param targetClass
     * @param blogicIo
     */
    public static void setBlogicParamCache(Class<?> targetClass,
            BLogicIO blogicIo) {
        blogicParamMap.put(targetClass, blogicIo);
    }

    /**
     * BLogicIOLbViBLogico̓IuWFNgjNXɑΉBLogicIOCX^X擾
     * @param targetClass
     * @return
     */
    public static BLogicIO getBlogicResultCache(Class<?> targetClass) {
        return blogicResultMap.get(targetClass);
    }

    /**
     * BLogicIOLbViBLogico̓IuWFNgjNXɑΉBLogicIOCX^Xݒ肷
     * @param targetClass
     * @param blogicIo
     */
    public static void setBlogicResultCache(Class<?> targetClass,
            BLogicIO blogicIo) {
        blogicResultMap.put(targetClass, blogicIo);
    }

    /**
     * BLogic̓̓NX̃LbV擾
     * @param targetClass
     * @return
     */
    public static Class<?> getInputClassCache(Class<?> targetClass) {
        return inputClassMap.get(targetClass);
    }

    /**
     * BLogic̓̓NX̃LbVݒ肷
     * @param targetClass
     * @param cacheClass
     */
    public static void setInputClassCache(Class<?> targetClass,
            Class<?> cacheClass) {
        inputClassMap.put(targetClass, cacheClass);
    }

    /**
     * BLogicIOLbViBLogic̓IuWFNgj擾
     * @return BLogicIOLbViBLogic̓IuWFNgj
     */
    public static ConcurrentMap<Class<?>, BLogicIO> getBlogicParamMap() {
        return blogicParamMap;
    }

    /**
     * BLogicIOLbViBLogico̓IuWFNgj擾
     * @return BLogicIOLbViBLogico̓IuWFNgj
     */
    public static ConcurrentMap<Class<?>, BLogicIO> getBlogicResultMap() {
        return blogicResultMap;
    }

    /**
     * BLogic̓̓NX̃LbV擾
     * @return BLogic̓̓NX̃LbV
     */
    public static ConcurrentMap<Class<?>, Class<?>> getInputClassMap() {
        return inputClassMap;
    }
}
