/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_03.blogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.toursample.common.Constants;
import jp.terasoluna.toursample.common.blogic.PriceCalculateBLogic;
import jp.terasoluna.toursample.common.blogic.ReserveDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireInput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.uc_a01_03.dto.RP_A01_03_01_02Input;
import jp.terasoluna.toursample.uc_a01_03.dto.RP_A01_03_01_02Output;

/**
 * cA[\ύXmFBLogicNXB<br>
 * 
 * EUC_A01_03FcA[\ύX
 * 
 * 
 */
public class RP_A01_03_01_02BLogicImpl implements BLogic<RP_A01_03_01_02Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_RESERVED = "error.common.00008";

    /**
     * \ڍ׏擾NX(ʏCP0006)B SpringɂCX^Xݒ肳B
     */
    protected ReserveDetailAcquireBLogic reserveDetailAcquireBLogic = null;

    /**
     * ʏCP0006ݒ肷B
     * 
     * @param reserveDetailAcquireBLogic
     *            ݒ肷鋤ʏCP0006
     */
    public void setReserveDetailAcquireBLogic(
            ReserveDetailAcquireBLogic reserveDetailAcquireBLogic) {

        this.reserveDetailAcquireBLogic = reserveDetailAcquireBLogic;
    }

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_03_01_02BLogicImpl.class);
    
    /**
     * vZNX(ʏCP0009)B SpringɂCX^Xݒ肳B
     */
    protected PriceCalculateBLogic priceCalculateBLogic = null;

    /**
     * cA[\ύXmFrWlXWbNB<br>
     * cA[ƃcA[ɎQlPAvvZA \emFB<br>
     * 
     * @param params
     *            vZp̏
     * @return cA[\ڍ׏
     */
    public BLogicResult execute(RP_A01_03_01_02Input params) {

        // o͏i[NX𐶐B
        RP_A01_03_01_02Output result = new RP_A01_03_01_02Output();
        
        // \ڍ׏擾̈̃NX𐶐B
        ReserveDetailAcquireInput reserveDetailAcquireInput = 
            new ReserveDetailAcquireInput();

        // \ڍ׏擾̈ݒ肷B
        reserveDetailAcquireInput.setReserveNo(params.getReserveNo());
        reserveDetailAcquireInput.setCustomerCode(params.getUSER_VALUE_OBJECT()
            .getCustomerCode());
 
        // \ڍ׏擾(ʏCP0006)B
        ReserveDetailAcquireOutput reserveDetail = 
            reserveDetailAcquireBLogic.execute(reserveDetailAcquireInput);
        
        // \񂪂ȂꍇAOsB
        // ONXFRecordNotFoundException
        if (reserveDetail == null) {

            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_RESERVED + ":\񂪌܂B");
            }

            throw new RecordNotFoundException(ERROR_NOT_RESERVED);
        }
        
        //ӌv]ƑllAqlݒ肷
        reserveDetail.setAdultCount(params.getReserveDetail().getAdultCount());
        reserveDetail.setChildCount(params.getReserveDetail().getChildCount());
        reserveDetail.setRemarks(params.getReserveDetail().getRemarks());
        
        // vZ(ʏFCP0009)B
        PriceCalculateOutput price = 
            priceCalculateBLogic.execute(reserveDetail.getBasePrice(), 
                                        reserveDetail.getAdultCount(), 
                                        reserveDetail.getChildCount());

        // cA[\mFo͒lɃZbgB
        result.setReserveDetail(reserveDetail);
        result.setPrice(price);
        result.setPaymentMethod(PropertyUtil
            .getProperty(Constants.PAYMENT_METHOD));
        result.setPaymentCompanyName(PropertyUtil
            .getProperty(Constants.PAYMENT_COMPANY_NAME));
        result.setPaymentAccount(PropertyUtil
            .getProperty(Constants.PAYMENT_ACCOUNT));
        result.setReferenceName(PropertyUtil
            .getProperty(Constants.COMPANY_NAME));
        result.setReferenceEmail(PropertyUtil
            .getProperty(Constants.COMPANY_MAIL));
        result.setReferenceTel(PropertyUtil.getProperty(Constants.COMPANY_TEL));

        // o͒l𐶐B
        BLogicResult bResult = new BLogicResult();
        bResult.setResultObject(result);
        bResult.setResultString("success");

        return bResult;
    }

    /**
     * vZNX(ʏCP0009)ݒ肷B
     * 
     * @param priceCalculateBLogic
     *            vZNX(ʏCP0009)
     */
    public void setPriceCalculateBLogic(
            PriceCalculateBLogic priceCalculateBLogic) {

        this.priceCalculateBLogic = priceCalculateBLogic;
    }

}