/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_01.blogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.exception.TourSystemException;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_02_03Input;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_02_03Output;
import jp.terasoluna.toursample.uc_a01_01.dto.SearchCondition;


/**
 * cA[\o^擾rWlXWbNB<br>
 * RP_A01_01_02_02BLogicŃobNAbvcA[擾AtH[ւ
 * fsȂB<br>
 * obNAbvcA[̎擾Ɏsꍇ
 * {@link TourSystemException}B
 * 
 * 
 * 
 * 
 */
public class RP_A01_01_02_03BLogicImpl
        implements BLogic<RP_A01_01_02_03Input> {

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_01_02_03BLogicImpl.class);

    /**
     * ZbVobNAbvcA[̎擾Ɏsꍇ
     * G[bZ[WR[hB
     */
    private static final String GET_CONDITION_ERROR =
        "error.UC_A01_01.00003";
    
    /**
     * ZbVɐݒ肳Ăi[IuWFNg 擾A
     * successԋpB<br>
     * 擾łȂꍇ{@link TourSystemException}B
     * 
     * @param param
     *            i[IuWFNg
     * @return 
     * 
     * @throws TourSystemException cA[i[IuWFNg̎擾
     *              sꍇ
     */
    public BLogicResult execute(RP_A01_01_02_03Input param) {

        // ԋpl𐶐B
        BLogicResult result = new BLogicResult();

        // ZbVɓIuWFNg𐶐B
        RP_A01_01_02_03Output output = new RP_A01_01_02_03Output();

        // 擾łȂƂɂ̓G[ԋp
        if (param.getCondition() == null) {
            if (log.isErrorEnabled()) {
                log.error(GET_CONDITION_ERROR + ": pbNAbvcA["
                            + "̎擾s܂B");
            }
            throw new TourSystemException(GET_CONDITION_ERROR);
            
        } else {

            // 擾o͒lɃZbgB
            SearchCondition condition = param.getCondition();
            output.setAdultCountCondition(condition.getAdultCountCondition());
            output.setArrCodeCondition(condition.getArrCodeCondition());
            output.setBasePriceCondition(condition.getBasePriceCondition());
            output.setChildCountCondition(condition.getChildCountCondition());
            output.setDepCodeCondition(condition.getDepCodeCondition());
            output.setDepDayDayCondition(condition.getDepDayDayCondition());
            output.setDepDayMonthCondition(condition.getDepDayMonthCondition());
            output.setDepDayYearCondition(condition.getDepDayYearCondition());
            output.setTourCode(condition.getTourCode());
            output.setTourDaysCondition(condition.getTourDaysCondition());
            output.setStartIndex(condition.getStartIndex());
            output.setRow(condition.getRow());

            // ԋplɐݒ肷
            result.setResultString("success");
            result.setResultObject(output);
            return result;
        }
    }
}
