/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public class ImageServlet
extends BaseHttpServlet {
    public static final String IMAGE_NAME_REQUEST_PARAMETER = "image";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] imageData = null;
        String imageMimeType = null;
        String imageName = request.getParameter(IMAGE_NAME_REQUEST_PARAMETER);
        if ("px".equals(imageName)) {
            try {
                JRRenderable pxRenderer = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF", (byte)1);
                imageData = pxRenderer.getImageData();
            }
            catch (JRException e) {
                throw new ServletException((Throwable)e);
            }
        }
        List jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        JRPrintImage image = JRHtmlExporter.getImage(jasperPrintList, imageName);
        JRRenderable renderer = image.getRenderer();
        if (renderer.getType() == 1) {
            renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
        }
        imageMimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType());
        try {
            imageData = renderer.getImageData();
        }
        catch (JRException e) {
            throw new ServletException((Throwable)e);
        }
        if (imageData != null && imageData.length > 0) {
            if (imageMimeType != null) {
                response.setHeader("Content-Type", imageMimeType);
            }
            response.setContentLength(imageData.length);
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(imageData, 0, imageData.length);
            ouputStream.flush();
            ouputStream.close();
        }
    }
}

