/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.jfree.chart.plot.PlotOrientation;
import org.xml.sax.Attributes;

public class JRChartPlotFactory
extends JRBaseFactory {
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_orientation = "orientation";
    private static final String ATTRIBUTE_backgroundAlpha = "backgroundAlpha";
    private static final String ATTRIBUTE_foregroundAlpha = "foregroundAlpha";
    private static final String ATTRIBUTE_labelRotation = "labelRotation";

    public Object createObject(Attributes atts) {
        String labelRotation;
        String backgroundAlpha;
        String foregroundAlpha;
        String orientation;
        JRChartPlot plot = (JRChartPlot)this.digester.peek();
        Color color = JRXmlConstants.getColor(atts.getValue(ATTRIBUTE_backcolor), Color.black);
        if (color != null) {
            plot.setBackcolor(color);
        }
        if ((orientation = atts.getValue(ATTRIBUTE_orientation)) != null && orientation.length() > 0) {
            plot.setOrientation((PlotOrientation)JRXmlConstants.getPlotOrientationMap().get(orientation));
        }
        if ((foregroundAlpha = atts.getValue(ATTRIBUTE_foregroundAlpha)) != null && foregroundAlpha.length() > 0) {
            plot.setForegroundAlpha(Float.valueOf(foregroundAlpha).floatValue());
        }
        if ((backgroundAlpha = atts.getValue(ATTRIBUTE_backgroundAlpha)) != null && backgroundAlpha.length() > 0) {
            plot.setBackgroundAlpha(Float.valueOf(backgroundAlpha).floatValue());
        }
        if ((labelRotation = atts.getValue(ATTRIBUTE_labelRotation)) != null && labelRotation.length() > 0) {
            plot.setLabelRotation(Double.valueOf(labelRotation));
        }
        return plot;
    }

    public static class JRSeriesColorFactory
    extends JRBaseFactory {
        public static final String ATTRIBUTE_seriesOrder = "seriesOrder";
        public static final String ATTRIBUTE_color = "color";

        public Object createObject(Attributes atts) {
            String colorName;
            int seriesIndex = -1;
            Color color = null;
            String seriesNumber = atts.getValue(ATTRIBUTE_seriesOrder);
            if (seriesNumber != null && seriesNumber.length() > 0) {
                seriesIndex = Integer.valueOf(seriesNumber);
            }
            if ((colorName = atts.getValue(ATTRIBUTE_color)) != null && colorName.length() > 0) {
                color = JRXmlConstants.getColor(colorName, null);
            }
            return new JRBaseChartPlot.JRBaseSeriesColor(seriesIndex, color);
        }
    }
}

