/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseTextElement
extends JRBaseElement
implements JRTextElement {
    private static final long serialVersionUID = 10200L;
    protected Byte horizontalAlignment;
    protected Byte verticalAlignment;
    protected Byte rotation;
    protected Byte lineSpacing;
    protected Boolean isStyledText;
    protected Byte border;
    protected Byte topBorder = null;
    protected Byte leftBorder = null;
    protected Byte bottomBorder = null;
    protected Byte rightBorder = null;
    protected Color borderColor = null;
    protected Color topBorderColor = null;
    protected Color leftBorderColor = null;
    protected Color bottomBorderColor = null;
    protected Color rightBorderColor = null;
    protected Integer padding;
    protected Integer topPadding = null;
    protected Integer leftPadding = null;
    protected Integer bottomPadding = null;
    protected Integer rightPadding = null;
    protected JRReportFont reportFont = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;

    protected JRBaseTextElement(JRTextElement textElement, JRBaseObjectFactory factory) {
        super(textElement, factory);
        this.horizontalAlignment = textElement.getOwnHorizontalAlignment();
        this.verticalAlignment = textElement.getOwnVerticalAlignment();
        this.rotation = textElement.getOwnRotation();
        this.lineSpacing = textElement.getOwnLineSpacing();
        this.isStyledText = textElement.isOwnStyledText();
        this.border = textElement.getOwnBorder();
        this.topBorder = textElement.getOwnTopBorder();
        this.leftBorder = textElement.getOwnLeftBorder();
        this.bottomBorder = textElement.getOwnBottomBorder();
        this.rightBorder = textElement.getOwnRightBorder();
        this.borderColor = textElement.getOwnBorderColor();
        this.topBorderColor = textElement.getOwnTopBorderColor();
        this.leftBorderColor = textElement.getOwnLeftBorderColor();
        this.bottomBorderColor = textElement.getOwnBottomBorderColor();
        this.rightBorderColor = textElement.getOwnRightBorderColor();
        this.padding = textElement.getOwnPadding();
        this.topPadding = textElement.getOwnTopPadding();
        this.leftPadding = textElement.getOwnLeftPadding();
        this.bottomPadding = textElement.getOwnBottomPadding();
        this.rightPadding = textElement.getOwnRightPadding();
        this.reportFont = factory.getReportFont(textElement.getReportFont());
        this.fontName = textElement.getOwnFontName();
        this.isBold = textElement.isOwnBold();
        this.isItalic = textElement.isOwnItalic();
        this.isUnderline = textElement.isOwnUnderline();
        this.isStrikeThrough = textElement.isOwnStrikeThrough();
        this.fontSize = textElement.getOwnFontSize();
        this.pdfFontName = textElement.getOwnPdfFontName();
        this.pdfEncoding = textElement.getOwnPdfEncoding();
        this.isPdfEmbedded = textElement.isOwnPdfEmbedded();
    }

    protected JRFont getBaseFont() {
        if (this.reportFont != null) {
            return this.reportFont;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultFont();
        }
        return null;
    }

    public byte getTextAlignment() {
        if (this.horizontalAlignment == null) {
            JRStyle style = this.getBaseStyle();
            if (style != null && style.getHorizontalAlignment() != null) {
                return style.getHorizontalAlignment();
            }
            return 1;
        }
        return this.horizontalAlignment;
    }

    public void setTextAlignment(byte horizontalAlignment) {
        this.horizontalAlignment = new Byte(horizontalAlignment);
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.horizontalAlignment = new Byte(horizontalAlignment);
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(byte verticalAlignment) {
        this.verticalAlignment = new Byte(verticalAlignment);
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return this.rotation;
    }

    public void setRotation(byte rotation) {
        this.rotation = new Byte(rotation);
    }

    public void setRotation(Byte rotation) {
        this.rotation = rotation;
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(byte lineSpacing) {
        this.lineSpacing = new Byte(lineSpacing);
    }

    public void setLineSpacing(Byte lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    public Boolean isOwnStyledText() {
        return this.isStyledText;
    }

    public void setStyledText(boolean isStyledText) {
        this.setStyledText(isStyledText ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStyledText(Boolean isStyledText) {
        this.isStyledText = isStyledText;
    }

    public JRBox getBox() {
        return this;
    }

    public JRFont getFont() {
        return this;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    public Byte getOwnBorder() {
        return this.border;
    }

    public void setBorder(byte border) {
        this.border = new Byte(border);
    }

    public void setBorder(Byte border) {
        this.border = border;
    }

    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    public Color getOwnBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    public Integer getOwnPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = new Integer(padding);
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    public Byte getOwnTopBorder() {
        return this.topBorder;
    }

    public void setTopBorder(byte topBorder) {
        this.topBorder = new Byte(topBorder);
    }

    public void setTopBorder(Byte topBorder) {
        this.topBorder = topBorder;
    }

    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    public Color getOwnTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    public Integer getOwnTopPadding() {
        return this.topPadding;
    }

    public void setTopPadding(int topPadding) {
        this.topPadding = new Integer(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.topPadding = topPadding;
    }

    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    public Byte getOwnLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(byte leftBorder) {
        this.leftBorder = new Byte(leftBorder);
    }

    public void setLeftBorder(Byte leftBorder) {
        this.leftBorder = leftBorder;
    }

    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    public Color getOwnLeftBorderColor() {
        return this.leftBorderColor;
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    public Integer getOwnLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(int leftPadding) {
        this.leftPadding = new Integer(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.leftPadding = leftPadding;
    }

    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    public Byte getOwnBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(byte bottomBorder) {
        this.bottomBorder = new Byte(bottomBorder);
    }

    public void setBottomBorder(Byte bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    public Color getOwnBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    public Integer getOwnBottomPadding() {
        return this.bottomPadding;
    }

    public void setBottomPadding(int bottomPadding) {
        this.bottomPadding = new Integer(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    public Byte getOwnRightBorder() {
        return this.rightBorder;
    }

    public void setRightBorder(byte rightBorder) {
        this.rightBorder = new Byte(rightBorder);
    }

    public void setRightBorder(Byte rightBorder) {
        this.rightBorder = rightBorder;
    }

    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    public Color getOwnRightBorderColor() {
        return this.rightBorderColor;
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    public Integer getOwnRightPadding() {
        return this.rightPadding;
    }

    public void setRightPadding(int rightPadding) {
        this.rightPadding = new Integer(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.rightPadding = rightPadding;
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
        this.reportFont = reportFont;
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
        this.setFontSize(size);
    }

    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }
}

